/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.test.container;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jboss.netty.bootstrap.ServerBootstrap;
import org.jboss.netty.buffer.DirectChannelBufferFactory;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelFactory;
import org.jboss.netty.channel.ChannelFuture;
import org.jboss.netty.channel.ChannelHandler;
import org.jboss.netty.channel.ChannelHandlerContext;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ChannelStateEvent;
import org.jboss.netty.channel.ChildChannelStateEvent;
import org.jboss.netty.channel.SimpleChannelUpstreamHandler;
import org.jboss.netty.channel.local.DefaultLocalServerChannelFactory;
import org.jboss.netty.channel.local.LocalAddress;
import org.jboss.netty.channel.socket.nio.NioServerSocketChannelFactory;
import org.jboss.netty.channel.socket.oio.OioServerSocketChannelFactory;
import org.testng.Assert;

public class SimpleTestServerConnection {
    private Channel _channel;
    private Thread _thread;
    private final ServerBootstrap _srvBootstrap;
    private final Lock _lock = new ReentrantLock(true);
    private boolean _shutdownRequested;
    private boolean _shutdown;
    private boolean _started;
    private final Condition _startedCondition = this._lock.newCondition();
    private final Condition _shutdownReqCondition = this._lock.newCondition();
    private final Condition _shutdownCondition = this._lock.newCondition();
    private Channel _lastConnChannel;
    private final Map<SocketAddress, Channel> _childrenChannels = new ConcurrentHashMap<SocketAddress, Channel>();
    private final ServerType _serverType;

    public SimpleTestServerConnection(ByteOrder bufferByteOrder) {
        this(bufferByteOrder, ServerType.LOCAL);
    }

    public SimpleTestServerConnection(ByteOrder bufferByteOrder, ServerType serverType) {
        DefaultLocalServerChannelFactory channelFactory;
        this._serverType = serverType;
        switch (serverType) {
            case LOCAL: {
                channelFactory = new DefaultLocalServerChannelFactory();
                break;
            }
            case NIO: {
                channelFactory = new NioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
                break;
            }
            case OIO: {
                channelFactory = new OioServerSocketChannelFactory((Executor)Executors.newCachedThreadPool(), (Executor)Executors.newCachedThreadPool());
                break;
            }
            default: {
                throw new RuntimeException("unsupported server type: " + (Object)((Object)serverType));
            }
        }
        this._srvBootstrap = new ServerBootstrap((ChannelFactory)channelFactory);
        this._srvBootstrap.setOption("child.bufferFactory", (Object)DirectChannelBufferFactory.getInstance((ByteOrder)bufferByteOrder));
        this._srvBootstrap.setParentHandler((ChannelHandler)new ChildChannelTracker());
    }

    public void setPipelineFactory(ChannelPipelineFactory pipelineFactory) {
        this._srvBootstrap.setPipelineFactory(pipelineFactory);
    }

    public void start(final int localAddr) {
        this._shutdownRequested = false;
        this._shutdown = false;
        this._thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object serverAddr = ServerType.LOCAL == SimpleTestServerConnection.this._serverType ? new LocalAddress(localAddr) : new InetSocketAddress(localAddr);
                SimpleTestServerConnection.this._channel = SimpleTestServerConnection.this._srvBootstrap.bind((SocketAddress)serverAddr);
                SimpleTestServerConnection.this._lock.lock();
                try {
                    SimpleTestServerConnection.this._started = true;
                    SimpleTestServerConnection.this._startedCondition.signalAll();
                    while (!SimpleTestServerConnection.this._shutdownRequested) {
                        try {
                            SimpleTestServerConnection.this._shutdownReqCondition.await();
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    SimpleTestServerConnection.this._shutdown = true;
                    SimpleTestServerConnection.this._shutdownCondition.signalAll();
                }
                finally {
                    SimpleTestServerConnection.this._lock.unlock();
                }
            }
        });
        this._thread.setDaemon(true);
        this._thread.start();
    }

    public boolean startSynchronously(int localAddr, long timeoutMillis) {
        this.start(localAddr);
        try {
            this.awaitStarted(timeoutMillis);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        return this.isStarted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isStarted() {
        this._lock.lock();
        try {
            boolean bl = this._started;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void awaitStarted(long timeoutMillis) throws InterruptedException {
        this._lock.lock();
        try {
            if (!this._started) {
                this._startedCondition.await(timeoutMillis, TimeUnit.MILLISECONDS);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this._lock.lock();
        try {
            this._shutdownRequested = true;
            this._shutdownReqCondition.signalAll();
            while (!this._shutdown) {
                try {
                    this._shutdownCondition.await();
                }
                catch (InterruptedException ie) {}
            }
        }
        finally {
            this._lock.unlock();
        }
        ChannelFuture closeFuture = this._channel.close();
        closeFuture.awaitUninterruptibly();
        this._srvBootstrap.releaseExternalResources();
    }

    public Channel getChannel() {
        return this._channel;
    }

    public Channel getLastConnChannel() {
        return this._lastConnChannel;
    }

    public Channel getChildChannel(SocketAddress clientAddr) {
        return this._childrenChannels.get(clientAddr);
    }

    public void sendServerResponse(SocketAddress clientAddr, Object response, long timeoutMillis) {
        Channel childChannel = this.getChildChannel(clientAddr);
        Assert.assertNotEquals((Object)childChannel, null);
        ChannelFuture writeFuture = childChannel.write(response);
        if (timeoutMillis > 0L) {
            try {
                writeFuture.await(timeoutMillis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Assert.assertTrue((boolean)writeFuture.isDone());
            Assert.assertTrue((boolean)writeFuture.isSuccess());
        }
    }

    public void sendServerClose(SocketAddress clientAddr, long timeoutMillis) {
        Channel childChannel = this.getChildChannel(clientAddr);
        Assert.assertNotEquals((Object)childChannel, null);
        ChannelFuture closeFuture = childChannel.close();
        if (timeoutMillis > 0L) {
            try {
                closeFuture.await(timeoutMillis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            Assert.assertTrue((boolean)closeFuture.isDone());
            Assert.assertTrue((boolean)closeFuture.isSuccess());
        }
    }

    class ChildChannelTracker
    extends SimpleChannelUpstreamHandler {
        ChildChannelTracker() {
        }

        public synchronized void childChannelOpen(ChannelHandlerContext ctx, ChildChannelStateEvent e) throws Exception {
            SimpleTestServerConnection.this._lastConnChannel = e.getChildChannel();
            e.getChildChannel().getPipeline().addFirst("childChannelMapHandler", (ChannelHandler)new ChildChannelMapHandler());
            super.childChannelOpen(ctx, e);
        }

        class ChildChannelMapHandler
        extends SimpleChannelUpstreamHandler {
            ChildChannelMapHandler() {
            }

            public void channelConnected(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
                SocketAddress remoteAddr = e.getChannel().getRemoteAddress();
                SimpleTestServerConnection.this._childrenChannels.put(remoteAddr, e.getChannel());
                super.channelConnected(ctx, e);
            }

            public void channelClosed(ChannelHandlerContext ctx, ChannelStateEvent e) throws Exception {
                SocketAddress remoteAddr = e.getChannel().getRemoteAddress();
                SimpleTestServerConnection.this._childrenChannels.remove(remoteAddr);
                super.channelClosed(ctx, e);
            }
        }
    }

    public static enum ServerType {
        NIO,
        LOCAL,
        OIO;

    }
}

