/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.tools.dtail;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.pub.ConsumerCallbackResult;
import com.linkedin.databus2.tools.dtail.DtailPrinter;
import com.linkedin.databus2.tools.dtail.GenericRecordDtailPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.log4j.Logger;

public class AvroBinaryDtailPrinter
extends GenericRecordDtailPrinter {
    public static final Logger LOG = Logger.getLogger(AvroBinaryDtailPrinter.class);
    private final HashMap<Schema, GenericDatumWriter<GenericRecord>> binWriters = new HashMap(5);
    private final HashMap<Schema, BinaryEncoder> _binEncoders = new HashMap(5);

    public AvroBinaryDtailPrinter(DatabusHttpClientImpl client, DtailPrinter.StaticConfig conf, OutputStream out) {
        this(client, conf, out, DtailPrinter.MetadataOutput.NONE);
    }

    public AvroBinaryDtailPrinter(DatabusHttpClientImpl client, DtailPrinter.StaticConfig conf, OutputStream out, DtailPrinter.MetadataOutput metadata) {
        super(client, conf, out, metadata);
    }

    @Override
    public ConsumerCallbackResult printGenericRecord(GenericRecord r) {
        ConsumerCallbackResult result = ConsumerCallbackResult.SUCCESS;
        try {
            GenericDatumWriter datumWriter;
            BinaryEncoder binEnc = this._binEncoders.get(r.getSchema());
            if (null == binEnc) {
                binEnc = new BinaryEncoder(this._out);
                this._binEncoders.put(r.getSchema(), binEnc);
            }
            if (null == (datumWriter = this.binWriters.get(r.getSchema()))) {
                datumWriter = new GenericDatumWriter(r.getSchema());
                this.binWriters.put(r.getSchema(), (GenericDatumWriter<GenericRecord>)datumWriter);
            }
            datumWriter.write((Object)r, (Encoder)binEnc);
            binEnc.flush();
            this._out.write(10);
        }
        catch (RuntimeException re) {
            LOG.error((Object)("event dump error: " + re.getMessage()), (Throwable)re);
            result = ConsumerCallbackResult.ERROR;
        }
        catch (IOException ioe) {
            LOG.error((Object)("event dump error: " + ioe.getMessage()), (Throwable)ioe);
            result = ConsumerCallbackResult.ERROR;
        }
        return result;
    }
}

