/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.tools.dtail;

import com.linkedin.databus.core.BaseCli;
import com.linkedin.databus.core.util.ConfigHelper;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.tools.dtail.DtailPrinter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.log4j.Logger;

public class DtailCliBase
extends BaseCli {
    public static final String DURATION_OPTION_NAME = "duration";
    public static final char DURATION_OPTION_CHAR = 'u';
    public static final String EVENT_NUM_OPT_NAME = "event_num";
    public static final char EVENT_NUM_OPT_CHAR = 'n';
    public static final String OUTPUT_FORMAT_OPT_NAME = "output_format";
    public static final char OUTPUT_FORMAT_OPT_CHAR = 'F';
    public static final String OUTPUT_OPT_NAME = "output";
    public static final char OUTPUT_OPT_CHAR = 'o';
    public static final String PRINT_VERBOSITY_OPT_NAME = "print_verbosity";
    public static final char PRINT_VERBOSITY_OPT_CHAR = 'V';
    public static final String RESUME_OPT_NAME = "resume";
    public static final String SCN_OPT_NAME = "scn";
    public static final String STATS_OPT_NAME = "stats";
    public static final String VERBOSE_OPT_NAME = "verbose";
    public static final char VERBOSE_OPT_CHAR = 'v';
    public static final String BOB_SCN_STRING = "BOB";
    public static final String EOB_SCN_STRING = "EOB";
    public static final long BOB_SCN = -1000L;
    public static final long EOB_SCN = -2000L;
    public static final OutputFormat DEFAUL_OUTPUT_FORMAT = OutputFormat.JSON;
    public static final DtailPrinter.PrintVerbosity DEFAULT_PRINT_VERBOSITY = DtailPrinter.PrintVerbosity.EVENT;
    protected String _checkpointDirName;
    protected long _durationMs = Long.MAX_VALUE;
    protected long _maxEventNum = Long.MAX_VALUE;
    protected OutputFormat _outputFormat = DEFAUL_OUTPUT_FORMAT;
    protected DtailPrinter.PrintVerbosity _printVerbosity = DEFAULT_PRINT_VERBOSITY;
    protected OutputStream _out = System.out;
    protected boolean _showStats = false;
    protected long _sinceScn = -1000L;

    public DtailCliBase(BaseCli.CliHelp help, Logger log) {
        super(help, log);
        this._defaultLogLevelIdx = 1;
    }

    protected void constructCommandLineOptions() {
        super.constructCommandLineOptions();
        OptionBuilder.withLongOpt((String)PRINT_VERBOSITY_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)PRINT_VERBOSITY_OPT_NAME);
        OptionBuilder.withDescription((String)("print verbosity: " + Arrays.toString((Object[])DtailPrinter.PrintVerbosity.values()) + "; default: " + (Object)((Object)DEFAULT_PRINT_VERBOSITY)));
        Option printVerbosityOption = OptionBuilder.create((char)'V');
        OptionBuilder.withLongOpt((String)OUTPUT_FORMAT_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)OUTPUT_FORMAT_OPT_NAME);
        OptionBuilder.withDescription((String)("output format: " + Arrays.toString((Object[])OutputFormat.values()) + "; default: " + (Object)((Object)DEFAUL_OUTPUT_FORMAT)));
        Option outputFormatOption = OptionBuilder.create((char)'F');
        OptionBuilder.withLongOpt((String)OUTPUT_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"output_file");
        OptionBuilder.withDescription((String)"output file or - for STDOUT");
        Option outputOption = OptionBuilder.create((char)'o');
        OptionBuilder.withLongOpt((String)RESUME_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"checkpoint_dir");
        OptionBuilder.withDescription((String)"resumes from a previous checkpoint");
        Option resumeOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)VERBOSE_OPT_NAME);
        OptionBuilder.withDescription((String)"verbose logging: INFO or above");
        Option verboseOption = OptionBuilder.create((char)'v');
        OptionBuilder.withLongOpt((String)EVENT_NUM_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"num");
        OptionBuilder.withDescription((String)"max number of events to return; default: no limit");
        Option eventNumOption = OptionBuilder.create((char)'n');
        OptionBuilder.withLongOpt((String)DURATION_OPTION_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"duration_value");
        OptionBuilder.withDescription((String)"max consumption duration: value[ns|us|ms|s|min|hr|d]; default: no limit");
        Option durationOption = OptionBuilder.create((char)'u');
        OptionBuilder.withLongOpt((String)STATS_OPT_NAME);
        OptionBuilder.withDescription((String)"print statistics at the end; Default: off");
        Option statsOption = OptionBuilder.create();
        OptionBuilder.withLongOpt((String)SCN_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)SCN_OPT_NAME);
        OptionBuilder.withDescription((String)"starts consumption from the given scn; special values: BOB for current beginning of relay buffer, EOB for current end of buffer; Default: BOB");
        Option sinceScnOption = OptionBuilder.create();
        this._cliOptions.addOption(eventNumOption);
        this._cliOptions.addOption(outputFormatOption);
        this._cliOptions.addOption(outputOption);
        this._cliOptions.addOption(printVerbosityOption);
        this._cliOptions.addOption(resumeOption);
        this._cliOptions.addOption(verboseOption);
        this._cliOptions.addOption(durationOption);
        this._cliOptions.addOption(statsOption);
        this._cliOptions.addOption(sinceScnOption);
    }

    public boolean processCommandLineArgs(String[] cliArgs) {
        super.processCommandLineArgs(cliArgs);
        if (!this.processOutputFormat()) {
            return false;
        }
        if (!this.processVerbosity()) {
            return false;
        }
        if (!this.processOutput()) {
            return false;
        }
        this.processResume();
        if (!this.processMaxEventNum()) {
            return false;
        }
        if (!this.processDuration()) {
            return false;
        }
        this.processStats();
        this.processSinceScn();
        return true;
    }

    private boolean processOutputFormat() {
        if (this._cmd.hasOption('F')) {
            try {
                this._outputFormat = OutputFormat.valueOf(this._cmd.getOptionValue('F').toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.printError("invalid output format: " + this._cmd.getOptionValue('F'), true);
                return false;
            }
        }
        return true;
    }

    private boolean processVerbosity() {
        if (this._cmd.hasOption('V')) {
            try {
                this._printVerbosity = DtailPrinter.PrintVerbosity.valueOf(this._cmd.getOptionValue('V').toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.printError("invalid print verbosity: " + this._cmd.getOptionValue('V'), true);
                return false;
            }
        }
        return true;
    }

    private boolean processOutput() {
        if (this._cmd.hasOption('o')) {
            String outputStr = this._cmd.getOptionValue('o');
            if (outputStr.startsWith("hdfs://")) {
                this.printError("HDFS is not supported yet", false);
                return false;
            }
            if (!outputStr.equals("-")) {
                try {
                    this._out = new FileOutputStream(outputStr);
                }
                catch (IOException e) {
                    this.printError("unable to open output: " + outputStr, false);
                    return false;
                }
            }
        }
        return true;
    }

    private void processResume() {
        if (this._cmd.hasOption(RESUME_OPT_NAME)) {
            this._checkpointDirName = this._cmd.getOptionValue(RESUME_OPT_NAME);
        }
    }

    private boolean processMaxEventNum() {
        if (this._cmd.hasOption('n')) {
            try {
                this._maxEventNum = Long.parseLong(this._cmd.getOptionValue('n'));
            }
            catch (NumberFormatException e) {
                this.printError("invalid max events number: " + this._cmd.getOptionValue('n'), false);
                return false;
            }
        }
        return true;
    }

    private boolean processDuration() {
        if (this._cmd.hasOption('u')) {
            String durationStr = this._cmd.getOptionValue('u');
            this._log.info((Object)("Using duration: " + durationStr));
            try {
                this._durationMs = ConfigHelper.parseDuration((String)durationStr, (TimeUnit)TimeUnit.MILLISECONDS);
            }
            catch (InvalidConfigException e) {
                this.printError("invalid duration: " + durationStr, true);
                return false;
            }
        }
        return true;
    }

    private void processStats() {
        this._showStats = this._cmd.hasOption(STATS_OPT_NAME);
    }

    private void processSinceScn() {
        if (this._cmd.hasOption(SCN_OPT_NAME)) {
            String scnOption = this._cmd.getOptionValue(SCN_OPT_NAME);
            this._sinceScn = scnOption.equals(BOB_SCN_STRING) ? -1000L : (scnOption.equals(EOB_SCN_STRING) ? -2000L : Long.parseLong(scnOption));
        }
        this._log.info((Object)("starting from SCN: " + this._sinceScn));
    }

    public String getCheckpointDirName() {
        return this._checkpointDirName;
    }

    public long getDurationMs() {
        return this._durationMs;
    }

    public boolean isShowStats() {
        return this._showStats;
    }

    public long getMaxEventNum() {
        return this._maxEventNum;
    }

    public OutputFormat getOutputFormat() {
        return this._outputFormat;
    }

    public DtailPrinter.PrintVerbosity getPrintVerbosity() {
        return this._printVerbosity;
    }

    public OutputStream getOut() {
        return this._out;
    }

    public long getSinceScn() {
        return this._sinceScn;
    }

    public static enum OutputFormat {
        JSON,
        AVRO_JSON,
        AVRO_BIN,
        NOOP,
        EVENT_INFO;

    }
}

