/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.groupleader.example.simple;

import com.linkedin.databus.groupleader.example.simple.ExampleUtils;
import com.linkedin.databus.groupleader.impl.zkclient.GroupLeadershipConnectionFactoryZkClientImpl;
import com.linkedin.databus.groupleader.pub.AcceptLeadershipCallback;
import com.linkedin.databus.groupleader.pub.GroupLeadershipConnection;
import com.linkedin.databus.groupleader.pub.GroupLeadershipConnectionFactory;
import com.linkedin.databus.groupleader.pub.GroupLeadershipSession;
import org.apache.log4j.Logger;

public class LeaderElectSimpleExample {
    private static final Logger LOG = Logger.getLogger(LeaderElectSimpleExample.class);
    private final String _groupName = ExampleUtils.getRequiredStringProperty("groupName", LOG);
    private final String _memberName;
    private final GroupLeadershipConnectionFactory _groupLeadershipConnFactory;
    private final GroupLeadershipConnection _groupLeadershipConn;

    public static void main(String[] args) {
        LeaderElectSimpleExample leaderElectProto = new LeaderElectSimpleExample();
        leaderElectProto.run();
    }

    public LeaderElectSimpleExample() {
        String memberName = System.getProperty("memberName");
        if (memberName != null && memberName.trim().isEmpty()) {
            memberName = null;
        }
        this._memberName = memberName;
        this._groupLeadershipConnFactory = new GroupLeadershipConnectionFactoryZkClientImpl(ExampleUtils.getRequiredStringProperty("zkServerList", LOG), ExampleUtils.getRequiredIntProperty("sessionTimeoutMillis", LOG), ExampleUtils.getRequiredIntProperty("connectTimeoutMillis", LOG));
        this._groupLeadershipConn = this._groupLeadershipConnFactory.getConnection();
    }

    protected void run() {
        String baseName = "/databus2.testGroupLeaderSimple";
        LOG.info((Object)("Before joining group: groupName=" + this._groupName + "; memberName=" + this._memberName + "; leadershipInfo=" + this._groupLeadershipConn.getGroupLeadershipInfo(baseName, this._groupName)));
        GroupLeadershipSession groupLeadershipSession = this._groupLeadershipConn.joinGroup(baseName, this._groupName, this._memberName, new AcceptLeadershipCallback(){

            public void doAcceptLeadership(GroupLeadershipSession groupLeadershipSession) {
                LOG.info((Object)("Accepting leadership: " + groupLeadershipSession));
            }
        });
        LOG.info((Object)("After joining group: " + groupLeadershipSession));
        while (true) {
            try {
                while (true) {
                    Thread.sleep(3000L);
                    LOG.debug((Object)groupLeadershipSession);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }
}

