/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.eventgenerator;

import com.linkedin.databus.eventgenerator.SchemaFiller;
import com.linkedin.databus.eventgenerator.UnknownTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;

public class ArrayFieldGenerate
extends SchemaFiller {
    private static int maxArrayLength = 10;

    public ArrayFieldGenerate(Schema.Field field) {
        super(field);
    }

    @Override
    public void writeToRecord(GenericRecord record) throws UnknownTypeException {
        record.put(this.field.name(), this.generateArray());
    }

    @Override
    public Object generateRandomObject() throws UnknownTypeException {
        return this.generateArray();
    }

    public GenericData.Array<Object> generateArray() throws UnknownTypeException {
        Schema innerElementSchema = this.field.schema().getElementType();
        GenericData.Array array = new GenericData.Array(10, this.field.schema());
        for (int i = 0; i < this.randGenerator.getNextInt() % maxArrayLength; ++i) {
            Schema.Field fakeField = new Schema.Field(this.field.name() + "fake", innerElementSchema, null, null);
            SchemaFiller schemaFill = SchemaFiller.createRandomField(fakeField);
            array.add(schemaFill.generateRandomObject());
        }
        return array;
    }
}

