/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.eventgenerator;

import com.linkedin.databus.eventgenerator.SchemaFiller;
import com.linkedin.databus.eventgenerator.UnknownTypeException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.JsonEncoder;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class DataGenerator {
    public static final String MODULE = DataGenerator.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private static final String PRINT_AVRO_JSON_OPTNAME = "printAvroJson";
    Schema schema;

    public DataGenerator(File schemaFile) throws IOException {
        this.schema = Schema.parse((File)schemaFile);
    }

    public DataGenerator(String schema) {
        this.schema = Schema.parse((String)schema);
    }

    public GenericRecord generateRandomRecord() throws UnknownTypeException {
        if (this.schema.getType() != Schema.Type.RECORD) {
            LOG.error((Object)"The schema first level must be record.");
            return null;
        }
        GenericData.Record record = new GenericData.Record(this.schema);
        for (Schema.Field field : this.schema.getFields()) {
            SchemaFiller schemaFill = SchemaFiller.createRandomField(field);
            schemaFill.writeToRecord((GenericRecord)record);
        }
        return record;
    }

    public static void prettyPrint(GenericRecord record) {
        try {
            LOG.info((Object)new JSONObject(record.toString()).toString(2));
        }
        catch (JSONException e) {
            LOG.error((Object)"Unable to parser json: The Json created by the generator is not valid!");
            e.printStackTrace();
        }
    }

    public static Options loadOptions() {
        Options opt = new Options();
        opt.addOption("s", "schemaLocation", true, "location of the schema");
        opt.addOption("minStringLength", true, "Minimum length of string to be generated");
        opt.addOption("maxStringLength", true, "Maximum length of string to be generated");
        opt.addOption("minIntegerRange", true, "Start range of integer");
        opt.addOption("maxIntegerRange", true, "End range of integer");
        opt.addOption("minLongRange", true, "Start range of long");
        opt.addOption("maxLongRange", true, "End range of long");
        opt.addOption("maxBytesLength", true, "Maximum length of the bytes to be generated");
        opt.addOption(PRINT_AVRO_JSON_OPTNAME, true, "Replace the default human-readable JSON serialization with the standard Avro JSON serialization of the record which can be deserialized back to a  record. The result is printed out to a file or to the standard output (-).");
        return opt;
    }

    public static void printHelp(Options opts) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("Generate a record with random data given an Avro schema", opts);
    }

    public static void main(String[] args) throws IOException, UnknownTypeException {
        PosixParser parser = new PosixParser();
        Options opts = DataGenerator.loadOptions();
        CommandLine cmd = null;
        try {
            cmd = parser.parse(opts, args);
        }
        catch (ParseException parseEx) {
            LOG.error((Object)"Invalid option");
            DataGenerator.printHelp(opts);
            return;
        }
        String fileLoc = cmd.getOptionValue("schemaLocation");
        if (fileLoc == null) {
            LOG.error((Object)"schemaLocation not specified");
            DataGenerator.printHelp(opts);
        }
        File schemaFile = new File(fileLoc);
        DataGenerator dataGenerator = new DataGenerator(schemaFile);
        GenericRecord record = dataGenerator.generateRandomRecord();
        if (cmd.hasOption(PRINT_AVRO_JSON_OPTNAME)) {
            String outname = cmd.getOptionValue(PRINT_AVRO_JSON_OPTNAME);
            OutputStream outs = System.out;
            if (!outname.equals("-")) {
                outs = new FileOutputStream(outname);
            }
            DataGenerator.printAvroJson(record, outs);
            if (!outname.equals("-")) {
                outs.close();
            }
        } else {
            DataGenerator.prettyPrint(record);
        }
    }

    private static void printAvroJson(GenericRecord record, OutputStream outs) throws IOException {
        JsonEncoder jsonEnc = new JsonEncoder(record.getSchema(), outs);
        GenericDatumWriter datumWriter = new GenericDatumWriter(record.getSchema());
        datumWriter.write((Object)record, (Encoder)jsonEnc);
        jsonEnc.flush();
    }
}

