/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.eventgenerator;

import com.linkedin.databus.eventgenerator.IntegerFieldGenerate;
import com.linkedin.databus.eventgenerator.RandomDataGenerator;
import com.linkedin.databus.eventgenerator.StringFieldGenerate;
import java.util.Random;

public class DefaultRandomGenerator
implements RandomDataGenerator {
    Random rand = new Random();
    public String validChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";

    @Override
    public int getNextInt() {
        return this.getNextInt(0, IntegerFieldGenerate.getMaxIntLength());
    }

    @Override
    public int getNextInt(int min, int max) {
        if (max == min) {
            return min;
        }
        int range = max - min;
        range = range > 0 ? range : -range;
        int generated = min + this.rand.nextInt(range);
        generated = generated > max ? max : generated;
        return generated;
    }

    @Override
    public String getNextString() {
        return this.getNextString(StringFieldGenerate.getMinStringLength(), StringFieldGenerate.getMaxStringLength());
    }

    @Override
    public String getNextString(int min, int max) {
        int length = this.getNextInt(min, max);
        StringBuffer strbld = new StringBuffer();
        for (int i = 0; i < length; ++i) {
            char ch = this.validChars.charAt(this.rand.nextInt(this.validChars.length()));
            strbld.append(ch);
        }
        return strbld.toString();
    }

    @Override
    public double getNextDouble() {
        return this.rand.nextDouble();
    }

    @Override
    public float getNextFloat() {
        return this.rand.nextFloat();
    }

    @Override
    public long getNextLong() {
        long randomLong = this.rand.nextLong();
        return randomLong == Long.MIN_VALUE ? 0L : Math.abs(randomLong);
    }

    @Override
    public boolean getNextBoolean() {
        return this.rand.nextBoolean();
    }

    @Override
    public byte[] getNextBytes(int maxBytesLength) {
        byte[] bytes = new byte[this.getNextInt(0, maxBytesLength)];
        this.rand.nextBytes(bytes);
        return bytes;
    }
}

