/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.eventgenerator;

import com.linkedin.databus.eventgenerator.SchemaFiller;
import com.linkedin.databus.eventgenerator.UnknownTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public class FixedLengthFieldGenerate
extends SchemaFiller {
    int fixedSize;

    public FixedLengthFieldGenerate(Schema.Field field) {
        super(field);
        this.fixedSize = field.schema().getFixedSize();
    }

    @Override
    public void writeToRecord(GenericRecord record) throws UnknownTypeException {
        record.put(this.field.name(), (Object)this.generateFixedLengthString());
    }

    @Override
    public Object generateRandomObject() throws UnknownTypeException {
        return this.generateFixedLengthString();
    }

    public String generateFixedLengthString() {
        return this.randGenerator.getNextString(0, this.fixedSize);
    }
}

