/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.eventgenerator;

import com.linkedin.databus.eventgenerator.SchemaFiller;
import com.linkedin.databus.eventgenerator.UnknownTypeException;
import java.util.HashMap;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.util.Utf8;

public class MapFieldGenerate
extends SchemaFiller {
    private static int maxNumberOfMapFields = 10;

    public static int getMaxNumberOfMapFields() {
        return maxNumberOfMapFields;
    }

    public static void setMaxNumberOfMapFields(int maxNumberOfMapFields) {
        MapFieldGenerate.maxNumberOfMapFields = maxNumberOfMapFields;
    }

    public MapFieldGenerate(Schema.Field field) {
        super(field);
    }

    @Override
    public void writeToRecord(GenericRecord record) throws UnknownTypeException {
        record.put(this.field.name(), this.generateMap());
    }

    @Override
    public Object generateRandomObject() throws UnknownTypeException {
        return this.generateMap();
    }

    public Map<Utf8, Object> generateMap() throws UnknownTypeException {
        HashMap<Utf8, Object> map = new HashMap<Utf8, Object>(this.randGenerator.getNextInt() % maxNumberOfMapFields);
        Schema.Field fakeField = new Schema.Field(this.field.name(), this.field.schema().getValueType(), null, null);
        int count = this.randGenerator.getNextInt() % MapFieldGenerate.getMaxNumberOfMapFields();
        for (int i = 0; i < count; ++i) {
            SchemaFiller filler = SchemaFiller.createRandomField(fakeField);
            map.put(new Utf8(this.field.name() + i), filler.generateRandomObject());
        }
        return map;
    }
}

