/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.eventgenerator;

import com.linkedin.databus.eventgenerator.ArrayFieldGenerate;
import com.linkedin.databus.eventgenerator.BooleanFieldGenerate;
import com.linkedin.databus.eventgenerator.BytesFieldGenerate;
import com.linkedin.databus.eventgenerator.DefaultRandomGenerator;
import com.linkedin.databus.eventgenerator.DoubleFieldGenerate;
import com.linkedin.databus.eventgenerator.EnumFieldGenerate;
import com.linkedin.databus.eventgenerator.FixedLengthFieldGenerate;
import com.linkedin.databus.eventgenerator.FloatFieldGenerate;
import com.linkedin.databus.eventgenerator.IntegerFieldGenerate;
import com.linkedin.databus.eventgenerator.LongFieldGenerate;
import com.linkedin.databus.eventgenerator.MapFieldGenerate;
import com.linkedin.databus.eventgenerator.NullFieldGenerate;
import com.linkedin.databus.eventgenerator.RandomDataGenerator;
import com.linkedin.databus.eventgenerator.RecordFieldGenerate;
import com.linkedin.databus.eventgenerator.StringFieldGenerate;
import com.linkedin.databus.eventgenerator.UnionFieldGenerate;
import com.linkedin.databus.eventgenerator.UnknownTypeException;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;

public abstract class SchemaFiller {
    protected Schema.Field field;
    protected RandomDataGenerator randGenerator;

    public SchemaFiller(Schema.Field field) {
        this.field = field;
        this.randGenerator = new DefaultRandomGenerator();
    }

    public SchemaFiller(Schema.Field field, RandomDataGenerator randGenerator) {
        this.field = field;
        this.randGenerator = randGenerator;
    }

    public static SchemaFiller createRandomField(Schema.Field field) throws UnknownTypeException {
        Schema.Type type = field.schema().getType();
        if (type == Schema.Type.ARRAY) {
            return new ArrayFieldGenerate(field);
        }
        if (type == Schema.Type.BOOLEAN) {
            return new BooleanFieldGenerate(field);
        }
        if (type == Schema.Type.BYTES) {
            return new BytesFieldGenerate(field);
        }
        if (type == Schema.Type.DOUBLE) {
            return new DoubleFieldGenerate(field);
        }
        if (type == Schema.Type.ENUM) {
            return new EnumFieldGenerate(field);
        }
        if (type == Schema.Type.FIXED) {
            return new FixedLengthFieldGenerate(field);
        }
        if (type == Schema.Type.FLOAT) {
            return new FloatFieldGenerate(field);
        }
        if (type == Schema.Type.INT) {
            return new IntegerFieldGenerate(field);
        }
        if (type == Schema.Type.LONG) {
            return new LongFieldGenerate(field);
        }
        if (type == Schema.Type.MAP) {
            return new MapFieldGenerate(field);
        }
        if (type == Schema.Type.NULL) {
            return new NullFieldGenerate(field);
        }
        if (type == Schema.Type.RECORD) {
            return new RecordFieldGenerate(field);
        }
        if (type == Schema.Type.STRING) {
            return new StringFieldGenerate(field);
        }
        if (type == Schema.Type.UNION) {
            return new UnionFieldGenerate(field);
        }
        throw new UnknownTypeException();
    }

    public abstract void writeToRecord(GenericRecord var1) throws UnknownTypeException;

    public abstract Object generateRandomObject() throws UnknownTypeException;
}

