/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class CommandLineHelper {
    private final Map<String, ArgumentInfo> _argumentInfos = new HashMap<String, ArgumentInfo>();

    public void addArgument(String name, boolean required, String description, ArgumentType type) {
        this.addArgument(name, required, description, type, null);
    }

    public void addArgument(String name, boolean required, String description, ArgumentType type, String regexPattern) {
        if (name.startsWith("-")) {
            throw new IllegalArgumentException("Argument names should not begin with a leading dash (-).");
        }
        Pattern pattern = null;
        if (regexPattern != null) {
            pattern = Pattern.compile(regexPattern);
        }
        this._argumentInfos.put("-" + name, new ArgumentInfo(name, required, description, type, pattern));
    }

    public Map<String, Object> parseCommandLine(String[] args) {
        HashMap<String, Object> arguments = new HashMap<String, Object>();
        if (args.length % 2 != 0) {
            this.showUsage("Bad command line");
            return null;
        }
        for (int i = 0; i < args.length; i += 2) {
            String argumentName = args[i];
            String argumentValue = args[i + 1];
            ArgumentInfo argumentInfo = this._argumentInfos.get(argumentName);
            if (argumentInfo == null) {
                this.showUsage("Bad command line. The argument name does not exist: " + argumentName);
                return null;
            }
            if (argumentInfo._regexPattern != null && !argumentInfo._regexPattern.matcher(argumentValue).matches()) {
                this.showUsage("Bad command line. The argument " + argumentName + " must match the pattern " + argumentInfo._regexPattern.toString());
                return null;
            }
            try {
                switch (argumentInfo._type) {
                    case BOOLEAN: {
                        arguments.put(argumentInfo._name, Boolean.valueOf(argumentValue));
                        break;
                    }
                    case DOUBLE: {
                        arguments.put(argumentInfo._name, Double.valueOf(argumentValue));
                        break;
                    }
                    case FLOAT: {
                        arguments.put(argumentInfo._name, Float.valueOf(argumentValue));
                        break;
                    }
                    case INTEGER: {
                        arguments.put(argumentInfo._name, Integer.valueOf(argumentValue));
                        break;
                    }
                    case LONG: {
                        arguments.put(argumentInfo._name, Long.valueOf(argumentValue));
                        break;
                    }
                    case STRING: {
                        arguments.put(argumentInfo._name, argumentValue);
                        break;
                    }
                    case FILE: {
                        File file = new File(argumentValue);
                        if (!file.exists() || file.isDirectory()) {
                            this.showUsage("Bad command line. The file " + argumentValue + " does not exist.");
                            return null;
                        }
                        arguments.put(argumentInfo._name, file);
                        break;
                    }
                    case DIRECTORY: {
                        File dir = new File(argumentValue);
                        if (!dir.exists() || !dir.isDirectory()) {
                            this.showUsage("Bad command line. The directory " + argumentValue + " does not exist.");
                            return null;
                        }
                        arguments.put(argumentInfo._name, dir);
                    }
                }
                continue;
            }
            catch (Exception ex) {
                this.showUsage("Bad command line. The argument " + argumentName + " had a bad value. It must be of type " + (Object)((Object)argumentInfo._type));
                return null;
            }
        }
        boolean missingRequiredArgs = false;
        for (ArgumentInfo argumentInfo : this._argumentInfos.values()) {
            if (!argumentInfo._required || arguments.containsKey(argumentInfo._name)) continue;
            System.out.println("Missing required argument: " + argumentInfo._name);
            missingRequiredArgs = true;
        }
        if (missingRequiredArgs) {
            this.showUsage();
            return null;
        }
        return arguments;
    }

    public void showParsedArguments(Map<String, Object> arguments) {
        this.showParsedArguments(null, arguments);
    }

    public void showParsedArguments(String message, Map<String, Object> arguments) {
        if (message != null) {
            System.out.println(message);
        }
        for (Map.Entry<String, Object> entry : arguments.entrySet()) {
            System.out.println(entry.getKey() + "=" + entry.getValue());
        }
    }

    public void showUsage() {
        this.showUsage(null);
    }

    public void showUsage(String message) {
        ArrayList<ArgumentInfo> argumentInfosList = new ArrayList<ArgumentInfo>();
        argumentInfosList.addAll(this._argumentInfos.values());
        Collections.sort(argumentInfosList);
        if (message != null) {
            System.out.println(message);
        }
        System.out.println("Arguments: ");
        for (ArgumentInfo argumentInfo : argumentInfosList) {
            if (!argumentInfo._required) continue;
            System.out.println("\t-" + argumentInfo._name + " (required): " + argumentInfo._description + " (" + (Object)((Object)argumentInfo._type) + ")");
        }
        for (ArgumentInfo argumentInfo : argumentInfosList) {
            if (argumentInfo._required) continue;
            System.out.println("\t-" + argumentInfo._name + " (optional): " + argumentInfo._description + " (" + (Object)((Object)argumentInfo._type) + ")");
        }
    }

    private static class ArgumentInfo
    implements Comparable<ArgumentInfo> {
        private final String _name;
        private final boolean _required;
        private final String _description;
        private final ArgumentType _type;
        private final Pattern _regexPattern;

        public ArgumentInfo(String name, boolean required, String description, ArgumentType type, Pattern regexPattern) {
            this._name = name;
            this._required = required;
            this._description = description;
            this._type = type;
            this._regexPattern = regexPattern;
        }

        @Override
        public int compareTo(ArgumentInfo other) {
            return this._name.compareTo(other._name);
        }

        public boolean equals(Object o) {
            if (null == o || !(o instanceof ArgumentInfo)) {
                return false;
            }
            return this._name.equals(((ArgumentInfo)o)._name);
        }

        public int hashCode() {
            return this._name.hashCode();
        }
    }

    public static enum ArgumentType {
        STRING,
        INTEGER,
        LONG,
        FLOAT,
        DOUBLE,
        BOOLEAN,
        DIRECTORY,
        FILE;

    }
}

