/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import com.linkedin.databus.util.SchemaUtils;
import java.sql.Array;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataReader {
    private static final String[] DEFAULT_JDBC_DRIVERS = new String[]{"oracle.jdbc.driver.OracleDriver"};
    private final String _userName;
    private final String _password;
    private final String _connectString;
    private final String _driver;
    private final String _table;
    private final boolean _verbose;

    public static void main(String[] args) {
        DataReader generator = new DataReader(args);
        generator.loadJdbcDrivers();
        generator.doIt();
    }

    private DataReader(String[] args) {
        String userName = null;
        String password = null;
        String connectString = null;
        String driver = null;
        String table = null;
        boolean verbose = false;
        Pattern connectPattern = Pattern.compile("(\\S+)/([^\\s@]+)@(\\S+)");
        for (int i = 0; i < args.length; ++i) {
            Matcher connectMatcher = connectPattern.matcher(args[i]);
            if (connectMatcher.matches()) {
                userName = connectMatcher.group(1);
                password = connectMatcher.group(2);
                connectString = connectMatcher.group(3);
                if (args[i + 1].startsWith("-")) {
                    throw new IllegalArgumentException("Table name should come after connect string.");
                }
                table = args[i + 1];
                ++i;
                continue;
            }
            if ("-driver".equals(args[i])) {
                driver = args[i + 1];
                ++i;
                continue;
            }
            if (!"-v".equals(args[i]) && !"-verbose".equals(args[i])) continue;
            verbose = true;
        }
        if (userName == null || password == null || connectString == null || table == null) {
            DataReader.showUsage();
            throw new IllegalArgumentException("Missing one or more required parameters.");
        }
        if (verbose) {
            System.out.println("url: " + connectString + "; user:" + userName + "; password: " + password + "; table=" + table);
        }
        this._userName = userName;
        this._password = password;
        this._connectString = connectString;
        this._table = table;
        this._verbose = verbose;
        this._driver = driver;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadJdbcDrivers() {
        if (this._driver != null) {
            try {
                if (this._verbose) {
                    System.out.println("Loading JDBC driver: " + this._driver);
                }
                Class.forName(this._driver);
                if (!this._verbose) return;
                System.out.println("JDBC driver loaded successfully.");
                return;
            }
            catch (ClassNotFoundException ex) {
                DataReader.showUsage();
                System.out.println("Could not load JDBC driver: " + this._driver);
                return;
            }
        } else {
            boolean loadedAtLeastOneDriver = false;
            for (int i = 0; i < DEFAULT_JDBC_DRIVERS.length; ++i) {
                String driver = DEFAULT_JDBC_DRIVERS[i];
                try {
                    if (this._verbose) {
                        System.out.println("Loading default JDBC driver: " + driver);
                    }
                    Class.forName(driver);
                    loadedAtLeastOneDriver = true;
                    if (!this._verbose) continue;
                    System.out.println("JDBC driver loaded successfully.");
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    System.out.println("Could not load JDBC driver: " + driver);
                }
            }
            if (loadedAtLeastOneDriver) return;
            System.out.println("Unable to load any of the default JDBC drivers. Please make sure one of the default drivers \nis available in the classpath, or specify a driver with [-driver com.foo.driver]. \nDefault drivers are: " + Arrays.toString(DEFAULT_JDBC_DRIVERS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt() {
        block7: {
            Connection con = null;
            PreparedStatement stmt = null;
            ResultSet rs = null;
            try {
                con = this.getConnection();
                stmt = con.prepareStatement("SELECT * FROM " + this._table + " WHERE ROWNUM < 2");
                rs = stmt.executeQuery();
                rs.next();
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int column = 1; column <= rsmd.getColumnCount(); ++column) {
                    System.out.println(column + ": " + rsmd.getColumnName(column) + " --> " + rs.getObject(column).getClass().getName());
                    if (!(rs.getObject(column) instanceof Array)) continue;
                    Array arr = rs.getArray(column);
                    System.out.println("\t" + arr.getBaseTypeName());
                    ResultSet rs2 = arr.getResultSet();
                    while (rs2.next()) {
                        System.out.println("\t" + rs2.getObject(1));
                        Struct struct = (Struct)rs2.getObject(2);
                        System.out.println(Arrays.toString(struct.getAttributes()));
                    }
                    rs2.close();
                }
                SchemaUtils.close(rs);
            }
            catch (SQLException ex) {
                System.out.println(ex);
                ex.printStackTrace();
                break block7;
            }
            finally {
                SchemaUtils.close(rs);
                SchemaUtils.close(stmt);
                SchemaUtils.close(con);
            }
            SchemaUtils.close(stmt);
            SchemaUtils.close(con);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            if (this._verbose) {
                System.out.println("Connecting to database: " + this._connectString);
            }
            Connection con = DriverManager.getConnection(this._connectString, this._userName, this._password);
            if (this._verbose) {
                System.out.println("Connected successfully.");
            }
            return con;
        }
        catch (SQLException ex) {
            System.out.println("Could not connect to database: " + this._connectString);
            System.out.println(ex.getMessage());
            if (this._verbose) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }

    private static void showUsage() {
        System.out.println("Oracle connection string looks like: user/password@jdbc:oracle:thin:@devdb:1521:db");
    }
}

