/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import com.linkedin.databus.util.SchemaMetaDataManager;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.relay.config.DatabusRelaySourcesInFiles;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceConfig;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.VersionedSchema;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Logger;

public class DevRelayConfigGenerator {
    public static final Logger LOG = Logger.getLogger(DevRelayConfigGenerator.class);
    public static final String NAME = DevRelayConfigGenerator.class.getName();

    public static void main(String[] args) throws Exception {
        Cli cli = new Cli();
        if (!cli.processCommandLineArgs(args)) {
            return;
        }
        DevRelayConfigGenerator.generateRelayConfig(cli.getSchemaRegistryLocation(), cli.getSchemaName(), cli.getDbUri(), cli.getOutputDirectory(), cli.getSrcNames(), new SchemaMetaDataManager(cli.getSchemaRegistryLocation()));
        System.out.println("DONE !!");
    }

    public static void generateRelayConfig(String schemaRegistryLocation, String dbName, String uri, String outputDir, List<String> srcNames, SchemaMetaDataManager manager) throws Exception {
        PhysicalSourceConfig config = new PhysicalSourceConfig();
        FileSystemSchemaRegistryService s = FileSystemSchemaRegistryService.build((FileSystemSchemaRegistryService.StaticConfig)new FileSystemSchemaRegistryService.StaticConfig(new File(schemaRegistryLocation), 0L, false, false));
        dbName = dbName.trim().toLowerCase();
        config.setName(dbName);
        config.setUri(uri);
        for (String srcName : srcNames) {
            VersionedSchema schema = null;
            schema = s.fetchLatestVersionedSchemaBySourceName(srcName);
            String dbObjectName = SchemaHelper.getMetaField((Schema)schema.getSchema(), (String)"dbFieldName");
            LogicalSourceConfig c = new LogicalSourceConfig();
            c.setId(manager.getSrcId(srcName));
            c.setName(srcName);
            c.setUri(dbName + "." + dbObjectName);
            c.setPartitionFunction("constant:1");
            config.addSource(c);
        }
        DatabusRelaySourcesInFiles relaySourcesInFiles = new DatabusRelaySourcesInFiles(outputDir);
        relaySourcesInFiles.add(dbName, config);
        boolean success = relaySourcesInFiles.save();
        if (!success) {
            throw new RuntimeException("Unable to create the dev relay config for DB :" + dbName);
        }
    }

    public static class Cli {
        public static final char SCHEMA_REGISTRY_LOCATION_OPT_CHAR = 'l';
        public static final char SCHEMA_NAME_OPT_CHAR = 'd';
        public static final char DB_URI_OPT_CHAR = 'u';
        public static final char SRC_NAMES_OPT_CHAR = 's';
        public static final char HELP_OPT_CHAR = 'h';
        public static final char OUTPUT_DIRECTORY_OPT_CHAR = 'o';
        public static final String SCHEMA_REGISTRY_LOCATION_LONG_STR = "schema_registry";
        public static final String SCHEMA_NAME_LONG_STR = "schema_name";
        public static final String DB_URI_LONG_STR = "source_uri";
        public static final String SRC_NAMES_LONG_STR = "source_names";
        public static final String HELP_OPT_LONG_NAME = "help";
        public static final String OUTPUT_DIRECTORY_LONG_STR = "output_directory";
        private final String _usage = "java " + NAME + " [options]";
        protected Options _cliOptions = new Options();
        protected CommandLine _cmd;
        HelpFormatter _helpFormatter;
        private String _schemaRegistryLocation;
        private String _schemaName;
        private String _dbUri;
        private List<String> _srcNames;
        private String _outputDirectory;

        public Cli() {
            this.constructCommandLineOptions();
            this._helpFormatter = new HelpFormatter();
            this._helpFormatter.setWidth(150);
        }

        private void constructCommandLineOptions() {
            OptionBuilder.withLongOpt((String)HELP_OPT_LONG_NAME);
            OptionBuilder.withDescription((String)"Prints command-line options info");
            Option helpOption = OptionBuilder.create((char)'h');
            OptionBuilder.withLongOpt((String)SCHEMA_REGISTRY_LOCATION_LONG_STR);
            OptionBuilder.withDescription((String)"Absolute path to the Schema Registry directory");
            OptionBuilder.hasArg();
            Option schemaRegistryLocation = OptionBuilder.create((char)'l');
            OptionBuilder.withLongOpt((String)SCHEMA_NAME_LONG_STR);
            OptionBuilder.withDescription((String)"DB Schema (Database) name in which the tables/views to be databusified is present");
            OptionBuilder.hasArg();
            Option schemaNameOption = OptionBuilder.create((char)'d');
            OptionBuilder.withLongOpt((String)DB_URI_LONG_STR);
            OptionBuilder.withDescription((String)"The URI for Oracle (Format : jdbc:oracle:thin:<user>/<password>@<dbhost>:1521:<SID>) or GG trail file location (Format : gg:///mnt/gg/extract/dbext<num>:x<num>)");
            OptionBuilder.hasArg();
            Option dbUriOption = OptionBuilder.create((char)'u');
            OptionBuilder.withLongOpt((String)SRC_NAMES_LONG_STR);
            OptionBuilder.withDescription((String)"Comma seperated list of source names (e.g : com.linkedin.events.liar.jobrelay.LiarJobRelay,com.linkedin.events.liar.memberrelay.LiarMemberRelay)");
            OptionBuilder.hasArg();
            Option srcNamesOption = OptionBuilder.create((char)'s');
            OptionBuilder.withLongOpt((String)OUTPUT_DIRECTORY_LONG_STR);
            OptionBuilder.withDescription((String)"Output Directory to generate the relay configs");
            OptionBuilder.hasArg();
            Option outputDirectoryOption = OptionBuilder.create((char)'o');
            this._cliOptions.addOption(helpOption);
            this._cliOptions.addOption(schemaRegistryLocation);
            this._cliOptions.addOption(schemaNameOption);
            this._cliOptions.addOption(dbUriOption);
            this._cliOptions.addOption(srcNamesOption);
            this._cliOptions.addOption(outputDirectoryOption);
        }

        public void printCliHelp() {
            this._helpFormatter.printHelp(this.getUsage(), this._cliOptions);
        }

        public String getUsage() {
            return this._usage;
        }

        public boolean processCommandLineArgs(String[] cliArgs) throws IOException, DatabusException {
            GnuParser cliParser = new GnuParser();
            this._cmd = null;
            try {
                this._cmd = cliParser.parse(this._cliOptions, cliArgs);
            }
            catch (ParseException pe) {
                System.err.println(NAME + ": failed to parse command-line options: " + pe.toString());
                this.printCliHelp();
                return false;
            }
            if (this._cmd.hasOption('h')) {
                this.printCliHelp();
                return false;
            }
            if (!this._cmd.hasOption('l')) {
                System.err.println("Please specify the schema registry location");
                return false;
            }
            this._schemaRegistryLocation = this._cmd.getOptionValue('l');
            File f = new File(this._schemaRegistryLocation);
            if (!f.isDirectory()) {
                System.err.println("Schema Registry (" + this._schemaRegistryLocation + ") is not a valid directory !! Please specify one");
                return false;
            }
            if (!this._cmd.hasOption('o')) {
                System.err.println("Please specify the output directory");
                return false;
            }
            this._outputDirectory = this._cmd.getOptionValue(OUTPUT_DIRECTORY_LONG_STR);
            f = new File(this._outputDirectory);
            if (!f.isDirectory()) {
                System.err.println("Output Directory (" + this._outputDirectory + ") is not a valid directory !! Please specify one");
                return false;
            }
            if (!this._cmd.hasOption('d')) {
                System.out.println("Please specify the Schema name !!");
                return false;
            }
            this._schemaName = this._cmd.getOptionValue('d');
            if (!this._cmd.hasOption('u')) {
                System.err.println("Plase specify the DB URI !!");
                return false;
            }
            this._dbUri = this._cmd.getOptionValue('u');
            if (!this._cmd.hasOption('s')) {
                System.err.println("Please specify comma seperated list of source names");
                return false;
            }
            this._srcNames = Arrays.asList(this._cmd.getOptionValue(SRC_NAMES_LONG_STR).split(","));
            return true;
        }

        public String getOutputDirectory() {
            return this._outputDirectory;
        }

        public String get_usage() {
            return this._usage;
        }

        public String getSchemaRegistryLocation() {
            return this._schemaRegistryLocation;
        }

        public String getSchemaName() {
            return this._schemaName;
        }

        public String getDbUri() {
            return this._dbUri;
        }

        public List<String> getSrcNames() {
            return this._srcNames;
        }
    }
}

