/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import com.linkedin.databus.util.CollectionTypeInfo;
import com.linkedin.databus.util.FieldInfo;
import com.linkedin.databus.util.SchemaUtils;
import com.linkedin.databus.util.SimpleTypeInfo;
import com.linkedin.databus.util.TableTypeInfo;
import com.linkedin.databus.util.TypeInfo;
import com.linkedin.databus.util.UserTypeInfo;
import java.io.StringWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class FieldToAvro {
    public String buildAvroSchema(String namespace, String topRecordAvroName, String topRecordDatabaseName, String[][] headers, TableTypeInfo topRecordTypeInfo) {
        if (namespace == null) {
            throw new IllegalArgumentException("namespace should not be null.");
        }
        if (topRecordAvroName == null) {
            throw new IllegalArgumentException("topRecordAvroName should not be null.");
        }
        if (topRecordDatabaseName == null) {
            throw new IllegalArgumentException("topRecordDatabaseName should not be null.");
        }
        if (topRecordTypeInfo == null) {
            throw new IllegalArgumentException("topRecordTypeInfo should not be null.");
        }
        FieldInfo fieldInfo = new FieldInfo(topRecordDatabaseName, topRecordTypeInfo, -1);
        Map<String, Object> field = this.fieldToAvro(fieldInfo, true);
        field.put("name", topRecordAvroName);
        field.put("namespace", namespace);
        try {
            SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy hh:mm:ss a zzz");
            field.put("doc", "Auto-generated Avro schema for " + topRecordDatabaseName + ". Generated at " + df.format(new Date(System.currentTimeMillis())));
            ObjectMapper mapper = new ObjectMapper();
            JsonFactory factory = new JsonFactory();
            StringWriter writer = new StringWriter();
            JsonGenerator jgen = factory.createJsonGenerator((Writer)writer);
            jgen.useDefaultPrettyPrinter();
            mapper.writeValue(jgen, field);
            return writer.getBuffer().toString();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Map<String, Object> fieldToAvro(FieldInfo fieldInfo, boolean asSchema) {
        TypeInfo typeInfo = fieldInfo.getFieldTypeInfo();
        if (typeInfo instanceof SimpleTypeInfo) {
            return this.simpleTypeToAvro(fieldInfo, (SimpleTypeInfo)typeInfo);
        }
        if (typeInfo instanceof UserTypeInfo) {
            return this.tableOrUserTypeToAvro(fieldInfo, (UserTypeInfo)typeInfo, asSchema);
        }
        if (typeInfo instanceof CollectionTypeInfo) {
            return this.collectionTypeToAvro(fieldInfo, (CollectionTypeInfo)typeInfo);
        }
        return null;
    }

    private Map<String, Object> collectionTypeToAvro(FieldInfo fieldInfo, CollectionTypeInfo typeInfo) {
        HashMap<String, Object> field = new HashMap<String, Object>();
        String name = SchemaUtils.toCamelCase(fieldInfo.getFieldName());
        field.put("name", name);
        FieldInfo elementFieldInfo = new FieldInfo(typeInfo.getElementTypeInfo().getName(), typeInfo.getElementTypeInfo(), 0);
        Map<String, Object> itemsRecordType = this.fieldToAvro(elementFieldInfo, true);
        HashMap<String, Object> arrayType = new HashMap<String, Object>();
        arrayType.put("name", name + "Array");
        arrayType.put("type", "array");
        arrayType.put("items", itemsRecordType);
        ArrayList<Object> nullableType = new ArrayList<Object>();
        nullableType.add("null");
        nullableType.add(arrayType);
        field.put("type", nullableType);
        field.put("default", null);
        String dbFieldName = fieldInfo.getFieldName();
        int dbFieldPosition = fieldInfo.getFieldPosition();
        String dbFieldType = fieldInfo.getFieldTypeInfo().getName();
        String meta = this.buildMetaString(dbFieldName, dbFieldPosition, dbFieldType, null);
        itemsRecordType.put("meta", meta);
        return field;
    }

    private Map<String, Object> tableOrUserTypeToAvro(FieldInfo fieldInfo, UserTypeInfo typeInfo, boolean asSchema) {
        HashMap<String, Object> fieldsDest;
        HashMap<String, Object> field = new HashMap<String, Object>();
        String name = SchemaUtils.toCamelCase(fieldInfo.getFieldName());
        field.put("name", name);
        HashMap<String, String> realType = new HashMap<String, String>();
        HashMap<String, Object> hashMap = fieldsDest = asSchema ? field : realType;
        if (asSchema) {
            field.put("type", "record");
        } else {
            realType.put("type", "record");
            realType.put("name", typeInfo.getName());
            ArrayList<Object> nullableType = new ArrayList<Object>();
            nullableType.add("null");
            nullableType.add(realType);
            field.put("type", nullableType);
            field.put("default", null);
        }
        ArrayList<Map<String, Object>> fields = new ArrayList<Map<String, Object>>();
        for (FieldInfo childField : typeInfo.getFields()) {
            Map<String, Object> childFieldMap = this.fieldToAvro(childField, false);
            fields.add(childFieldMap);
        }
        fieldsDest.put("fields", fields);
        String dbFieldName = fieldInfo.getFieldName();
        int dbFieldPosition = fieldInfo.getFieldPosition();
        String dbFieldType = fieldInfo.getFieldTypeInfo().getName();
        String pk = typeInfo.getPrimaryKey();
        String meta = this.buildMetaString(dbFieldName, dbFieldPosition, dbFieldType, pk);
        field.put("meta", meta);
        return field;
    }

    private Map<String, Object> simpleTypeToAvro(FieldInfo fieldInfo, SimpleTypeInfo typeInfo) {
        HashMap<String, Object> field = new HashMap<String, Object>();
        String name = SchemaUtils.toCamelCase(fieldInfo.getFieldName());
        field.put("name", name);
        field.put("default", null);
        String[] type = new String[]{"null", typeInfo.getPrimitiveType().getAvroType()};
        field.put("type", type);
        String dbFieldName = fieldInfo.getFieldName();
        int dbFieldPosition = fieldInfo.getFieldPosition();
        String dbFieldType = fieldInfo.getFieldTypeInfo().getName();
        String meta = this.buildMetaString(dbFieldName, dbFieldPosition, dbFieldType, null);
        field.put("meta", meta);
        return field;
    }

    private String buildMetaString(String dbFieldName, int dbFieldPosition, String dbFieldType, String pk) {
        StringBuilder meta = new StringBuilder();
        if (dbFieldName != null) {
            meta.append("dbFieldName=" + dbFieldName + ";");
        }
        if (dbFieldPosition != -1) {
            meta.append("dbFieldPosition=" + dbFieldPosition + ";");
        }
        if (dbFieldType != null) {
            meta.append("dbFieldType=" + dbFieldType + ";");
        }
        if (null != pk && !pk.isEmpty()) {
            meta.append("pk=" + pk + ";");
        }
        return meta.toString();
    }
}

