/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.util.DevRelayConfigGenerator;
import com.linkedin.databus.util.FieldToAvro;
import com.linkedin.databus.util.InteractiveSchemaGeneratorCli;
import com.linkedin.databus.util.SchemaMetaDataManager;
import com.linkedin.databus.util.SchemaUtils;
import com.linkedin.databus.util.TableTypeInfo;
import com.linkedin.databus.util.TypeInfoFactoryInteractive;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import com.linkedin.databus2.util.DBHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jline.Completor;
import jline.ConsoleReader;
import jline.SimpleCompletor;
import org.apache.avro.Schema;
import org.apache.avro.specific.SpecificCompiler;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class InteractiveSchemaGenerator {
    private static final String[] DEFAULT_JDBC_DRIVERS = new String[]{"oracle.jdbc.driver.OracleDriver"};
    protected static final String DEFAULT_DATABASE = "jdbc:oracle:thin:@devdb:1521:db";
    protected static final String DEFAULT_SCHEMA_REGISTRY_LOCATION = "/export/content/data/databus2_events";
    private static final String DEFAULT_SCHEMA_REGISTRY_SVN_LOCATION = "svn+ssh://svn.corp.linkedin.com/netrepo/databus-events/trunk/databus-events";
    private static final String DEFAULT_RELAY_CONFIG_LOCATION = "/export/content/data/databus2_relay_sources/";
    private static final String PATH_TO_SVN = "/export/apps/xtools/bin/svn";
    private static final String NAMESPACE_PREFIX = "com.linkedin.events";
    private static final String DATABUS_EVENTS_SUFFIX = "/databus-events/src/main/java/";
    private static final String DATABUS_SCHEMAS_SUFFIX = "/schemas_registry/";
    private static final String[] GEN_SCHEMA_OPTIONS = new String[]{"GENSCHEMA", "CHANGETAB", "RESET", "GENRELAYCONFIG", "EXIT"};
    private static final String[] GEN_SCHEMA_HELP = new String[]{"GENSCHEMA - This option is used to generate the avro schema (used by databus) for the table you have selected. The schemas can be generated for both existing table/view or new table/view using this option.. If you would like to generate the schema for a different view/table than what you have selected, change the table using CHANGETAB option", "CHANGETAB -  Use this option if you would like to change the database and table/view you have selected for schema generation", "RESET - This option clears all the uncommitted changes from the schema registry (****Please note this option deletes the schema registry and checks out a fresh copy, you might lose any schemas that you have generated, if you have not committed them*****)", "GENRELAYCONFIG - This option is used to generate the relay configs for the current selected table/view. This config generated can be used to deploy the relay in the dev environment for the current table/view.", "EXIT - Exit the schema registry tool"};
    private final String SCHEMAREGISTRY_INDEX = "index.schemas_registry";
    private FileSystemSchemaRegistryService _schemaRegistryService;
    private boolean _areFieldsFiltered = true;
    private State currentState;
    boolean _verbose = false;
    String _database;
    String _schemaName;
    String _userName;
    String _password;
    String _tableName;
    String _schemaRegistryLocation;
    Connection _conn;
    List<String> _primaryKeys = null;
    List<String> _userFields = null;
    Completor _currentCompletor = null;
    ConsoleReader _reader = null;
    Pattern _versionRegexPattern = Pattern.compile("(.*)_\\d+");
    HashMap<String, String> _dbFieldToAvroDataType;
    boolean _automatic;
    public SchemaMetaDataManager _manager = null;

    public InteractiveSchemaGenerator() {
        this.currentState = State.INITIATECONN;
        this.loadJdbcDrivers();
        this._verbose = false;
    }

    public String toString() {
        return "InteractiveSchemaGenerator{SCHEMAREGISTRY_INDEX='index.schemas_registry', _schemaRegistryService=" + this._schemaRegistryService + ", _database='" + this._database + '\'' + ", _schemaName='" + this._schemaName + '\'' + ", _userName='" + this._userName + '\'' + ", _password='" + this._password + '\'' + ", _tableName='" + this._tableName + '\'' + ", _schemaRegistryLocation='" + this._schemaRegistryLocation + '\'' + ", _conn=" + this._conn + ", _primaryKeys=" + this._primaryKeys + ", _userFields=" + this._userFields + ", _dbFieldToAvroDataType=" + this._dbFieldToAvroDataType + ", _automatic=" + this._automatic + ", _manager=" + this._manager + ", currentState=" + (Object)((Object)this.currentState) + '}';
    }

    public InteractiveSchemaGenerator(InteractiveSchemaGeneratorCli cli) throws IOException, SQLException, DatabusException {
        this._database = cli.getDburl();
        this._userName = cli.getUser();
        this._password = cli.getPassword();
        this._schemaName = cli.getDbName();
        this._tableName = cli.getTableName();
        this._schemaRegistryLocation = cli.getSchemaRegistryPath();
        this.verifyAndCheckoutSchemaRegistry(this._schemaRegistryLocation);
        this._manager = new SchemaMetaDataManager(this._schemaRegistryLocation + "/schemas_registry");
        this._userFields = cli.getFields();
        this._primaryKeys = cli.getPrimaryKeys();
        this._dbFieldToAvroDataType = cli.getDbFieldToAvroDataType();
        this.loadSchemaRegistry();
        this._conn = this.getConnection();
        this._automatic = cli.isAutomatic();
        File tempFile = new File(this._schemaRegistryLocation);
        if (!tempFile.exists()) {
            System.out.println("The is no directory at " + this._schemaRegistryLocation + ". Attempting to checkout a new copy at this location..");
            ProcessBuilder pb = new ProcessBuilder(PATH_TO_SVN, "checkout", DEFAULT_SCHEMA_REGISTRY_SVN_LOCATION, this._schemaRegistryLocation);
            if (this.executeProcessBuilder(pb) != 0) {
                throw new DatabusException("Unable to checkout the code in the given directory");
            }
        }
    }

    public void run() throws Exception {
        this.printWelcomeMessage();
        this._reader = new ConsoleReader();
        this._reader.setDefaultPrompt("SchemaGen>");
        this._reader.setBellEnabled(false);
        this.processInput();
    }

    private void printWelcomeMessage() {
        System.out.println("Welcome to Databus for Oracle - schema generation tool.");
    }

    private void processInput() throws Exception {
        boolean done = false;
        block8: while (!done) {
            switch (this.currentState) {
                case INITIATECONN: {
                    System.out.println("Enter the location of the schema registry (Hit enter to checkout out a new copy at [/export/content/data/databus2_events] and use it):");
                    String line = this.checkAndRead();
                    this._schemaRegistryLocation = line.equals("") ? DEFAULT_SCHEMA_REGISTRY_LOCATION : line;
                    if (!this.verifyAndCheckoutSchemaRegistry(this._schemaRegistryLocation)) {
                        System.out.println("Unable to checkout the schema registry at the [" + this._schemaRegistryLocation + "], please retry..");
                        continue block8;
                    }
                    this.loadSchemaRegistry();
                    this._manager = new SchemaMetaDataManager(this._schemaRegistryLocation + "/schemas_registry");
                    System.out.println("Using Database url : [ jdbc:oracle:thin:@devdb:1521:db ] to connect to DB (Hit enter to use this, or enter a valid database string): ");
                    this._database = DEFAULT_DATABASE;
                    line = this.checkAndRead();
                    if (!line.isEmpty()) {
                        this._database = line;
                        System.out.println("Overriding default Database url with: [" + this._database + "]");
                    }
                    System.out.println("Enter the username for the database:");
                    this._userName = this.checkAndRead();
                    System.out.println("Enter the password for the database:");
                    this._password = this.checkAndRead();
                    System.out.println("Attempting to connect with the database..");
                    try {
                        this._conn = this.getConnection();
                    }
                    catch (SQLException e) {
                        System.out.println("ERROR: Unable to connect with the db with the given credentials, please try again: " + e.toString());
                        continue block8;
                    }
                    this.currentState = State.TABLEINFO;
                    continue block8;
                }
                case TABLEINFO: {
                    this._schemaName = this._userName.toUpperCase(Locale.ENGLISH);
                    System.out.println("Enter the Oracle DB name (Hit enter to use [ " + this._schemaName + " ] as the DB name):");
                    String line = this.checkAndRead();
                    if (!line.isEmpty()) {
                        this._schemaName = line;
                    }
                    List<String> tablesList = null;
                    tablesList = this.getTablesInDB();
                    tablesList.addAll(this.getViewsInDB());
                    this.addListToCompletor(tablesList);
                    System.out.println("Enter the name of table/view you would like to generate the schema for (use tab to autocomplete table names)):");
                    this._tableName = this.checkAndRead();
                    if (!this.isValidSchema()) {
                        System.out.println("The schema [" + this._schemaName + "] doesn't appear to be a valid schema");
                        continue block8;
                    }
                    if (!this.isValidTable() && !this.isValidView()) {
                        System.out.println("This table [" + this._tableName + "] doesn't appear to be valid table or view, please retry");
                        continue block8;
                    }
                    System.out.println("Attempting to identify primary keys..");
                    this._primaryKeys = this.getPrimaryKeys();
                    for (String key : this._primaryKeys) {
                        System.out.println(key);
                    }
                    if (this._primaryKeys.size() > 0) {
                        System.out.println("If you would like to use the above as primary key(s) hit enter, or enter a comma separated list of fields to use as primary keys:");
                    } else {
                        System.out.println("Couldn't identify primary keys, enter a comma separated list of fields to use as primary keys:");
                    }
                    String pkList = this.checkAndRead();
                    if (!pkList.isEmpty()) {
                        System.out.println("Overriding default primary keys with: ");
                        this._primaryKeys = this.fieldToList(pkList);
                        if (this._primaryKeys == null) {
                            System.out.println("You input does not have valid primary keys, please retry");
                            continue block8;
                        }
                        System.out.println(this._primaryKeys);
                    }
                    System.out.println("Using " + this._primaryKeys.toString() + " as primary key(s)");
                    System.out.println("Enter a comma separated list of fields you would like to include in the avro schema for databus (Use tab to autocomplete), [Hit enter to use all fields in the table]: ");
                    List<String> fieldsInTable = this.getFieldsInTable(this._tableName);
                    this.addListToCompletor(fieldsInTable);
                    String fieldList = this.checkAndRead();
                    if (fieldList.isEmpty()) {
                        this._userFields = fieldsInTable;
                        this._areFieldsFiltered = false;
                    } else {
                        this._userFields = this.fieldToList(fieldList);
                        this._areFieldsFiltered = true;
                    }
                    if (this._userFields == null) continue block8;
                    if (this._userFields.size() == 0) {
                        System.out.println("You have not selected any fields! Please retry");
                    } else {
                        System.out.println("These are the chosen fields: ");
                        for (String field : this._userFields) {
                            System.out.println(field);
                        }
                    }
                    this.removeCurrentCompletor();
                    this.currentState = State.SCHEMA_MANIPULATION;
                    continue block8;
                }
                case SCHEMA_MANIPULATION: {
                    this.printSchemaManipulationHelp();
                    this.addArrayToCompletor(GEN_SCHEMA_OPTIONS);
                    String line = this.checkAndRead();
                    this.invokeSchemaFunctions(line);
                    continue block8;
                }
                case EXIT: {
                    System.out.println("Schema generation is complete");
                    done = true;
                    continue block8;
                }
            }
            throw new Exception("Undefined state!");
        }
    }

    private String checkAndRead() throws IOException {
        String line = this._reader.readLine();
        if (line == null) {
            System.out.println("Unable to read a valid input from the console");
            return null;
        }
        return line.trim();
    }

    private void addListToCompletor(List<String> completorList) {
        if (completorList == null || completorList.size() == 0) {
            return;
        }
        String[] completorArray = completorList.toArray(new String[completorList.size()]);
        this.addArrayToCompletor(completorArray);
    }

    private void addArrayToCompletor(String[] completorArray) {
        this.removeCurrentCompletor();
        if (completorArray == null || completorArray.length == 0) {
            return;
        }
        this._currentCompletor = new SimpleCompletor(completorArray);
        this._reader.addCompletor(this._currentCompletor);
    }

    private void removeCurrentCompletor() {
        if (this._currentCompletor != null) {
            this._reader.removeCompletor(this._currentCompletor);
        }
        this._currentCompletor = null;
    }

    public void loadJdbcDrivers() {
        for (String driver : DEFAULT_JDBC_DRIVERS) {
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Could not load JDBC driver: " + driver);
            }
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            if (this._verbose) {
                System.out.println("Connecting to database: " + this._database);
            }
            Connection con = DriverManager.getConnection(this._database, this._userName, this._password);
            if (this._verbose) {
                System.out.println("Connected successfully.");
            }
            return con;
        }
        catch (SQLException ex) {
            System.out.println("Could not connect to database: " + this._database);
            System.out.println(ex.getMessage());
            if (this._verbose) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidTable() {
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            preparedStatement = this._conn.prepareStatement("select table_name from user_tables where table_name=?");
            preparedStatement.setString(1, this._tableName.toUpperCase(Locale.ENGLISH));
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                this.cleanUpConnMeta(rs, preparedStatement);
                return bl;
            }
            this.cleanUpConnMeta(rs, preparedStatement);
        }
        catch (SQLException e) {
            try {
                System.out.println("ERROR: Unable to determine if it's a valid table: " + e.toString());
                boolean bl = false;
                this.cleanUpConnMeta(rs, preparedStatement);
                return bl;
            }
            catch (Throwable throwable) {
                this.cleanUpConnMeta(rs, preparedStatement);
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidView() {
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            preparedStatement = this._conn.prepareStatement("select view_name from user_views where view_name=?");
            preparedStatement.setString(1, this._tableName.toUpperCase(Locale.ENGLISH));
            rs = preparedStatement.executeQuery();
            if (rs.next()) {
                boolean bl = true;
                this.cleanUpConnMeta(rs, preparedStatement);
                return bl;
            }
            this.cleanUpConnMeta(rs, preparedStatement);
        }
        catch (SQLException e) {
            try {
                System.out.println("ERROR: Unable to determine if it's a valid view: " + e.toString());
                this.cleanUpConnMeta(rs, preparedStatement);
            }
            catch (Throwable throwable) {
                this.cleanUpConnMeta(rs, preparedStatement);
                throw throwable;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidSchema() {
        ResultSet rs = null;
        PreparedStatement statement = null;
        try {
            String query = String.format("select count(*) as count from %s.%s", this._schemaName, this._tableName);
            statement = this._conn.prepareStatement(query);
            rs = statement.executeQuery();
            if (rs.next() && rs.getInt("count") >= 0) {
                boolean bl = true;
                this.cleanUpConnMeta(rs, statement);
                return bl;
            }
            this.cleanUpConnMeta(rs, statement);
        }
        catch (SQLException e) {
            try {
                System.out.println("ERROR: Unable to determine if it's a valid schema : " + e.toString());
                boolean bl = false;
                this.cleanUpConnMeta(rs, statement);
                return bl;
            }
            catch (Throwable throwable) {
                this.cleanUpConnMeta(rs, statement);
                throw throwable;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValidField(String field) {
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            preparedStatement = this._conn.prepareStatement("select count(1) as count from all_tab_cols where OWNER=? AND TABLE_NAME=? AND COLUMN_NAME=?");
            preparedStatement.setString(1, this._schemaName);
            preparedStatement.setString(2, this._tableName);
            preparedStatement.setString(3, field);
            rs = preparedStatement.executeQuery();
            boolean bl = rs.next() && rs.getInt("count") > 0;
            this.cleanUpConnMeta(rs, preparedStatement);
            return bl;
        }
        catch (SQLException e) {
            try {
                System.out.println("ERROR: Unable to determine if it's a valid field ( " + field + "): " + e.toString());
                boolean bl = false;
                this.cleanUpConnMeta(rs, preparedStatement);
                return bl;
            }
            catch (Throwable throwable) {
                this.cleanUpConnMeta(rs, preparedStatement);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTablesInDB() {
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            preparedStatement = this._conn.prepareStatement("select table_name from user_tables");
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("table_name"));
            }
            this.cleanUpConnMeta(rs, preparedStatement);
        }
        catch (SQLException e) {
            try {
                System.out.println("ERROR: Unable to fetch the table names in the database specified: " + e.toString());
                this.cleanUpConnMeta(rs, preparedStatement);
            }
            catch (Throwable throwable) {
                this.cleanUpConnMeta(rs, preparedStatement);
                throw throwable;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getViewsInDB() {
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            preparedStatement = this._conn.prepareStatement("select view_name from user_views");
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("view_name"));
            }
            this.cleanUpConnMeta(rs, preparedStatement);
        }
        catch (SQLException e) {
            try {
                System.out.println("ERROR: Unable to fetch the view names in the database specified: " + e.toString());
                this.cleanUpConnMeta(rs, preparedStatement);
            }
            catch (Throwable throwable) {
                this.cleanUpConnMeta(rs, preparedStatement);
                throw throwable;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getPrimaryKeys() {
        ArrayList<String> list = new ArrayList<String>();
        String primaryKeyQuery = "SELECT cols.column_name as primary_key FROM all_constraints cons, all_cons_columns cols WHERE cols.table_name = ? AND cons.constraint_type = 'P' AND cons.constraint_name = cols.constraint_name AND cons.owner = cols.owner ORDER BY cols.position";
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            preparedStatement = this._conn.prepareStatement(primaryKeyQuery);
            preparedStatement.setString(1, this._tableName);
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("primary_key"));
            }
            this.cleanUpConnMeta(rs, preparedStatement);
        }
        catch (SQLException e) {
            System.out.println("Unable to determined the primary keys for the given table, this is expected if input was a view");
        }
        finally {
            this.cleanUpConnMeta(rs, preparedStatement);
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getFieldsInTable(String table) {
        ArrayList<String> list = new ArrayList<String>();
        String fieldsFetchQuery = "select COLUMN_NAME from all_tab_cols where OWNER=? AND table_name=?";
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            preparedStatement = this._conn.prepareStatement(fieldsFetchQuery);
            preparedStatement.setString(1, this._schemaName);
            preparedStatement.setString(2, this._tableName);
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                list.add(rs.getString("COLUMN_NAME"));
            }
            this.cleanUpConnMeta(rs, preparedStatement);
        }
        catch (SQLException e) {
            try {
                System.out.println("Unable to determine the fields from the given table: " + e.toString());
                this.cleanUpConnMeta(rs, preparedStatement);
            }
            catch (Throwable throwable) {
                this.cleanUpConnMeta(rs, preparedStatement);
                throw throwable;
            }
        }
        return list;
    }

    private List<String> fieldToList(String fieldList) {
        String[] fieldArray = fieldList.split(",");
        ArrayList<String> fieldArrayList = new ArrayList<String>();
        if (fieldList.length() == 0) {
            return null;
        }
        for (String field : fieldArray) {
            if (!this.isValidField(field.trim())) {
                System.out.println("The field " + field + " is not a valid field in the table, please retry");
                return null;
            }
            fieldArrayList.add(field.trim().toUpperCase(Locale.ENGLISH));
        }
        return fieldArrayList;
    }

    private void cleanUpConnMeta(ResultSet rs, PreparedStatement preparedStatement) {
        DBHelper.close((ResultSet)rs);
        DBHelper.close((Statement)preparedStatement);
    }

    private boolean verifyAndCheckoutSchemaRegistry(String schemaRegistryLocation) {
        File tempFile = new File(schemaRegistryLocation);
        if (!tempFile.exists() && !tempFile.mkdirs()) {
            return false;
        }
        ProcessBuilder pb = new ProcessBuilder(PATH_TO_SVN, "checkout", DEFAULT_SCHEMA_REGISTRY_SVN_LOCATION, schemaRegistryLocation);
        return this.executeProcessBuilder(pb) == 0;
    }

    private boolean deleteAndCheckoutSchemaRegistry(String schemaRegistryLocation) {
        ProcessBuilder pb = new ProcessBuilder("/bin/rm", "-rf", schemaRegistryLocation);
        if (this.executeProcessBuilder(pb) == 0) {
            return this.verifyAndCheckoutSchemaRegistry(schemaRegistryLocation);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int executeProcessBuilder(ProcessBuilder pb) {
        int rc;
        System.out.println("Checking out the schema registry using svn..");
        InputStreamReader isr = null;
        BufferedReader br = null;
        try {
            String lineRead;
            Process process = pb.start();
            isr = new InputStreamReader(process.getInputStream(), "UTF8");
            br = new BufferedReader(isr);
            while ((lineRead = br.readLine()) != null) {
                System.out.println(lineRead);
            }
            rc = process.waitFor();
            br.close();
            isr.close();
        }
        catch (IOException e) {
            System.out.println("Error while manipulating the schema registry: " + e.toString());
            int n = 1;
            return n;
        }
        catch (InterruptedException e) {
            System.out.println("Error while manipulating the schema registry: " + e.toString());
            int n = 1;
            return n;
        }
        finally {
            if (isr != null) {
                try {
                    isr.close();
                }
                catch (IOException e) {
                    System.out.println("Error while manipulating the schema registry: " + e.toString());
                }
            }
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    System.out.println("Error while manipulating the schema registry: " + e.toString());
                }
            }
        }
        return rc;
    }

    private void printSchemaManipulationHelp() {
        System.out.println("Choose one of the operations you want to perform (Tab to autocomplete)");
        for (String helpOption : GEN_SCHEMA_HELP) {
            System.out.println(helpOption);
        }
    }

    private void invokeSchemaFunctions(String operation) throws IOException {
        if ((operation = operation.trim()).equals(GEN_SCHEMA_OPTIONS[0])) {
            System.out.println("\n\n\n\n A new databus avro schema needs to be created only :");
            System.out.println("\n\t a) For a brand new Table/View for which databus schema does not exist.");
            System.out.println("\n\t b) When table/View schema changed and the latest databus schema does not reflect the table/view schema changes.");
            System.out.println("\n\n For Schema Generation needed for Mult-Colo, please look at https://iwww.corp.linkedin.com/wiki/cf/display/ENGS/Databus+GoldenGate+Client+Launches to verify if the table/View is already databusified.");
            System.out.println("\n\n If the schema already exists, you can look at " + this._schemaRegistryLocation + "/schemas_registry to verify if the latest version of schema matches with the table/view  schema you expected.");
            if (this.promptForYesOrNoQuestion("Are you sure you want to generate new schema ")) {
                this.runSchemaGenTool();
            }
            System.out.println("\n\n");
        } else {
            if (operation.equals(GEN_SCHEMA_OPTIONS[1])) {
                this.currentState = State.INITIATECONN;
                return;
            }
            if (operation.equals(GEN_SCHEMA_OPTIONS[2])) {
                this.deleteAndCheckoutSchemaRegistry(this._schemaRegistryLocation);
            } else if (operation.equals(GEN_SCHEMA_OPTIONS[3])) {
                boolean success = false;
                try {
                    this.buildRelayConfigs();
                    if (this.currentState != State.EXIT) {
                        success = true;
                    }
                }
                catch (Exception e) {
                    System.out.println("Error while generating the relay configs: " + e);
                }
                if (success) {
                    System.out.println("Relay config generation is complete");
                }
                System.out.println("******************************************************************************************************************************************");
            } else if (operation.equals(GEN_SCHEMA_OPTIONS[4])) {
                this.currentState = State.EXIT;
            } else {
                System.out.println("Unknown option, please retry");
            }
        }
    }

    public boolean runSchemaGenTool() {
        if (this._automatic) {
            System.out.println("\n\n Starting the schema generation with the following settings: " + this.toString());
        }
        System.out.println("\n\n Generating schema for " + this._tableName);
        StringBuilder pKeyList = new StringBuilder();
        for (int i = 0; i < this._primaryKeys.size(); ++i) {
            String avroName = SchemaUtils.toCamelCase(this._primaryKeys.get(i));
            pKeyList.append(avroName);
            if (i == this._primaryKeys.size() - 1) continue;
            pKeyList.append(",");
        }
        try {
            Matcher m;
            TableTypeInfo ti = (TableTypeInfo)new TypeInfoFactoryInteractive().getTypeInfo(this._conn, this._schemaName, this._tableName, 0, 0, pKeyList.toString(), this._reader, this._dbFieldToAvroDataType);
            String namespace = "com.linkedin.events." + this._schemaName.toLowerCase(Locale.ENGLISH);
            if (!this._automatic) {
                System.out.println("********************************************************************************************************");
                System.out.println("Hit enter to use the default namespace[" + namespace + "] or type the namespace you would like to use: ");
                String line = this.checkAndRead();
                if (!line.isEmpty()) {
                    namespace = line;
                    System.out.println("Overriding the default namespace with [" + namespace + "]");
                }
            } else {
                System.out.println("Using the default namespace [" + namespace + "]");
            }
            String topRecordDatabaseName = this._tableName;
            File avroOutDir = new File(this._schemaRegistryLocation + DATABUS_SCHEMAS_SUFFIX);
            File javaOutDir = new File(this._schemaRegistryLocation + DATABUS_EVENTS_SUFFIX);
            String recordName = this._tableName.toLowerCase(Locale.ENGLISH);
            if (recordName.toUpperCase(Locale.ENGLISH).startsWith("SY$") && (m = this._versionRegexPattern.matcher(recordName = recordName.substring(3))).find()) {
                recordName = m.group(1);
            }
            recordName = SchemaUtils.toCamelCase(recordName, true);
            if (!this._automatic) {
                System.out.println("User input for field datatypes complete.");
                System.out.println("********************************************************************************************************");
                System.out.println("Hit enter to use the default record name [" + recordName + "] or type the record name you would like to use: ");
                String line = this.checkAndRead();
                if (!line.isEmpty()) {
                    recordName = line;
                    System.out.println("Overriding the default record name with [" + recordName + "]");
                }
            } else {
                System.out.println("Using the recordname:  [" + recordName + "]");
            }
            Integer avroOutVersion = this.getLatestVersionNumber(namespace + "." + recordName);
            if (avroOutVersion == -1) {
                System.out.println("Unable to determine the schema version, cannot proceed with schema generation");
            }
            Integer n = avroOutVersion;
            Integer n2 = avroOutVersion = Integer.valueOf(avroOutVersion + 1);
            if (!this._automatic) {
                System.out.println("Hit enter to use the schema version : " + avroOutVersion + " or type the version you would like to use: ");
                String line = this.checkAndRead();
                if (!line.isEmpty()) {
                    try {
                        avroOutVersion = Integer.parseInt(line);
                    }
                    catch (NumberFormatException e) {
                        System.out.println("Invalid input, unable to parse the version specified " + e);
                    }
                    System.out.println("Overriding the default version with [" + avroOutVersion + "]");
                }
            } else {
                System.out.println("Using the avro version:  [" + avroOutVersion + "]");
            }
            String topRecordAvroName = recordName + "_V" + avroOutVersion.toString();
            if (avroOutVersion == 1) {
                String srcName = namespace + "." + recordName;
                this._manager.updateAndGetNewSrcId(this._schemaName, srcName);
            }
            FieldToAvro fa = new FieldToAvro();
            String schema = fa.buildAvroSchema(namespace, topRecordAvroName, topRecordDatabaseName, null, ti);
            System.out.println("Generated Schema:\n" + schema);
            schema = this.filterUserFields(schema);
            System.out.println("Changing schema to user required fields:\n" + schema);
            String avroFileName = namespace + "." + recordName + "." + avroOutVersion.toString() + ".avsc";
            File avroOutFile = new File(avroOutDir, avroFileName);
            System.out.println("Avro schema will be saved in the file: " + avroOutFile.getAbsolutePath());
            PrintWriter pw = new PrintWriter(avroOutFile, "UTF-8");
            pw.println(schema);
            pw.flush();
            pw.close();
            System.out.println("Generating Java files in the directory: " + javaOutDir.getAbsolutePath());
            SpecificCompiler.compileSchema((File)avroOutFile, (File)javaOutDir);
            this.addNameSpaceToIndex(avroFileName);
            this._manager.store();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            System.out.println("Exception while generating schema: " + e.toString());
            return false;
        }
        System.out.println("Schema generated at " + this._schemaRegistryLocation + ". Please submit a review request (using svin) to the Databus team.");
        return true;
    }

    private String filterUserFields(String schema) throws IOException, DatabusException {
        if (!this._areFieldsFiltered) {
            return schema;
        }
        Schema avroSchema = Schema.parse((String)schema);
        ObjectMapper mapper = new ObjectMapper();
        JsonFactory factory = new JsonFactory();
        StringWriter writer = new StringWriter();
        JsonGenerator jgen = factory.createJsonGenerator((Writer)writer);
        jgen.useDefaultPrettyPrinter();
        HashMap schemaMap = (HashMap)new ObjectMapper().readValue(schema, HashMap.class);
        ArrayList list = (ArrayList)schemaMap.get("fields");
        int i = 0;
        while (i < list.size()) {
            Schema.Field field = avroSchema.getField((String)((HashMap)list.get(i)).get("name"));
            if (field.schema().getType() == Schema.Type.ARRAY) {
                throw new DatabusException("Field not supported for filtering");
            }
            String dbFieldName = SchemaHelper.getMetaField((Schema.Field)field, (String)"dbFieldName");
            if (dbFieldName == null) {
                throw new DatabusException("Unable to determine the dbFieldName from the meta information");
            }
            if (!this._userFields.contains(dbFieldName.toUpperCase(Locale.ENGLISH))) {
                list.remove(i);
                continue;
            }
            ++i;
        }
        mapper.writeValue(jgen, (Object)schemaMap);
        return writer.getBuffer().toString();
    }

    private void addNameSpaceToIndex(String avroFileName) throws Exception {
        String indexLocation = this._schemaRegistryLocation + DATABUS_SCHEMAS_SUFFIX + "index.schemas_registry";
        BufferedReader index = null;
        BufferedWriter writeIndex = null;
        try {
            String fileName;
            index = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(indexLocation), "UTF-8"));
            ArrayList<String> fileNameList = new ArrayList<String>();
            while ((fileName = index.readLine()) != null) {
                fileNameList.add(fileName);
            }
            System.out.println("Adding the new schema " + avroFileName + " to the schema registry index");
            fileNameList.add(avroFileName);
            Collections.sort(fileNameList);
            writeIndex = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(indexLocation), "UTF-8"));
            for (String fName : fileNameList) {
                writeIndex.write(fName);
                writeIndex.newLine();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            System.out.println("Error adding the generated schema to the schema registry index (meta information was not added)" + e.toString());
            throw e;
        }
        finally {
            if (writeIndex != null) {
                try {
                    writeIndex.close();
                }
                catch (IOException e) {
                    System.out.println("Error while closing index.schema_registry: " + e);
                }
            }
            if (index != null) {
                try {
                    index.close();
                }
                catch (IOException e) {
                    System.out.println("Error while closing index.schema_registry: " + e);
                }
            }
        }
    }

    private boolean loadSchemaRegistry() {
        try {
            FileSystemSchemaRegistryService.Config configBuilder = new FileSystemSchemaRegistryService.Config();
            configBuilder.setFallbackToResources(true);
            configBuilder.setSchemaDir(this._schemaRegistryLocation + DATABUS_SCHEMAS_SUFFIX);
            FileSystemSchemaRegistryService.StaticConfig config = configBuilder.build();
            this._schemaRegistryService = FileSystemSchemaRegistryService.build((FileSystemSchemaRegistryService.StaticConfig)config);
        }
        catch (InvalidConfigException e) {
            System.out.println("Error while attempting to load the schema registry: " + e.toString());
            return false;
        }
        return true;
    }

    private int getLatestVersionNumber(String nameSpace) {
        System.out.println("Checking if there is an existing schema for: " + nameSpace);
        try {
            Map _schemaVersionMap = this._schemaRegistryService.fetchAllSchemaVersionsBySourceName(nameSpace);
            short maxVersion = -1;
            if (_schemaVersionMap.size() == 0) {
                System.out.println("The schema does not exist in the schema registry, this will be the first version");
                return 0;
            }
            Iterator i$ = _schemaVersionMap.keySet().iterator();
            while (i$.hasNext()) {
                short version = (Short)i$.next();
                if (version <= maxVersion) continue;
                maxVersion = version;
            }
            System.out.println("There is already a avro schema already existing for this table with verion: " + maxVersion);
            return maxVersion;
        }
        catch (DatabusException e) {
            System.out.println("Unable to determine the version of the schema to be generated: " + e.toString());
            return -1;
        }
    }

    private boolean promptForYesOrNoQuestion(String msg) throws IOException {
        HashSet<String> choices = new HashSet<String>(Arrays.asList("y", "n"));
        String answerStr = this.promptMultiChoiceQuestion(msg + "(y/n) ?", new MultipleChoiceChecker(choices));
        boolean answer = answerStr.toLowerCase(Locale.ENGLISH).startsWith("y");
        return answer;
    }

    private String promptMultiChoiceQuestion(String msg, UserInputChecker checker) throws IOException {
        boolean validInput = false;
        String answer = null;
        while (!validInput) {
            System.out.println(msg);
            answer = this.checkAndRead();
            if (answer == null) {
                answer = "";
            }
            validInput = checker.isValidInput(answer);
        }
        return answer;
    }

    private void generateRelayConfig(String schemaRegistryLocation, String dbName, String uri, String outputDir) throws Exception {
        List<String> srcs = this._manager.getManagedSourcesForDB(dbName.trim().toLowerCase(Locale.ENGLISH));
        if (null == srcs) {
            String error = "No Sources found for database (" + dbName + "). Available sources are :" + this._manager.getDbToSrcMap();
            System.out.println(error);
            throw new DatabusException(error);
        }
        ArrayList<String> addSrcs = new ArrayList<String>();
        for (String src : srcs) {
            boolean add = this.promptForYesOrNoQuestion("Do you want to add the src (" + src + ") to the relay config ");
            if (!add) continue;
            addSrcs.add(src);
        }
        DevRelayConfigGenerator.generateRelayConfig(schemaRegistryLocation, dbName, uri, outputDir, addSrcs, this._manager);
    }

    private void buildRelayConfigs() throws Exception {
        String uri;
        HashSet<String> changeSrcChoices;
        String changeSrcQuestion;
        String changeSrc;
        boolean doGenerateRelayConfigs = this.promptForYesOrNoQuestion("Do you want to generate relay configs for the relay running locally");
        if (!doGenerateRelayConfigs) {
            return;
        }
        String location = DEFAULT_RELAY_CONFIG_LOCATION;
        boolean override = this.promptForYesOrNoQuestion("Relay Configs will be created in :" + location + ". This is the default location read by dev relay. If you need to change this, make sure the relay config is also updated for dev. Do you want to override ");
        if (override) {
            location = this.promptMultiChoiceQuestion("Please specify the directory for creating the relay configs ", new DirChecker());
        } else {
            File f = new File(location);
            while (!f.exists() || !f.isDirectory()) {
                System.out.println("The location (" + location + ") does not exist or is not a directory !! Please create the directory (" + location + ") and press <enter>");
                this._reader.readLine();
            }
        }
        String changeSrcConfirmQn = " Databus Relay's change-capture mechanism for a source can either be trigger-based or through Golden-Gate trail files (gg). Do you know the source's change-capture type ";
        boolean isUserAwareOfCCType = this.promptForYesOrNoQuestion(changeSrcConfirmQn);
        if (!isUserAwareOfCCType) {
            System.out.println("If this source is part of Multi-Colo Cache invalidation use-case, please look at the type column at  https://iwww.corp.linkedin.com/wiki/cf/display/ENGS/Databus+GoldenGate+Client+Launches. Otherwise, if you are not sure, please email @ask-databus");
            if (!this.promptForYesOrNoQuestion("Have you figured out the change-capture type ")) {
                System.out.println(" Please run this script again after you found out the change capture type.  Exiting without generating the configs !!");
                this.currentState = State.EXIT;
                return;
            }
        }
        if ((changeSrc = this.promptMultiChoiceQuestion(changeSrcQuestion = "Does the relay going to capture changes from Oracle (ora) or through golden-gate trail files (gg)?", new MultipleChoiceChecker(changeSrcChoices = new HashSet<String>(Arrays.asList("ora", "gg"))))).equals("ora")) {
            System.out.println("Using Oracle as change stream source.");
            String defaultUri = "jdbc:oracle:thin:" + this._userName + "/" + this._password + "@devdb:1521:DB";
            override = this.promptForYesOrNoQuestion("Using Uri (" + defaultUri + "). Do you want to override ?");
            uri = defaultUri;
            if (override) {
                String msg = "Enter the new DB URI :";
                uri = this.promptMultiChoiceQuestion(msg, new DbUriChecker());
            }
        } else {
            System.out.println("Please follow steps in \"go/databus2-gg -> Client Launch Workflow -> Testing In Dev\" to install and setup Oracle VM with GG");
            System.out.println("Please run the command (ssh oracle@devdb \"cd app/oracle/product/goldengate/dirprm/ && grep -l \\\"SHORTLINKS\\\" dbext*\" | sed -e 's/dbext//' -e 's/.prm//' to get GoldenGate extract process number !! Press <enter> to continue");
            this._reader.readLine();
            System.out.println("If you cannot get the extract process number, please contact @ask-databus !! Press <enter> to continue");
            this._reader.readLine();
            String extract = this.promptMultiChoiceQuestion("Please enter the extract number", new MultipleChoiceChecker(new HashSet<String>(Arrays.asList("1", "2", "3", "4"))));
            uri = "gg:///mnt/gg/extract/dbext" + extract + ":x" + extract;
        }
        this.generateRelayConfig(this._schemaRegistryLocation, this._schemaName, uri, location);
    }

    public static void main(String[] args) throws Exception {
        InteractiveSchemaGenerator gen = new InteractiveSchemaGenerator();
        gen.run();
    }

    public static class MultipleChoiceChecker
    implements UserInputChecker {
        private final Set<String> _choicesInLowerCase;

        public MultipleChoiceChecker(Set<String> choicesInLowerCase) {
            this._choicesInLowerCase = choicesInLowerCase;
        }

        @Override
        public boolean isValidInput(String inputStr) {
            if (!this._choicesInLowerCase.contains(inputStr.trim().toLowerCase(Locale.ENGLISH))) {
                System.out.println("Invalid Input. Should be one of :" + this._choicesInLowerCase + ", Please re-enter :");
                return false;
            }
            return true;
        }
    }

    private static class DirChecker
    implements UserInputChecker {
        private DirChecker() {
        }

        @Override
        public boolean isValidInput(String inputStr) {
            File f = new File(inputStr = inputStr.trim());
            if (!f.isDirectory()) {
                System.out.println("Location (" + inputStr + ") does not appear to be a valid directory. Please specify one !!");
                return false;
            }
            return true;
        }
    }

    public class DbUriChecker
    implements UserInputChecker {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isValidInput(String inputStr) {
            inputStr = inputStr.trim();
            Connection conn = null;
            try {
                conn = DriverManager.getConnection(inputStr);
            }
            catch (SQLException sqlEx) {
                String msg = "The DBUrl (" + inputStr + ") does not seem to be a valid URL. Do you still want to use the Url";
                boolean proceed = false;
                try {
                    proceed = InteractiveSchemaGenerator.this.promptForYesOrNoQuestion(msg);
                }
                catch (IOException e) {
                    // empty catch block
                }
                if (!proceed) {
                    boolean bl = false;
                    return bl;
                }
            }
            finally {
                DBHelper.close((Connection)conn);
            }
            return true;
        }
    }

    public static interface UserInputChecker {
        public boolean isValidInput(String var1);
    }

    private static enum State {
        INITIATECONN,
        TABLEINFO,
        SCHEMA_MANIPULATION,
        GENERATE_RELAY_SRC_CONFIGS,
        EXIT;

    }
}

