/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import com.linkedin.databus.core.BaseCli;
import com.linkedin.databus.util.InteractiveSchemaGenerator;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;

public class InteractiveSchemaGeneratorCli
extends BaseCli {
    private static char AUTOMATIC_OPT_CHAR = (char)65;
    private static char DBNAME_OPT_CHAR = (char)98;
    private static char DBURL_OPT_CHAR = (char)68;
    private static char FIELDS_OPT_CHAR = (char)102;
    private static char PK_OPT_CHAR = (char)107;
    private static char PASSWORD_OPT_CHAR = (char)112;
    private static char TABLE_OPT_CHAR = (char)116;
    private static char USER_OPT_CHAR = (char)117;
    private static char SCHEMA_REGISTRY_PATH_OPT_CHAR = (char)83;
    private static char NUMBEROVERRIDE_OPT_CHAR = (char)78;
    private static String AUTOMATIC_OPT_NAME = "automatic";
    private static String DBNAME_OPT_NAME = "database";
    private static String DBURL_OPT_NAME = "dburl";
    private static String FIELDS_OPT_NAME = "fields";
    private static String PASSWORD_OPT_NAME = "password";
    private static String PK_OPT_NAME = "pk";
    private static String TABLE_OPT_NAME = "table";
    private static String USER_OPT_NAME = "username";
    private static String SCHEMA_REGISTRY_PATH_OPT_NAME = "schema_reg_path";
    private static String NUMBEROVERRIDE_OPT_NAME = "number_override_map";
    private boolean _automatic = Boolean.FALSE;
    private String _dbName;
    private String _dburl = "jdbc:oracle:thin:@devdb:1521:db";
    private List<String> _fields;
    private String _password;
    private List<String> _primaryKeys;
    private String _schemaRegPath = "/export/content/data/databus2_events";
    private String _table;
    private String _user;
    private HashMap<String, String> _dbFieldToAvroDataType;

    public InteractiveSchemaGeneratorCli() {
        super(InteractiveSchemaGeneratorCli.createDefaultUsageString(InteractiveSchemaGenerator.class), null);
    }

    protected void constructCommandLineOptions() {
        super.constructCommandLineOptions();
        OptionBuilder.withLongOpt((String)AUTOMATIC_OPT_NAME);
        OptionBuilder.withDescription((String)"Answer all questions proved through cli automatically and interactive for the rest of the options.");
        Option automaticOption = OptionBuilder.create((char)AUTOMATIC_OPT_CHAR);
        OptionBuilder.withLongOpt((String)DBNAME_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"db_name");
        OptionBuilder.withDescription((String)"The name of database");
        Option dbnameOption = OptionBuilder.create((char)DBNAME_OPT_CHAR);
        OptionBuilder.withLongOpt((String)DBURL_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withDescription((String)"DB URL to read view/table definitions");
        Option dburlOption = OptionBuilder.create((char)DBURL_OPT_CHAR);
        OptionBuilder.withLongOpt((String)FIELDS_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"fields");
        OptionBuilder.withDescription((String)"Comma-separated list of table/view fields to include in the schema");
        Option fieldsOption = OptionBuilder.create((char)FIELDS_OPT_CHAR);
        OptionBuilder.withLongOpt((String)PASSWORD_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"password");
        OptionBuilder.withDescription((String)"DB password");
        Option passwordOption = OptionBuilder.create((char)PASSWORD_OPT_CHAR);
        OptionBuilder.withLongOpt((String)PK_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"keys");
        OptionBuilder.withDescription((String)"Comma-separated list of primary keys of view/table");
        Option pkOption = OptionBuilder.create((char)PK_OPT_CHAR);
        OptionBuilder.withLongOpt((String)TABLE_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"table_name");
        OptionBuilder.withDescription((String)"The name of the table/view whose schema to generate ");
        Option tableOption = OptionBuilder.create((char)TABLE_OPT_CHAR);
        OptionBuilder.withLongOpt((String)USER_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"user");
        OptionBuilder.withDescription((String)"DB username");
        Option userOption = OptionBuilder.create((char)USER_OPT_CHAR);
        OptionBuilder.withLongOpt((String)SCHEMA_REGISTRY_PATH_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"The path where to checkout the schema registry");
        Option schemaRegPathOption = OptionBuilder.create((char)SCHEMA_REGISTRY_PATH_OPT_CHAR);
        OptionBuilder.withLongOpt((String)NUMBEROVERRIDE_OPT_NAME);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"path");
        OptionBuilder.withDescription((String)"Override number fields datatype with FLOAT, LONG, INTEGER, DOUBLE. Input as, DB_FIELD_NAME1=FLOAT,DB_FIELD_NAME2=DOUBLE");
        Option numberOverrideOption = OptionBuilder.create((char)NUMBEROVERRIDE_OPT_CHAR);
        this._cliOptions.addOption(automaticOption);
        this._cliOptions.addOption(dbnameOption);
        this._cliOptions.addOption(dburlOption);
        this._cliOptions.addOption(fieldsOption);
        this._cliOptions.addOption(passwordOption);
        this._cliOptions.addOption(pkOption);
        this._cliOptions.addOption(tableOption);
        this._cliOptions.addOption(userOption);
        this._cliOptions.addOption(schemaRegPathOption);
        this._cliOptions.addOption(numberOverrideOption);
    }

    public boolean processCommandLineArgs(String[] cliArgs) {
        boolean success = super.processCommandLineArgs(cliArgs);
        if (!success) {
            return false;
        }
        this._automatic = this._cmd.hasOption(AUTOMATIC_OPT_CHAR);
        if (this._cmd.hasOption(DBNAME_OPT_CHAR)) {
            this._dbName = this._cmd.getOptionValue(DBNAME_OPT_CHAR).trim();
        }
        if (this._cmd.hasOption(DBURL_OPT_CHAR)) {
            this._dburl = this._cmd.getOptionValue(DBURL_OPT_CHAR).trim();
        }
        if (this._cmd.hasOption(FIELDS_OPT_CHAR)) {
            String fieldsStr = this._cmd.getOptionValue(FIELDS_OPT_CHAR).trim();
            String[] fields = fieldsStr.split("[, ]+");
            this._fields = Collections.unmodifiableList(Arrays.asList(fields));
        }
        if (this._cmd.hasOption(PASSWORD_OPT_CHAR)) {
            this._password = this._cmd.getOptionValue(PASSWORD_OPT_CHAR);
        }
        if (this._cmd.hasOption(PK_OPT_CHAR)) {
            String pkStr = this._cmd.getOptionValue(PK_OPT_CHAR).trim();
            String[] pks = pkStr.split("[, ]+");
            this._primaryKeys = Collections.unmodifiableList(Arrays.asList(pks));
        }
        if (this._cmd.hasOption(TABLE_OPT_CHAR)) {
            this._table = this._cmd.getOptionValue(TABLE_OPT_CHAR).trim();
        }
        if (this._cmd.hasOption(USER_OPT_CHAR)) {
            this._user = this._cmd.getOptionValue(USER_OPT_CHAR).trim();
        }
        if (this._cmd.hasOption(SCHEMA_REGISTRY_PATH_OPT_CHAR)) {
            this._schemaRegPath = this._cmd.getOptionValue(SCHEMA_REGISTRY_PATH_OPT_CHAR).trim();
        }
        if (this._cmd.hasOption(NUMBEROVERRIDE_OPT_CHAR)) {
            String[] mapElements;
            this._dbFieldToAvroDataType = new HashMap();
            String mapList = this._cmd.getOptionValue(NUMBEROVERRIDE_OPT_CHAR).trim();
            for (String mapElement : mapElements = mapList.split(",")) {
                String[] dbFieldToDatatype = mapElement.split("=");
                this._dbFieldToAvroDataType.put(dbFieldToDatatype[0].trim(), dbFieldToDatatype[1].trim());
            }
        }
        return true;
    }

    public static void main(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            System.out.println("Arg[" + i + "] = " + args[i]);
        }
        InteractiveSchemaGeneratorCli cli = new InteractiveSchemaGeneratorCli();
        String[] finalArgs = args.length > 1 && args[0].equals("-c") ? args[1].split("\\s") : args;
        if (!cli.processCommandLineArgs(finalArgs)) {
            return;
        }
        try {
            System.out.println("Starting the schema generation with cli options: " + cli.toString());
            InteractiveSchemaGenerator automaticSchemaGeneration = new InteractiveSchemaGenerator(cli);
            automaticSchemaGeneration.runSchemaGenTool();
        }
        catch (Exception e) {
            System.out.println("Error running the schema generation tool");
            e.printStackTrace();
        }
    }

    public String getSchemaRegistryPath() {
        return this._schemaRegPath;
    }

    public boolean isAutomatic() {
        return this._automatic;
    }

    public String getDburl() {
        return this._dburl;
    }

    public String getUser() {
        return this._user;
    }

    public String getPassword() {
        return this._password;
    }

    public String getDbName() {
        return this._dbName;
    }

    public String getTableName() {
        return this._table;
    }

    public List<String> getPrimaryKeys() {
        return this._primaryKeys;
    }

    public List<String> getFields() {
        return this._fields;
    }

    public String toString() {
        return "InteractiveSchemaGeneratorCli{_automatic=" + this._automatic + ", _dbName='" + this._dbName + '\'' + ", _dburl='" + this._dburl + '\'' + ", _fields=" + this._fields + ", _password='" + this._password + '\'' + ", _primaryKeys=" + this._primaryKeys + ", _schemaRegPath='" + this._schemaRegPath + '\'' + ", _table='" + this._table + '\'' + ", _user='" + this._user + '\'' + ", _dbFieldToAvroDataType=" + this._dbFieldToAvroDataType + '}';
    }

    public HashMap<String, String> getDbFieldToAvroDataType() {
        return this._dbFieldToAvroDataType;
    }
}

