/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import com.linkedin.databus.util.CommandLineHelper;
import com.linkedin.databus.util.FieldToAvro;
import com.linkedin.databus.util.SchemaUtils;
import com.linkedin.databus.util.TableTypeInfo;
import com.linkedin.databus.util.TypeInfoFactory;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import org.apache.avro.specific.SpecificCompiler;

@Deprecated
public class SchemaGeneratorMain {
    private static final String[] DEFAULT_JDBC_DRIVERS = new String[]{"oracle.jdbc.driver.OracleDriver"};
    private static final String DEFAULT_DATABASE = "jdbc:oracle:thin:@devdb:1521:devdb";
    private static final String DEFAULT_USERNAME = "system";
    private static final String DEFAULT_PASSWORD = "manager";
    private final String _database;
    private final String _userName;
    private final String _password;
    private final String _viewName;
    private final String _recordName;
    private final String _namespace;
    private final File _javaOutDir;
    private final File _avroOutDir;
    private final boolean _verbose;
    private final String _driver;
    private final int _avroOutVersion;
    private String _primaryKey;

    public static void main(String[] args) throws Exception {
        CommandLineHelper commandLineParser = new CommandLineHelper();
        commandLineParser.addArgument("database", false, "Database JDBC connection string (e.g. jdbc:oracle:thin:@devdb:1521:db).", CommandLineHelper.ArgumentType.STRING);
        commandLineParser.addArgument("userName", false, "User name used to connect to the database.", CommandLineHelper.ArgumentType.STRING);
        commandLineParser.addArgument("password", false, "Password used to connect to the database.", CommandLineHelper.ArgumentType.STRING);
        commandLineParser.addArgument("viewName", true, "Name of the databus view for which to generate a schema..", CommandLineHelper.ArgumentType.STRING);
        commandLineParser.addArgument("recordName", true, "Record name for the generated schema (will be the Java class name of the compiled schema).", CommandLineHelper.ArgumentType.STRING);
        commandLineParser.addArgument("namespace", true, "Namespace for the generated schema (will be the Java package of the compiled schema).", CommandLineHelper.ArgumentType.STRING);
        commandLineParser.addArgument("javaOutDir", false, "Directory for generated Java source files (if absent, the files will not be generated).", CommandLineHelper.ArgumentType.DIRECTORY);
        commandLineParser.addArgument("avroOutDir", false, "Directory for generated .avsc files (if absent, the files will not be generated).", CommandLineHelper.ArgumentType.DIRECTORY);
        commandLineParser.addArgument("avroOutVersion", false, "Schema version for the avro output file (required if avroOutDir is specified).", CommandLineHelper.ArgumentType.INTEGER);
        commandLineParser.addArgument("primaryKey", false, "Primary key name).", CommandLineHelper.ArgumentType.STRING);
        commandLineParser.addArgument("verbose", false, "true to enable verbose output.", CommandLineHelper.ArgumentType.BOOLEAN);
        commandLineParser.addArgument("driver", false, "JDBC driver (if absent, defaults to oracle.jdbc.driver.OracleDriver).", CommandLineHelper.ArgumentType.STRING);
        Map<String, Object> parsedArgs = commandLineParser.parseCommandLine(args);
        if (parsedArgs == null) {
            return;
        }
        if (parsedArgs.containsKey("avroOutDir") && !parsedArgs.containsKey("avroOutVersion")) {
            commandLineParser.showUsage("Bad command line. avroOutDir requires avroOutVersion to be specified as well.");
            return;
        }
        String database = null != parsedArgs.get("database") ? (String)parsedArgs.get("database") : DEFAULT_DATABASE;
        String username = null != parsedArgs.get("userName") ? (String)parsedArgs.get("userName") : DEFAULT_USERNAME;
        String password = null != (String)parsedArgs.get("password") ? (String)parsedArgs.get("password") : DEFAULT_PASSWORD;
        String primaryKey = null != (String)parsedArgs.get("primaryKey") ? (String)parsedArgs.get("primaryKey") : "";
        commandLineParser.showParsedArguments("Processed command line arguments:", parsedArgs);
        SchemaGeneratorMain generator = new SchemaGeneratorMain(database, username, password, (String)parsedArgs.get("viewName"), (String)parsedArgs.get("recordName"), (String)parsedArgs.get("namespace"), (File)parsedArgs.get("javaOutDir"), (File)parsedArgs.get("avroOutDir"), (Boolean)parsedArgs.get("verbose"), (String)parsedArgs.get("driver"), (Integer)parsedArgs.get("avroOutVersion"), primaryKey);
        generator.loadJdbcDrivers();
        generator.generateSchema();
        System.out.println("Done.");
    }

    public SchemaGeneratorMain(String database, String userName, String password, String viewName, String recordName, String namespace, File javaOutDir, File avroOutDir, Boolean verbose, String driver, Integer avroOutVersion, String primaryKey) {
        this._database = database;
        this._userName = userName;
        this._password = password;
        this._viewName = viewName;
        this._recordName = recordName;
        this._namespace = namespace;
        this._javaOutDir = javaOutDir;
        this._avroOutDir = avroOutDir;
        this._verbose = verbose != null && verbose != false;
        this._driver = driver;
        this._avroOutVersion = avroOutVersion != null ? avroOutVersion : 0;
        this._primaryKey = primaryKey;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void loadJdbcDrivers() {
        if (this._driver != null) {
            try {
                if (this._verbose) {
                    System.out.println("Loading JDBC driver: " + this._driver);
                }
                Class.forName(this._driver);
                if (!this._verbose) return;
                System.out.println("JDBC driver loaded successfully.");
                return;
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Could not load JDBC driver: " + this._driver);
                return;
            }
        } else {
            boolean loadedAtLeastOneDriver = false;
            for (int i = 0; i < DEFAULT_JDBC_DRIVERS.length; ++i) {
                String driver = DEFAULT_JDBC_DRIVERS[i];
                try {
                    if (this._verbose) {
                        System.out.println("Loading default JDBC driver: " + driver);
                    }
                    Class.forName(driver);
                    loadedAtLeastOneDriver = true;
                    if (!this._verbose) continue;
                    System.out.println("JDBC driver loaded successfully.");
                    continue;
                }
                catch (ClassNotFoundException ex) {
                    System.out.println("Could not load JDBC driver: " + driver);
                }
            }
            if (loadedAtLeastOneDriver) return;
            System.out.println("Unable to load any of the default JDBC drivers. Please make sure one of the default drivers \nis available in the classpath, or specify a driver with [-driver com.foo.driver]. \nDefault drivers are: " + Arrays.toString(DEFAULT_JDBC_DRIVERS));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSchema() throws IOException {
        Connection con = null;
        try {
            String table;
            String owner;
            con = this.getConnection();
            String[] nameParts = this._viewName.split("\\.");
            if (nameParts.length == 1) {
                owner = this._userName;
                table = nameParts[0];
            } else {
                owner = nameParts[0];
                table = nameParts[1];
            }
            System.out.println("Generating schema for " + this._viewName);
            if (this._avroOutDir == null) {
                System.out.println("Avro schema will not be saved (use -avroOutDir if you want to save it).");
            }
            if (this._javaOutDir == null) {
                System.out.println("Java files will not be generated (use -javaOutDir if you want to generate them).");
            }
            TableTypeInfo ti = (TableTypeInfo)new TypeInfoFactory().getTypeInfo(con, owner, table, 0, 0, this._primaryKey);
            String topRecordAvroName = this._recordName + "_V" + this._avroOutVersion;
            String namespace = this._namespace;
            String topRecordDatabaseName = this._viewName;
            FieldToAvro fa = new FieldToAvro();
            String schema = fa.buildAvroSchema(namespace, topRecordAvroName, topRecordDatabaseName, null, ti);
            System.out.println("Generated Schema:\n" + schema);
            if (this._avroOutDir != null || this._javaOutDir != null) {
                File avroOutFile;
                if (this._avroOutDir != null) {
                    avroOutFile = new File(this._avroOutDir, this._namespace + "." + this._recordName + "." + this._avroOutVersion + ".avsc");
                    System.out.println("Avro schema will be saved in the file: " + avroOutFile.getAbsolutePath());
                } else {
                    avroOutFile = File.createTempFile(this.getClass().getName(), null);
                    avroOutFile.deleteOnExit();
                }
                PrintWriter pw = new PrintWriter(new FileWriter(avroOutFile));
                pw.println(schema);
                pw.flush();
                pw.close();
                if (this._javaOutDir != null) {
                    System.out.println("Generating Java files in the directory: " + this._javaOutDir.getAbsolutePath());
                    SpecificCompiler.compileSchema((File)avroOutFile, (File)this._javaOutDir);
                }
            }
        }
        catch (SQLException ex) {
            System.out.println(ex);
            ex.printStackTrace();
        }
        finally {
            SchemaUtils.close(con);
        }
    }

    public Connection getConnection() throws SQLException {
        try {
            if (this._verbose) {
                System.out.println("Connecting to database: " + this._database);
            }
            Connection con = DriverManager.getConnection(this._database, this._userName, this._password);
            if (this._verbose) {
                System.out.println("Connected successfully.");
            }
            return con;
        }
        catch (SQLException ex) {
            System.out.println("Could not connect to database: " + this._database);
            System.out.println(ex.getMessage());
            if (this._verbose) {
                ex.printStackTrace();
            }
            throw ex;
        }
    }
}

