/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import com.linkedin.databus.core.data_model.LogicalSource;
import com.linkedin.databus.core.util.IdNamePair;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.schemas.SourceIdNameRegistry;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.type.TypeReference;

public class SchemaMetaDataManager {
    private Short _maxSrcId = -1;
    private SourceIdNameRegistry _idNameRegistry = new SourceIdNameRegistry();
    private Map<String, TreeSet<String>> _physicalToLogicalSrcMap = null;
    private final String _idNameMapFile;
    private final String _physicalToLogicalSrcMapFile;
    public static final String SRC_ID_NAME_MAP_FILE = "idToName.map";
    public static final String PHYSICAL_TO_LOGICAL_SRC_MAP_FILE = "physical_logical_src_map.json";

    public SchemaMetaDataManager(String schemaRegistryLocation) throws IOException {
        this._idNameMapFile = schemaRegistryLocation + "/" + SRC_ID_NAME_MAP_FILE;
        this._physicalToLogicalSrcMapFile = schemaRegistryLocation + "/" + PHYSICAL_TO_LOGICAL_SRC_MAP_FILE;
        this.populatePhysicalToLogicalSrcMap();
        this.populateSrcNameIdMap();
    }

    public void store() throws IOException {
        this.persistPhysicalToLogicalSrcMap();
        this.persistSrcNameIdMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populatePhysicalToLogicalSrcMap() throws IOException {
        FileInputStream fStream = null;
        try {
            fStream = new FileInputStream(new File(this._physicalToLogicalSrcMapFile));
            ObjectMapper m = new ObjectMapper();
            this._physicalToLogicalSrcMap = (Map)m.readValue((InputStream)fStream, (TypeReference)new TypeReference<TreeMap<String, TreeSet<String>>>(){});
        }
        finally {
            if (null != fStream) {
                fStream.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistPhysicalToLogicalSrcMap() throws IOException {
        ObjectMapper m = new ObjectMapper();
        String str = m.defaultPrettyPrintingWriter().writeValueAsString(this._physicalToLogicalSrcMap);
        File tmpFile = File.createTempFile("phyToLogicalSrc", ".json.tmp");
        FileWriter oStream = null;
        try {
            oStream = new FileWriter(tmpFile);
            oStream.append(str);
        }
        finally {
            if (null != oStream) {
                oStream.close();
            }
        }
        File destFile = new File(this._physicalToLogicalSrcMapFile);
        boolean success = tmpFile.renameTo(destFile);
        if (!success) {
            throw new RuntimeException("Unable to persist the mapping json file !!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSrcNameIdMap() throws IOException {
        int ln = 0;
        File file = new File(this._idNameMapFile);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
            String line = null;
            ArrayList<IdNamePair> pairCollection = new ArrayList<IdNamePair>();
            HashSet<String> srcNames = new HashSet<String>();
            HashSet<Short> srcIds = new HashSet<Short>();
            while ((line = reader.readLine()) != null) {
                line = line.trim();
                ++ln;
                if (line.startsWith("#")) continue;
                String[] parts = line.split("#");
                String[] toks = (line = parts[0]).split(":");
                if (toks.length != 2) {
                    throw new RuntimeException("SrcIdToName map file (" + file + ") is corrupted at line number :" + ln);
                }
                short srcId = new Short(toks[0]);
                String srcName = toks[1];
                this._maxSrcId = (short)Math.max(this._maxSrcId.shortValue(), srcId);
                if (srcIds.contains(srcId)) {
                    throw new RuntimeException("Duplicate SrcId (" + srcId + ") present in the file :" + this._idNameMapFile);
                }
                if (srcNames.contains(srcName)) {
                    throw new RuntimeException("Duplicate Source name (" + srcName + ") present in the file :" + this._idNameMapFile);
                }
                srcIds.add(srcId);
                srcNames.add(srcName);
                pairCollection.add(new IdNamePair(Long.valueOf(srcId), srcName));
            }
            this._idNameRegistry.updateFromIdNamePairs(pairCollection);
        }
        finally {
            if (null != reader) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void persistSrcNameIdMap() throws IOException {
        File tmpFile = File.createTempFile("srcIdToName", ".map.tmp");
        FileWriter oStream = null;
        try {
            oStream = new FileWriter(tmpFile);
            TreeSet<LogicalSource> srcs = new TreeSet<LogicalSource>(new Comparator<LogicalSource>(){

                @Override
                public int compare(LogicalSource o1, LogicalSource o2) {
                    return o1.getId().compareTo(o2.getId());
                }
            });
            srcs.addAll(this._idNameRegistry.getAllSources());
            for (LogicalSource k : srcs) {
                oStream.append(k.getId().toString());
                oStream.append(":");
                oStream.append(k.getName());
                oStream.append("\n");
            }
        }
        finally {
            if (null != oStream) {
                oStream.close();
            }
        }
        File destFile = new File(this._idNameMapFile);
        boolean success = tmpFile.renameTo(destFile);
        if (!success) {
            throw new RuntimeException("Unable to persist the mapping file !!");
        }
    }

    public short updateAndGetNewSrcId(String dbName, String srcName) throws DatabusException {
        Short s = this._maxSrcId;
        Short s2 = this._maxSrcId = Short.valueOf((short)(this._maxSrcId + 1));
        dbName = dbName.toLowerCase(Locale.ENGLISH);
        if (null != this._idNameRegistry.getSource(srcName)) {
            throw new DatabusException("Source Name (" + srcName + ") already available in the schema registry !!");
        }
        TreeSet<Object> s3 = null;
        if (this._physicalToLogicalSrcMap.containsKey(dbName)) {
            s3 = this._physicalToLogicalSrcMap.get(dbName);
        } else {
            s3 = new TreeSet();
            this._physicalToLogicalSrcMap.put(dbName, s3);
        }
        s3.add(srcName);
        IdNamePair pair = new IdNamePair(Long.valueOf(this._maxSrcId.shortValue()), srcName);
        LogicalSource src = new LogicalSource(pair);
        ArrayList<LogicalSource> newSources = new ArrayList<LogicalSource>();
        newSources.add(src);
        this._idNameRegistry.add(newSources);
        return this._maxSrcId;
    }

    public List<String> getManagedSourcesForDB(String db) {
        Set srcs = this._physicalToLogicalSrcMap.get(db);
        if (null == srcs) {
            return null;
        }
        ArrayList<String> srcNames = new ArrayList<String>(srcs);
        Collections.sort(srcNames, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                Integer srcId1 = SchemaMetaDataManager.this._idNameRegistry.getSourceId(o1);
                Integer srcId2 = SchemaMetaDataManager.this._idNameRegistry.getSourceId(o2);
                return srcId1.compareTo(srcId2);
            }
        });
        return srcNames;
    }

    public short getSrcId(String srcName) {
        LogicalSource src = this._idNameRegistry.getSource(srcName);
        if (src != null) {
            return src.getId().shortValue();
        }
        throw new RuntimeException("Unable to find the source id for the source name (" + srcName + ")");
    }

    public Map<String, TreeSet<String>> getDbToSrcMap() {
        return this._physicalToLogicalSrcMap;
    }
}

