/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import com.linkedin.databus.util.AvroPrimitiveTypes;
import com.linkedin.databus.util.TypeInfo;

public class SimpleTypeInfo
implements TypeInfo {
    private final AvroPrimitiveTypes _type;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public SimpleTypeInfo(String name, int precision, int scale) {
        if (name.equals("NUMBER")) {
            if (scale > 0) {
                if (scale <= 6) {
                    this._type = AvroPrimitiveTypes.FLOAT;
                    return;
                } else {
                    if (scale > 17) throw new RuntimeException("Cannot handle scale of greater than 17");
                    this._type = AvroPrimitiveTypes.DOUBLE;
                }
                return;
            } else {
                this._type = precision > 9 || precision == 0 ? AvroPrimitiveTypes.LONG : AvroPrimitiveTypes.INTEGER;
            }
            return;
        } else {
            if (name.startsWith("SYS.")) {
                name = name.substring(4);
            }
            this._type = AvroPrimitiveTypes.valueOf(name);
        }
    }

    public SimpleTypeInfo(AvroPrimitiveTypes type) {
        this._type = type;
    }

    @Override
    public String getOwnerName() {
        return null;
    }

    @Override
    public String getName() {
        return this._type.toString();
    }

    public String toString() {
        return "SimpleType: " + (Object)((Object)this._type);
    }

    public AvroPrimitiveTypes getPrimitiveType() {
        return this._type;
    }
}

