/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import com.linkedin.databus.util.CollectionTypeInfo;
import com.linkedin.databus.util.FieldInfo;
import com.linkedin.databus.util.SchemaUtils;
import com.linkedin.databus.util.SimpleTypeInfo;
import com.linkedin.databus.util.TableTypeInfo;
import com.linkedin.databus.util.TypeInfo;
import com.linkedin.databus.util.UserTypeInfo;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

@Deprecated
public class TypeInfoFactory {
    public TypeInfo getTypeInfo(Connection con, String typeOwner, String typeName, int precision, int scale, String primaryKey) throws SQLException {
        if (this.isSimpleType(con, typeOwner, typeName)) {
            return this.buildSimpleTypeInfo(con, typeOwner, typeName, precision, scale);
        }
        if (this.isTableType(con, typeOwner, typeName)) {
            return this.buildTableType(con, typeOwner, typeName, primaryKey);
        }
        if (this.isCollectionType(con, typeOwner, typeName)) {
            return this.buildCollectionTypeInfo(con, typeOwner, typeName);
        }
        if (this.isUserType(con, typeOwner, typeName)) {
            return this.buildUserTypeInfo(con, typeOwner, typeName);
        }
        throw new SQLException("Cannot determine type info for the attribute (" + typeOwner + "." + typeName + ").");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableType(Connection con, String tableOwner, String tableName) {
        PreparedStatement stmt = null;
        try {
            String fullTableName = tableOwner + "." + tableName;
            stmt = con.prepareStatement("SELECT * FROM " + fullTableName + " WHERE 0=1");
            stmt.executeQuery();
            boolean bl = true;
            SchemaUtils.close(stmt);
            return bl;
        }
        catch (SQLException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            SchemaUtils.close(stmt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TableTypeInfo buildTableType(Connection con, String tableOwner, String tableName, String pk) throws SQLException {
        TableTypeInfo tableTypeInfo;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String fullTableName = tableOwner + "." + tableName;
            stmt = con.prepareStatement("SELECT * FROM " + fullTableName + " WHERE 0=1");
            rs = stmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
            int numColumns = rsmd.getColumnCount();
            for (int column = 1; column <= numColumns; ++column) {
                String columnTypeName;
                String columnTypeOwner;
                String columnName = rsmd.getColumnName(column);
                System.out.println("Processing column " + tableName + "." + columnName + ":" + rsmd.getColumnTypeName(column));
                int columnPrecision = rsmd.getPrecision(column);
                int columnScale = rsmd.getScale(column);
                String[] columnTypeParts = rsmd.getColumnTypeName(column).split("\\.");
                if (columnTypeParts.length == 1) {
                    columnTypeOwner = null;
                    columnTypeName = columnTypeParts[0];
                } else {
                    columnTypeOwner = columnTypeParts[0];
                    columnTypeName = columnTypeParts[1];
                }
                TypeInfo typeInfo = this.getTypeInfo(con, columnTypeOwner, columnTypeName, columnPrecision, columnScale, "");
                FieldInfo field = new FieldInfo(columnName, typeInfo, column - 1);
                fields.add(field);
            }
            tableTypeInfo = new TableTypeInfo(tableOwner, tableName, fields, pk);
        }
        catch (Throwable throwable) {
            SchemaUtils.close(rs);
            SchemaUtils.close(stmt);
            throw throwable;
        }
        SchemaUtils.close(rs);
        SchemaUtils.close(stmt);
        return tableTypeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserType(Connection con, String ownerName, String typeName) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT 1 FROM ALL_TYPE_ATTRS WHERE OWNER=? AND TYPE_NAME=? AND ROWNUM < 2");
            stmt.setString(1, ownerName);
            stmt.setString(2, typeName);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            SchemaUtils.close(rs);
            SchemaUtils.close(stmt);
            throw throwable;
        }
        SchemaUtils.close(rs);
        SchemaUtils.close(stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTypeInfo buildUserTypeInfo(Connection con, String typeOwner, String typeName) throws SQLException {
        UserTypeInfo userTypeInfo;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT ATTR_NAME, ATTR_TYPE_OWNER, ATTR_TYPE_NAME, PRECISION, SCALE FROM ALL_TYPE_ATTRS WHERE OWNER=? AND TYPE_NAME=?ORDER BY ATTR_NO");
            stmt.setString(1, typeOwner);
            stmt.setString(2, typeName);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Not a user type. (" + typeName + ")");
            }
            ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
            do {
                String attrName = rs.getString(1);
                String attrTypeOwner = rs.getString(2);
                String attrTypeName = rs.getString(3);
                int attrPrecision = rs.getInt(4);
                int attrScale = rs.getInt(5);
                TypeInfo typeInfo = this.getTypeInfo(con, attrTypeOwner, attrTypeName, attrPrecision, attrScale, "");
                fields.add(new FieldInfo(attrName, typeInfo, fields.size()));
            } while (rs.next());
            userTypeInfo = new UserTypeInfo(typeOwner, typeName, fields);
        }
        catch (Throwable throwable) {
            SchemaUtils.close(rs);
            SchemaUtils.close(stmt);
            throw throwable;
        }
        SchemaUtils.close(rs);
        SchemaUtils.close(stmt);
        return userTypeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSimpleType(Connection con, String typeOwner, String typeName) throws SQLException {
        if (typeName.equalsIgnoreCase("NVARCHAR") || typeName.equalsIgnoreCase("NVARCHAR2") || typeName.contains("XML")) {
            return true;
        }
        ResultSet rs = null;
        try {
            rs = con.getMetaData().getTypeInfo();
            while (rs.next()) {
                if (!rs.getString("TYPE_NAME").equalsIgnoreCase(typeName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            SchemaUtils.close(rs);
        }
    }

    public SimpleTypeInfo buildSimpleTypeInfo(Connection con, String typeOwner, String typeName, int precision, int scale) throws SQLException {
        if (!this.isSimpleType(con, typeOwner, typeName)) {
            throw new SQLException("Not a simple type. (" + typeName + ")");
        }
        return new SimpleTypeInfo(typeName, precision, scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCollectionType(Connection con, String ownerName, String typeName) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT 1 FROM ALL_COLL_TYPES WHERE OWNER=? AND TYPE_NAME=? AND ROWNUM < 2");
            stmt.setString(1, ownerName);
            stmt.setString(2, typeName);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            SchemaUtils.close(rs);
            SchemaUtils.close(stmt);
            throw throwable;
        }
        SchemaUtils.close(rs);
        SchemaUtils.close(stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionTypeInfo buildCollectionTypeInfo(Connection con, String ownerName, String typeName) throws SQLException {
        CollectionTypeInfo collectionTypeInfo;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT ELEM_TYPE_OWNER, ELEM_TYPE_NAME, PRECISION, SCALE FROM ALL_COLL_TYPES WHERE OWNER=? AND TYPE_NAME=?");
            stmt.setString(1, ownerName);
            stmt.setString(2, typeName);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Not a collection type. (" + typeName + ")");
            }
            String elementTypeOwner = rs.getString(1);
            String elementTypeName = rs.getString(2);
            int precision = rs.getInt(3);
            int scale = rs.getInt(4);
            TypeInfo elementTypeInfo = this.getTypeInfo(con, elementTypeOwner, elementTypeName, precision, scale, "");
            collectionTypeInfo = new CollectionTypeInfo(ownerName, typeName, elementTypeInfo);
        }
        catch (Throwable throwable) {
            SchemaUtils.close(rs);
            SchemaUtils.close(stmt);
            throw throwable;
        }
        SchemaUtils.close(rs);
        SchemaUtils.close(stmt);
        return collectionTypeInfo;
    }
}

