/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.util;

import com.linkedin.databus.util.CollectionTypeInfo;
import com.linkedin.databus.util.FieldInfo;
import com.linkedin.databus.util.SchemaUtils;
import com.linkedin.databus.util.SimpleTypeInfo;
import com.linkedin.databus.util.TableTypeInfo;
import com.linkedin.databus.util.TypeInfo;
import com.linkedin.databus.util.UserTypeInfo;
import com.linkedin.databus2.core.DatabusException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import jline.ConsoleReader;

public class TypeInfoFactoryInteractive {
    public TypeInfo getTypeInfo(Connection con, String typeOwner, String typeName, int precision, int scale, String primaryKey, ConsoleReader reader, HashMap<String, String> dbFieldToAvroDataType) throws SQLException, IOException, DatabusException {
        if (this.isSimpleType(con, typeOwner, typeName)) {
            return this.buildSimpleTypeInfo(con, typeOwner, typeName, precision, scale);
        }
        if (this.isTableType(con, typeOwner, typeName)) {
            return this.buildTableType(con, typeOwner, typeName, primaryKey, reader, dbFieldToAvroDataType);
        }
        if (this.isCollectionType(con, typeOwner, typeName)) {
            return this.buildCollectionTypeInfo(con, typeOwner, typeName, reader, dbFieldToAvroDataType);
        }
        if (this.isUserType(con, typeOwner, typeName)) {
            return this.buildUserTypeInfo(con, typeOwner, typeName, reader, dbFieldToAvroDataType);
        }
        throw new SQLException("Cannot determine type info for the attribute (" + typeOwner + "." + typeName + ").");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isTableType(Connection con, String tableOwner, String tableName) {
        PreparedStatement stmt = null;
        try {
            String fullTableName = tableOwner + "." + tableName;
            stmt = con.prepareStatement("SELECT * FROM " + fullTableName + " WHERE 0=1");
            stmt.executeQuery();
            boolean bl = true;
            SchemaUtils.close(stmt);
            return bl;
        }
        catch (SQLException ex) {
            boolean bl = false;
            return bl;
        }
        finally {
            SchemaUtils.close(stmt);
        }
    }

    public TableTypeInfo buildTableType(Connection con, String tableOwner, String tableName, String pk, ConsoleReader reader, HashMap<String, String> dbFieldToAvroDataType) throws SQLException, IOException, DatabusException {
        TableTypeInfo tableTypeInfo;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            String fullTableName = tableOwner + "." + tableName;
            stmt = con.prepareStatement("SELECT * FROM " + fullTableName + " WHERE 0=1");
            rs = stmt.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
            int numColumns = rsmd.getColumnCount();
            for (int column = 1; column <= numColumns; ++column) {
                String columnTypeName;
                String columnTypeOwner;
                int columnScale;
                int columnPrecision;
                String columnName;
                block17: {
                    columnName = rsmd.getColumnName(column);
                    System.out.println("Processing column " + tableName + "." + columnName + ":" + rsmd.getColumnTypeName(column));
                    columnPrecision = rsmd.getPrecision(column);
                    columnScale = rsmd.getScale(column);
                    String[] columnTypeParts = rsmd.getColumnTypeName(column).split("\\.");
                    if (columnTypeParts.length == 1) {
                        columnTypeOwner = null;
                        columnTypeName = columnTypeParts[0];
                    } else {
                        columnTypeOwner = columnTypeParts[0];
                        columnTypeName = columnTypeParts[1];
                    }
                    if (columnTypeName.equals("NUMBER")) {
                        System.out.println("If you are not sure about the following question, please talk with your DBA or the database owner");
                        System.out.println("The following datatypes will be used by the avro generator: ");
                        System.out.println("If scale <= 6                                     ===> FLOAT (Irrespective of the precision)");
                        System.out.println("If scale <= 17                                    ===> DOUBLE (Irrespective of the precision)");
                        System.out.println("If (precision > 9 or precision = 0) and scale = 0 ===> LONG ");
                        System.out.println("If precision <= 9 and scale = 0                   ===> INTEGER");
                        SimpleTypeInfo typeInfoValidate = new SimpleTypeInfo(columnTypeName, columnPrecision, columnScale);
                        if (columnPrecision == 0 && columnScale == 0) {
                            System.out.println("Unable to determine the scale and precision for this column, please manually verify the the scale/precision in the oracle table ALL_TAB_COLUMNS");
                        }
                        System.out.println("The precision [" + columnPrecision + "] and scale [" + columnScale + "] will be used for the field " + columnName + " which has oracle datatype " + columnTypeName + " and the avro datatype " + (Object)((Object)typeInfoValidate.getPrimitiveType()) + " will be used. (yes - to use the printed values, no - to override the datatype with user input): ");
                        if (dbFieldToAvroDataType == null) {
                            String line = this.checkAndRead(reader);
                            while (true) {
                                if (line.equals("yes")) {
                                    System.out.println("Using the precision [" + columnPrecision + "] and scale [" + columnScale + "]");
                                    break block17;
                                }
                                if (line.equals("no")) {
                                    System.out.println("Overriding the avro datatype..");
                                    System.out.println("Please enter the avro datatype you would like to use [FLOAT,DOUBLE,LONG,INTEGER]: ");
                                    String datatype = this.checkAndRead(reader);
                                    try {
                                        ScalePrecision scalePrecision = this.getScaleAndPrecision(datatype);
                                        columnPrecision = scalePrecision.getPrecision();
                                        columnScale = scalePrecision.getScale();
                                    }
                                    catch (DatabusException e) {
                                        continue;
                                    }
                                    typeInfoValidate = new SimpleTypeInfo(columnTypeName, columnPrecision, columnScale);
                                    System.out.println("Based on your input, the avro datatype " + (Object)((Object)typeInfoValidate.getPrimitiveType()) + " will be used for the field " + columnName);
                                    break block17;
                                }
                                System.out.println("Invalid input, say 'yes' or 'no'");
                                line = this.checkAndRead(reader);
                            }
                        }
                        if (dbFieldToAvroDataType.containsKey(columnName.trim())) {
                            String avroDataType = dbFieldToAvroDataType.get(columnName.trim());
                            ScalePrecision scalePrecision = this.getScaleAndPrecision(dbFieldToAvroDataType.get(columnName.trim()));
                            System.out.println("Using avro data type [" + avroDataType + "] for the column [" + columnName + "]");
                            columnPrecision = scalePrecision.getPrecision();
                            columnScale = scalePrecision.getScale();
                        } else {
                            System.out.println("The override for the column [" + columnName + "] is not present, this is expected from the user input in cli");
                            throw new DatabusException("Number override not present");
                        }
                    }
                }
                TypeInfo typeInfo = this.getTypeInfo(con, columnTypeOwner, columnTypeName, columnPrecision, columnScale, "", reader, dbFieldToAvroDataType);
                FieldInfo field = new FieldInfo(columnName, typeInfo, column - 1);
                fields.add(field);
            }
            tableTypeInfo = new TableTypeInfo(tableOwner, tableName, fields, pk);
        }
        catch (IOException e) {
            try {
                System.out.println("Unable to process user input, please try again.");
                e.printStackTrace();
                throw e;
            }
            catch (Throwable throwable) {
                SchemaUtils.close(rs);
                SchemaUtils.close(stmt);
                throw throwable;
            }
        }
        SchemaUtils.close(rs);
        SchemaUtils.close(stmt);
        return tableTypeInfo;
    }

    private ScalePrecision getScaleAndPrecision(String dataType) throws DatabusException {
        if ((dataType = dataType.trim()).equalsIgnoreCase("FLOAT")) {
            return new ScalePrecision(5, 0);
        }
        if (dataType.equalsIgnoreCase("DOUBLE")) {
            return new ScalePrecision(16, 0);
        }
        if (dataType.equalsIgnoreCase("LONG")) {
            return new ScalePrecision(0, 10);
        }
        if (dataType.equalsIgnoreCase("INTEGER")) {
            return new ScalePrecision(0, 8);
        }
        throw new DatabusException("Unknown datatype, valid datatypes/input are FLOAT/DOUBLE/LONG/INTEGER, please retry.");
    }

    private String checkAndRead(ConsoleReader reader) throws IOException {
        String line = reader.readLine();
        if (line == null) {
            System.out.println("Please enter a valid input");
            return null;
        }
        return line.trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUserType(Connection con, String ownerName, String typeName) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT 1 FROM ALL_TYPE_ATTRS WHERE OWNER=? AND TYPE_NAME=? AND ROWNUM < 2");
            stmt.setString(1, ownerName);
            stmt.setString(2, typeName);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            SchemaUtils.close(rs);
            SchemaUtils.close(stmt);
            throw throwable;
        }
        SchemaUtils.close(rs);
        SchemaUtils.close(stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserTypeInfo buildUserTypeInfo(Connection con, String typeOwner, String typeName, ConsoleReader reader, HashMap<String, String> dbFieldToAvroDataType) throws SQLException, IOException, DatabusException {
        UserTypeInfo userTypeInfo;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT ATTR_NAME, ATTR_TYPE_OWNER, ATTR_TYPE_NAME, PRECISION, SCALE FROM ALL_TYPE_ATTRS WHERE OWNER=? AND TYPE_NAME=?ORDER BY ATTR_NO");
            stmt.setString(1, typeOwner);
            stmt.setString(2, typeName);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Not a user type. (" + typeName + ")");
            }
            ArrayList<FieldInfo> fields = new ArrayList<FieldInfo>();
            do {
                String attrName = rs.getString(1);
                String attrTypeOwner = rs.getString(2);
                String attrTypeName = rs.getString(3);
                int attrPrecision = rs.getInt(4);
                int attrScale = rs.getInt(5);
                TypeInfo typeInfo = this.getTypeInfo(con, attrTypeOwner, attrTypeName, attrPrecision, attrScale, "", reader, dbFieldToAvroDataType);
                fields.add(new FieldInfo(attrName, typeInfo, fields.size()));
            } while (rs.next());
            userTypeInfo = new UserTypeInfo(typeOwner, typeName, fields);
        }
        catch (Throwable throwable) {
            SchemaUtils.close(rs);
            SchemaUtils.close(stmt);
            throw throwable;
        }
        SchemaUtils.close(rs);
        SchemaUtils.close(stmt);
        return userTypeInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSimpleType(Connection con, String typeOwner, String typeName) throws SQLException {
        if (typeName.equalsIgnoreCase("NVARCHAR") || typeName.equalsIgnoreCase("NVARCHAR2") || typeName.contains("XML")) {
            return true;
        }
        ResultSet rs = null;
        try {
            rs = con.getMetaData().getTypeInfo();
            while (rs.next()) {
                if (!rs.getString("TYPE_NAME").equalsIgnoreCase(typeName)) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            SchemaUtils.close(rs);
        }
    }

    public SimpleTypeInfo buildSimpleTypeInfo(Connection con, String typeOwner, String typeName, int precision, int scale) throws SQLException {
        if (!this.isSimpleType(con, typeOwner, typeName)) {
            throw new SQLException("Not a simple type. (" + typeName + ")");
        }
        return new SimpleTypeInfo(typeName, precision, scale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCollectionType(Connection con, String ownerName, String typeName) throws SQLException {
        boolean bl;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT 1 FROM ALL_COLL_TYPES WHERE OWNER=? AND TYPE_NAME=? AND ROWNUM < 2");
            stmt.setString(1, ownerName);
            stmt.setString(2, typeName);
            rs = stmt.executeQuery();
            bl = rs.next();
        }
        catch (Throwable throwable) {
            SchemaUtils.close(rs);
            SchemaUtils.close(stmt);
            throw throwable;
        }
        SchemaUtils.close(rs);
        SchemaUtils.close(stmt);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CollectionTypeInfo buildCollectionTypeInfo(Connection con, String ownerName, String typeName, ConsoleReader reader, HashMap<String, String> dbFieldToAvroDataType) throws SQLException, IOException, DatabusException {
        CollectionTypeInfo collectionTypeInfo;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        try {
            stmt = con.prepareStatement("SELECT ELEM_TYPE_OWNER, ELEM_TYPE_NAME, PRECISION, SCALE FROM ALL_COLL_TYPES WHERE OWNER=? AND TYPE_NAME=?");
            stmt.setString(1, ownerName);
            stmt.setString(2, typeName);
            rs = stmt.executeQuery();
            if (!rs.next()) {
                throw new SQLException("Not a collection type. (" + typeName + ")");
            }
            String elementTypeOwner = rs.getString(1);
            String elementTypeName = rs.getString(2);
            int precision = rs.getInt(3);
            int scale = rs.getInt(4);
            TypeInfo elementTypeInfo = this.getTypeInfo(con, elementTypeOwner, elementTypeName, precision, scale, "", reader, dbFieldToAvroDataType);
            collectionTypeInfo = new CollectionTypeInfo(ownerName, typeName, elementTypeInfo);
        }
        catch (Throwable throwable) {
            SchemaUtils.close(rs);
            SchemaUtils.close(stmt);
            throw throwable;
        }
        SchemaUtils.close(rs);
        SchemaUtils.close(stmt);
        return collectionTypeInfo;
    }

    private static class ScalePrecision {
        private int scale;
        private int precision;

        private int getScale() {
            return this.scale;
        }

        private int getPrecision() {
            return this.precision;
        }

        private ScalePrecision(int scale, int precision) {
            this.scale = scale;
            this.precision = precision;
        }
    }
}

