/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.client.util;

import com.linkedin.databus.client.DatabusHttpClientImpl;
import com.linkedin.databus.client.pub.FileSystemCheckpointPersistenceProvider;
import com.linkedin.databus.core.BootstrapCheckpointHandler;
import com.linkedin.databus.core.Checkpoint;
import com.linkedin.databus.core.DatabusRuntimeException;
import com.linkedin.databus.core.DbusClientMode;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;

public class CheckpointSerializerMain {
    public static final String MODULE = CheckpointSerializerMain.class.getSimpleName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String HELP_OPT_NAME = "help";
    public static final String HELP_OPT_DESCR = "prints this help screen";
    public static final String ACTION_OPT_NAME = "action";
    public static final String ACTION_OPT_DESCR = "action to run: PRINT, CHANGE, DELETE";
    public static final String CLIENT_PROPS_FILE_OPT_NAME = "client_props";
    public static final String CLIENT_PROPS_FILE_OPT_DESCR = "specifies a client configuration properties file";
    public static final String CP3_PROPS_FILE_OPT_NAME = "cp3_props";
    public static final String CP3_PROPS_FILE_OPT_DESCR = "specifies a checkpoint persistence provider (CP3) configuration properties file ";
    public static final String PROPS_PREFIX_OPT_NAME = "props_prefix";
    public static final String PROPS_PREFIX_OPT_DESCR = "properties name prefix for the configuration file (client or CP3)";
    public static final String SOURCES_OPT_NAME = "sources";
    public static final String SOURCES_OPT_DESCR = "comma-separated source list for the checkpoint; -1 for flexible checkpoint";
    public static final String SCN_OPT_NAME = "sequence_num";
    public static final String SCN_OPT_DESCR = "new scn for the checkpoint to be saved";
    public static final String TYPE_OPT_NAME = "type";
    public static final String TYPE_OPT_DESCR = "the type of the checkpoint to be saved: BOOTSTRAP_SNAPSHOT, BOOTSTRAP_CATCHUP, ONLINE_CONSUMPTION";
    public static final String SINCE_SCN_OPT_NAME = "since_sequence_num";
    public static final String SINCE_SCN_OPT_DESCR = "sequence number for when the bootstrap started (snapshot and catchup)";
    public static final String START_SCN_OPT_NAME = "start_sequence_num";
    public static final String START_SCN_OPT_DESCR = "start sequence number for bootstrap checkpoints (snapshot and catchup)";
    public static final String TARGET_SCN_OPT_NAME = "target_sequence_num";
    public static final String TARGET_SCN_OPT_DESCR = "target sequence number for bootstrap checkpoints (catchup only)";
    public static final String BOOTSTRAP_SOURCE_OPT_NAME = "bootstrap_source";
    public static final String BOOTSTRAP_SOURCE_OPT_DESCR = "the current bootstrap source name";
    public static final char ACTION_OPT_CHAR = 'a';
    public static final char BOOTSTRAP_SOURCE_OPT_CHAR = 'b';
    public static final char CLIENT_PROPS_FILE_OPT_CHAR = 'c';
    public static final char CP3_PROPS_FILE_OPT_CHAR = 'C';
    public static final char PROPS_PREFIX_OPT_CHAR = 'f';
    public static final char HELP_OPT_CHAR = 'h';
    public static final char SOURCES_OPT_CHAR = 'S';
    public static final char SCN_OPT_CHAR = 's';
    public static final char TYPE_OPT_CHAR = 't';
    public static final char SINCE_SCN_OPT_CHAR = 'x';
    public static final char START_SCN_OPT_CHAR = 'y';
    public static final char TARGET_SCN_OPT_CHAR = 'z';
    private static Action _action;
    private static String[] _sources;
    private static Properties _clientProps;
    private static Properties _cp3Props;
    private static String _propPrefix;
    private static Long _scn;
    private static Long _sinceScn;
    private static Long _startScn;
    private static Long _targetScn;
    private static DbusClientMode _cpType;
    private static String _bootstrapSource;

    private static Options createOptions() {
        OptionBuilder.withLongOpt((String)HELP_OPT_NAME);
        OptionBuilder.withDescription((String)HELP_OPT_DESCR);
        Option helpOption = OptionBuilder.create((char)'h');
        OptionBuilder.withLongOpt((String)CLIENT_PROPS_FILE_OPT_NAME);
        OptionBuilder.withDescription((String)CLIENT_PROPS_FILE_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"properties_file");
        Option clientPropsOption = OptionBuilder.create((char)'c');
        OptionBuilder.withLongOpt((String)CP3_PROPS_FILE_OPT_NAME);
        OptionBuilder.withDescription((String)CP3_PROPS_FILE_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"properties_file");
        Option cp3PropsOption = OptionBuilder.create((char)'C');
        OptionBuilder.withLongOpt((String)PROPS_PREFIX_OPT_NAME);
        OptionBuilder.withDescription((String)PROPS_PREFIX_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"prefix_string");
        Option propsPrefixOption = OptionBuilder.create((char)'f');
        OptionBuilder.withLongOpt((String)SOURCES_OPT_NAME);
        OptionBuilder.withDescription((String)SOURCES_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"sources_list");
        Option sourcesOption = OptionBuilder.create((char)'S');
        OptionBuilder.withLongOpt((String)SCN_OPT_NAME);
        OptionBuilder.withDescription((String)SCN_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"sequence_number");
        Option scnOptOption = OptionBuilder.create((char)'s');
        OptionBuilder.withLongOpt((String)ACTION_OPT_NAME);
        OptionBuilder.withDescription((String)ACTION_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)ACTION_OPT_NAME);
        Option actionOption = OptionBuilder.create((char)'a');
        OptionBuilder.withLongOpt((String)SINCE_SCN_OPT_NAME);
        OptionBuilder.withDescription((String)SINCE_SCN_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"sequence_number");
        Option sinceScnOptOption = OptionBuilder.create((char)'x');
        OptionBuilder.withLongOpt((String)START_SCN_OPT_NAME);
        OptionBuilder.withDescription((String)START_SCN_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"sequence_number");
        Option startScnOptOption = OptionBuilder.create((char)'y');
        OptionBuilder.withLongOpt((String)TARGET_SCN_OPT_NAME);
        OptionBuilder.withDescription((String)TARGET_SCN_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"sequence_number");
        Option targetScnOptOption = OptionBuilder.create((char)'z');
        OptionBuilder.withLongOpt((String)TYPE_OPT_NAME);
        OptionBuilder.withDescription((String)TYPE_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"checkpoint_type");
        Option typeOption = OptionBuilder.create((char)'t');
        OptionBuilder.withLongOpt((String)BOOTSTRAP_SOURCE_OPT_NAME);
        OptionBuilder.withDescription((String)BOOTSTRAP_SOURCE_OPT_DESCR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"bootstrap_source_name");
        Option bootstrapSourceOption = OptionBuilder.create((char)'b');
        Options options = new Options();
        options.addOption(helpOption);
        options.addOption(actionOption);
        options.addOption(clientPropsOption);
        options.addOption(cp3PropsOption);
        options.addOption(propsPrefixOption);
        options.addOption(sourcesOption);
        options.addOption(scnOptOption);
        options.addOption(sinceScnOptOption);
        options.addOption(startScnOptOption);
        options.addOption(targetScnOptOption);
        options.addOption(typeOption);
        options.addOption(bootstrapSourceOption);
        return options;
    }

    private static void parseArgs(String[] args) throws Exception {
        GnuParser cliParser = new GnuParser();
        Options options = CheckpointSerializerMain.createOptions();
        CommandLine cmd = null;
        try {
            cmd = cliParser.parse(options, args);
        }
        catch (ParseException pe) {
            throw new RuntimeException("failed to parse command-line options.", pe);
        }
        if (cmd.hasOption('h') || 0 == cmd.getOptions().length) {
            CheckpointSerializerMain.printCliHelp(options);
            System.exit(0);
        }
        try {
            _action = Action.valueOf(cmd.getOptionValue('a').toUpperCase());
        }
        catch (Exception e) {
            throw new RuntimeException("invalid action: " + cmd.getOptionValue('a'), e);
        }
        if (!cmd.hasOption('S')) {
            throw new RuntimeException("expected sources list; see --help for more info");
        }
        String sourcesListStr = cmd.getOptionValue('S');
        _sources = sourcesListStr.split(",");
        if (null == _sources || 0 == _sources.length) {
            throw new RuntimeException("empty sources list");
        }
        for (int i = 0; i < _sources.length; ++i) {
            CheckpointSerializerMain._sources[i] = _sources[i].trim();
        }
        if (Action.PRINT != _action && !cmd.hasOption('c') && !cmd.hasOption('C')) {
            throw new RuntimeException("expected client or CP3 configuration; see --help for more info");
        }
        String defaultPropPrefix = null;
        if (cmd.hasOption('c')) {
            try {
                _clientProps = CheckpointSerializerMain.loadProperties(cmd.getOptionValue('c'));
                defaultPropPrefix = "databus2.client";
            }
            catch (Exception e) {
                throw new RuntimeException("unable to load client properties", e);
            }
        }
        if (cmd.hasOption('C')) {
            try {
                _cp3Props = CheckpointSerializerMain.loadProperties(cmd.getOptionValue('C'));
                defaultPropPrefix = "databus2.client.checkpointPersistence";
            }
            catch (Exception e) {
                throw new RuntimeException("unable to load CP3 properties", e);
            }
        }
        String string = _propPrefix = cmd.hasOption('f') ? cmd.getOptionValue('f') : defaultPropPrefix;
        if (null != _propPrefix && !_propPrefix.endsWith(".")) {
            _propPrefix = _propPrefix + ".";
        }
        if (!cmd.hasOption('a')) {
            throw new RuntimeException("action expected; see --help for more info");
        }
        _scn = CheckpointSerializerMain.parseLongOption(cmd, 's', "sequence number");
        _sinceScn = CheckpointSerializerMain.parseLongOption(cmd, 'x', "last sequence number");
        _startScn = CheckpointSerializerMain.parseLongOption(cmd, 'y', "start sequence number");
        _targetScn = CheckpointSerializerMain.parseLongOption(cmd, 'z', "target sequence number");
        if (cmd.hasOption('t')) {
            try {
                _cpType = DbusClientMode.valueOf((String)cmd.getOptionValue('t').toUpperCase());
            }
            catch (Exception e) {
                throw new RuntimeException("invalid checkpoint type:" + cmd.getOptionValue('t'), e);
            }
        }
        if (cmd.hasOption('b')) {
            _bootstrapSource = cmd.getOptionValue('b');
        }
    }

    private static Long parseLongOption(CommandLine cmd, char optionChar, String argName) {
        Long result = null;
        if (cmd.hasOption(optionChar)) {
            try {
                result = Long.parseLong(cmd.getOptionValue(optionChar));
            }
            catch (NumberFormatException nfe) {
                throw new RuntimeException("invalid " + argName + ": " + cmd.getOptionValue(optionChar), nfe);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties loadProperties(String fileName) throws IOException {
        Properties result = new Properties();
        FileReader freader = new FileReader(fileName);
        try {
            result.load(freader);
        }
        finally {
            freader.close();
        }
        return result;
    }

    private static void printCliHelp(Options cliOptions) {
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.setWidth(120);
        helpFormatter.printHelp("java " + CheckpointSerializerMain.class.getName(), cliOptions);
    }

    private static Checkpoint updateCheckpoint(Checkpoint cpOld) throws JsonParseException, JsonMappingException, IOException {
        Checkpoint cpNew;
        Checkpoint checkpoint = cpNew = null != cpOld ? new Checkpoint(cpOld.toString()) : new Checkpoint();
        if (null != _scn) {
            if (-1L != _scn) {
                cpNew.setWindowScn(_scn);
                cpNew.setWindowOffset(0L);
            } else {
                cpNew.setFlexible();
            }
        }
        if (null != _startScn) {
            cpNew.setBootstrapStartScn(_startScn);
        }
        if (null != _targetScn) {
            cpNew.setBootstrapTargetScn(_targetScn);
        }
        if (null != _cpType) {
            cpNew.setConsumptionMode(_cpType);
            switch (_cpType) {
                case ONLINE_CONSUMPTION: {
                    cpNew.setWindowOffset(0L);
                    break;
                }
                case BOOTSTRAP_SNAPSHOT: {
                    BootstrapCheckpointHandler handler = new BootstrapCheckpointHandler(_sources);
                    cpNew = handler.createInitialBootstrapCheckpoint(cpNew, _sinceScn);
                    cpNew.setSnapshotOffset(-1L);
                    break;
                }
                default: {
                    throw new DatabusRuntimeException("unsupported checkpoint type: " + _cpType);
                }
            }
        }
        return cpNew;
    }

    public static void main(String[] args) throws Exception {
        Checkpoint cpNew;
        Checkpoint cpOld;
        ConfigLoader configLoader;
        CheckpointSerializerMain.parseArgs(args);
        PatternLayout defaultLayout = new PatternLayout("%d{ISO8601} +%r [%t] (%p) {%c{1}} %m%n");
        ConsoleAppender defaultAppender = new ConsoleAppender((Layout)defaultLayout);
        Logger.getRootLogger().removeAllAppenders();
        Logger.getRootLogger().addAppender((Appender)defaultAppender);
        Logger.getRootLogger().setLevel(Level.INFO);
        Logger.getRootLogger().info((Object)"NOTE. This tool works only with V2/V1 checkpoints");
        FileSystemCheckpointPersistenceProvider cp3 = null;
        if (null != _cp3Props) {
            DatabusHttpClientImpl.CheckpointPersistenceStaticConfigBuilder cp3ConfBuilder = new DatabusHttpClientImpl.CheckpointPersistenceStaticConfigBuilder();
            configLoader = new ConfigLoader(_propPrefix, (ConfigBuilder)cp3ConfBuilder);
            configLoader.loadConfig((Map)_cp3Props);
            DatabusHttpClientImpl.CheckpointPersistenceStaticConfig cp3Conf = cp3ConfBuilder.build();
            if (cp3Conf.getType() != DatabusHttpClientImpl.CheckpointPersistenceStaticConfig.ProviderType.FILE_SYSTEM) {
                throw new RuntimeException("don't know what to do with cp3 type:" + cp3Conf.getType());
            }
            cp3 = new FileSystemCheckpointPersistenceProvider(cp3Conf.getFileSystem(), 2);
        } else if (null != _clientProps) {
            DatabusHttpClientImpl.Config clientConfBuilder = new DatabusHttpClientImpl.Config();
            configLoader = new ConfigLoader(_propPrefix, (ConfigBuilder)clientConfBuilder);
            configLoader.loadConfig((Map)_clientProps);
            DatabusHttpClientImpl.StaticConfig clientConf = clientConfBuilder.build();
            if (clientConf.getCheckpointPersistence().getType() != DatabusHttpClientImpl.CheckpointPersistenceStaticConfig.ProviderType.FILE_SYSTEM) {
                throw new RuntimeException("don't know what to do with cp3 type:" + clientConf.getCheckpointPersistence().getType());
            }
            cp3 = new FileSystemCheckpointPersistenceProvider(clientConf.getCheckpointPersistence().getFileSystem(), 2);
        }
        List<String> sourceList = Arrays.asList(_sources);
        Checkpoint checkpoint = cpOld = null != cp3 ? cp3.loadCheckpoint(sourceList) : new Checkpoint();
        if (Action.PRINT == _action) {
            cpNew = CheckpointSerializerMain.updateCheckpoint(cpOld);
        } else if (Action.CHANGE == _action) {
            cpNew = CheckpointSerializerMain.updateCheckpoint(cpOld);
            cp3.storeCheckpoint(sourceList, cpNew);
            cpNew = cp3.loadCheckpoint(sourceList);
        } else if (Action.DELETE == _action) {
            cp3.removeCheckpoint(sourceList);
            cpNew = cp3.loadCheckpoint(sourceList);
        } else {
            throw new RuntimeException("don't know what to do with action: " + (Object)((Object)_action));
        }
        if (null != cpOld) {
            System.out.println("old: " + cpOld.toString());
        } else {
            System.out.println("old: null");
        }
        if (null != cpNew) {
            System.out.println("new: " + cpNew.toString());
        } else {
            System.out.println("new: null");
        }
    }

    private static enum Action {
        PRINT,
        CHANGE,
        DELETE;

    }
}

