/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.monitoring.mbean;

import com.linkedin.databus.monitoring.mbean.GGParserStatisticsMBean;

public class GGParserStatistics
implements GGParserStatisticsMBean {
    private final String _phSourceName;
    private int _numErrors = 0;
    private int _numParsingErrors = 0;
    private int _numRestarts;
    private int _filesAdded = 0;
    private int _filesParsed = 0;
    private long _bytesRead;
    private long _timeMostRecentRead;
    private long _timeMostRecentAdded;
    private long _bytesLag;
    private long _modTimeLag;
    private int _filesLag;
    private int _numTransactions;
    private long _transactionSize;
    private long _transactionTimeReadNs;
    private long _mostRecentTransTSMs;
    private long _maxScn;
    private int _transactionsWithEvents;
    private int _transactionsWithOutEvents;
    private int _eventsTotal;
    private long _numScnRegressions = 0L;
    private long _lastRegressedScn = -1L;

    public GGParserStatistics(String phSourceName) {
        this._phSourceName = phSourceName;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("\npSource=").append(this._phSourceName);
        sb.append(";maxScn=").append(this._maxScn);
        sb.append(";evTotal=").append(this._eventsTotal);
        sb.append("\n");
        sb.append("filesAdded=").append(this._filesAdded);
        sb.append(";filesParsed=").append(this._filesParsed);
        sb.append(";bytesRead=").append(this._bytesRead);
        sb.append(";TSMostRecentRead=").append(this._timeMostRecentRead);
        sb.append(";TSMostRecentAdded=").append(this._timeMostRecentAdded);
        sb.append(";tSinceRead=").append(this.getTimeSinceLastAccessMs());
        sb.append("\n");
        sb.append("LAG=").append(this._bytesLag).append(":").append(this._filesLag).append(":").append(this._modTimeLag);
        sb.append("\n");
        sb.append("TxnTotal=").append(this._transactionsWithEvents).append("+").append(this._transactionsWithOutEvents).append("=").append(this._numTransactions);
        sb.append("\n");
        sb.append("TxnStats(totalSize, readTime, lastTS)=").append(this._transactionSize).append(":").append(this._transactionTimeReadNs).append(":").append(this._mostRecentTransTSMs);
        sb.append("\n");
        sb.append("parseErrofs=").append(this._numParsingErrors).append(";errors=").append(this._numErrors);
        sb.append("\n");
        sb.append("LastRegressSCN=").append(this._lastRegressedScn).append(";NumSCNRegressions=").append(this._numScnRegressions);
        return sb.toString();
    }

    public void addTransactionInfo(TransactionInfo tr, int numEventsInTrans) {
        this._transactionSize += tr.getTransactionSize();
        this._transactionTimeReadNs += tr.getTransactionTimeRead();
        this._mostRecentTransTSMs = tr.getTransactionTimeStampNs() / 1000000L;
        long transScn = tr.getScn();
        if (transScn > this._maxScn) {
            this._maxScn = transScn;
        }
        if (numEventsInTrans > 0) {
            ++this._transactionsWithEvents;
        } else {
            ++this._transactionsWithOutEvents;
        }
        this._eventsTotal += numEventsInTrans;
        ++this._numTransactions;
    }

    public void addError() {
        ++this._numErrors;
    }

    public void addParsingError() {
        ++this._numParsingErrors;
        ++this._numRestarts;
    }

    public void addNewFile(int numNewFiles) {
        this._filesAdded += numNewFiles;
    }

    public void addParsedFile(int files) {
        this._filesParsed += files;
    }

    public void addBytesParsed(long bytesParsed) {
        this._bytesRead = bytesParsed;
        this._timeMostRecentRead = System.currentTimeMillis();
    }

    public void setBytesLag(long lag) {
        this._bytesLag = lag;
    }

    public void setFilesLag(int lag) {
        this._filesLag = lag;
    }

    public void setModTimeLag(long tsBegin, long tsEnd) {
        this._modTimeLag = tsEnd - tsBegin;
        this._timeMostRecentAdded = tsEnd;
    }

    public String getPhysicalSourceName() {
        return this._phSourceName;
    }

    @Override
    public int getNumTransactionsWithEvents() {
        return this._transactionsWithEvents;
    }

    @Override
    public int getNumTransactionsWithoutEvents() {
        return this._transactionsWithOutEvents;
    }

    @Override
    public int getNumTransactionsTotal() {
        return this._numTransactions;
    }

    @Override
    public int getNumFilesParsed() {
        return this._filesParsed;
    }

    @Override
    public int getNumFilesAdded() {
        return this._filesAdded;
    }

    @Override
    public long getAvgTransactionSize() {
        if (this._numTransactions == 0) {
            return 0L;
        }
        return this._transactionSize / (long)this._numTransactions;
    }

    @Override
    public long getAvgParseTransactionTimeNs() {
        if (this._numTransactions == 0) {
            return 0L;
        }
        return this._transactionTimeReadNs / (long)this._numTransactions;
    }

    @Override
    public long getTimeSinceLastTransactionMs() {
        if (this._mostRecentTransTSMs <= 0L) {
            return -1L;
        }
        return System.currentTimeMillis() - this._mostRecentTransTSMs;
    }

    @Override
    public int getNumTotalEvents() {
        return this._eventsTotal;
    }

    @Override
    public long getMaxScn() {
        return this._maxScn;
    }

    @Override
    public long getNumErrors() {
        return this._numErrors;
    }

    @Override
    public long getNumParseErrors() {
        return this._numParsingErrors;
    }

    @Override
    public long getNumParseRestarts() {
        return this._numRestarts;
    }

    @Override
    public long getTimeSinceLastAccessMs() {
        if (this._timeMostRecentRead == 0L) {
            return -1L;
        }
        return System.currentTimeMillis() - this._timeMostRecentRead;
    }

    @Override
    public long getFilesLag() {
        return this._filesLag;
    }

    @Override
    public long getTimeLag() {
        return this._modTimeLag;
    }

    @Override
    public long getBytesLag() {
        return this._bytesLag;
    }

    @Override
    public void reset() {
        this._numErrors = 0;
        this._numParsingErrors = 0;
        this._numRestarts = 0;
        this._filesAdded = 0;
        this._filesParsed = 0;
        this._bytesRead = 0L;
        this._timeMostRecentRead = 0L;
        this._timeMostRecentAdded = 0L;
        this._bytesLag = 0L;
        this._modTimeLag = 0L;
        this._filesLag = 0;
        this._numTransactions = 0;
        this._transactionSize = 0L;
        this._transactionTimeReadNs = 0L;
        this._mostRecentTransTSMs = 0L;
        this._maxScn = 0L;
        this._transactionsWithEvents = 0;
        this._transactionsWithOutEvents = 0;
        this._eventsTotal = 0;
        this._numScnRegressions = 0L;
        this._lastRegressedScn = -1L;
    }

    @Override
    public long getAvgFileSize() {
        return (this._bytesRead + this._bytesLag) / (long)this._filesAdded;
    }

    @Override
    public long getNumBytesTotalParsed() {
        return this._bytesRead;
    }

    public long getTsMostRecentFileAdded() {
        if (this._timeMostRecentAdded == 0L) {
            return -1L;
        }
        return this._timeMostRecentAdded;
    }

    @Override
    public long getNumSCNRegressions() {
        return this._numScnRegressions;
    }

    @Override
    public long getLastRegressedScn() {
        return this._lastRegressedScn;
    }

    public void addScnRegression(long regressScn) {
        ++this._numScnRegressions;
        this._lastRegressedScn = regressScn;
    }

    public static class TransactionInfo {
        private final long _transactionSize;
        private final long _transactionTimeReadNs;
        private final long _transactionEventTSNs;
        private final long _scn;

        public long getTransactionSize() {
            return this._transactionSize;
        }

        public long getTransactionTimeRead() {
            return this._transactionTimeReadNs;
        }

        public long getTransactionTimeStampNs() {
            return this._transactionEventTSNs;
        }

        public long getScn() {
            return this._scn;
        }

        public TransactionInfo(long size, long timeReadNs, long tsNs, long scn) {
            this._transactionSize = size;
            this._transactionTimeReadNs = timeReadNs;
            this._transactionEventTSNs = tsNs;
            this._scn = scn;
        }
    }
}

