/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers.ds;

import com.linkedin.databus2.producers.ds.DbChangeEntry;
import java.util.HashSet;
import java.util.Set;

public class PerSourceTransaction {
    private final int _srcId;
    private Set<DbChangeEntry> _dbChangeEntrySet;

    public PerSourceTransaction(int srcId, Set<DbChangeEntry> dbChangeEntrySet) {
        this._srcId = srcId;
        this._dbChangeEntrySet = dbChangeEntrySet;
        if (null == this._dbChangeEntrySet) {
            this._dbChangeEntrySet = new HashSet<DbChangeEntry>();
        }
    }

    public PerSourceTransaction(int srcId) {
        this(srcId, null);
    }

    public Set<DbChangeEntry> getDbChangeEntrySet() {
        return this._dbChangeEntrySet;
    }

    public void mergeDbChangeEntrySet(DbChangeEntry dbChangeEntry) {
        if (this._dbChangeEntrySet.contains(dbChangeEntry)) {
            this._dbChangeEntrySet.remove(dbChangeEntry);
        }
        this._dbChangeEntrySet.add(dbChangeEntry);
    }

    public int getSrcId() {
        return this._srcId;
    }

    public long getScn() {
        long maxScn = -1L;
        for (DbChangeEntry c : this._dbChangeEntrySet) {
            maxScn = Math.max(maxScn, c.getScn());
        }
        return maxScn;
    }
}

