/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers;

import com.linkedin.databus.core.DbusEventBufferAppendable;
import com.linkedin.databus.core.DbusEventInfo;
import com.linkedin.databus.core.DbusEventKey;
import com.linkedin.databus.core.UnsupportedKeyException;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.producers.EventCreationException;
import com.linkedin.databus2.producers.PartitionFunction;
import com.linkedin.databus2.producers.ds.DbChangeEntry;
import com.linkedin.databus2.producers.ds.KeyPair;
import com.linkedin.databus2.producers.ds.PrimaryKeySchema;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import com.linkedin.databus2.schemas.SchemaId;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Encoder;
import org.apache.log4j.Logger;

public class OpenReplicatorAvroEventFactory {
    protected final Schema _eventSchema;
    protected final byte[] _schemaId;
    protected final int _sourceId;
    protected final int _pSourceId;
    protected final PartitionFunction _partitionFunction;
    private final Logger _log = Logger.getLogger(this.getClass());
    private final PrimaryKeySchema _pKeySchema;
    private final ReplicationBitSetterStaticConfig _replSetterConfig;
    private final Pattern _replBitSetterPattern;
    public static final String MODULE = OpenReplicatorAvroEventFactory.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public OpenReplicatorAvroEventFactory(int sourceId, int pSourceId, String eventSchema, PartitionFunction partitionFunction, ReplicationBitSetterStaticConfig replSetterConfig) throws DatabusException {
        this._sourceId = sourceId;
        this._pSourceId = pSourceId;
        this._eventSchema = Schema.parse((String)eventSchema);
        this._schemaId = SchemaHelper.getSchemaId((String)eventSchema);
        this._partitionFunction = partitionFunction;
        this._replSetterConfig = replSetterConfig;
        this._replBitSetterPattern = null != this._replSetterConfig && ReplicationBitSetterStaticConfig.SourceType.COLUMN.equals((Object)this._replSetterConfig.getSourceType()) ? Pattern.compile(replSetterConfig.getRemoteUpdateValueRegex()) : null;
        String keyName = SchemaHelper.getMetaField((Schema)this._eventSchema, (String)"pk");
        if (keyName == null) {
            throw new DatabusException("The event schema is missing the required field \"key\".");
        }
        this._pKeySchema = new PrimaryKeySchema(keyName);
    }

    public int createAndAppendEvent(DbChangeEntry changeEntry, DbusEventBufferAppendable eventBuffer, boolean enableTracing, DbusEventsStatisticsCollector dbusEventsStatisticsCollector) throws EventCreationException, UnsupportedKeyException, DatabusException {
        Object keyObj = this.obtainKey(changeEntry);
        DbusEventKey eventKey = new DbusEventKey(keyObj);
        short lPartitionId = this._partitionFunction.getPartition(eventKey);
        SchemaId schemaId = SchemaId.createWithMd5((Schema)changeEntry.getSchema());
        byte[] payload = this.serializeEvent(changeEntry.getRecord());
        DbusEventInfo eventInfo = new DbusEventInfo(changeEntry.getOpCode(), changeEntry.getScn(), (short)this._pSourceId, lPartitionId, changeEntry.getTimestampInNanos(), (short)this._sourceId, schemaId.getByteArray(), payload, enableTracing, false);
        boolean success = eventBuffer.appendEvent(eventKey, eventInfo, dbusEventsStatisticsCollector);
        return success ? payload.length : -1;
    }

    protected byte[] serializeEvent(GenericRecord record) throws EventCreationException {
        byte[] serializedValue;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            BinaryEncoder encoder = new BinaryEncoder((OutputStream)bos);
            GenericDatumWriter writer = new GenericDatumWriter(record.getSchema());
            writer.write((Object)record, (Encoder)encoder);
            serializedValue = bos.toByteArray();
        }
        catch (IOException ex) {
            throw new EventCreationException("Failed to serialize the Avro GenericRecord", (Throwable)ex);
        }
        catch (RuntimeException ex) {
            throw new EventCreationException("Failed to serialize the Avro GenericRecord", (Throwable)ex);
        }
        return serializedValue;
    }

    public int getSourceId() {
        return this._sourceId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object obtainKey(DbChangeEntry dbChangeEntry) throws DatabusException {
        if (null == dbChangeEntry) {
            throw new DatabusException("DBUpdateImage is null");
        }
        List pairs = dbChangeEntry.getPkeys();
        if (null == pairs) throw new DatabusException("There do not seem to be any keys");
        if (pairs.size() == 0) {
            throw new DatabusException("There do not seem to be any keys");
        }
        if (pairs.size() == 1) {
            Object key = ((KeyPair)pairs.get(0)).getKey();
            Schema.Type pKeyType = ((KeyPair)pairs.get(0)).getKeyType();
            Object keyObj = null;
            if (pKeyType == Schema.Type.INT) {
                if (!(key instanceof Integer)) throw new DatabusException("Schema.Type does not match actual key type (INT) " + key.getClass().getName());
                return key;
            }
            if (pKeyType != Schema.Type.LONG) return key;
            if (!(key instanceof Long)) throw new DatabusException("Schema.Type does not match actual key type (LONG) " + key.getClass().getName());
            keyObj = key;
            return key;
        }
        Iterator li = pairs.iterator();
        StringBuilder compositeKey = new StringBuilder();
        while (li.hasNext()) {
            KeyPair kp = (KeyPair)li.next();
            Schema.Type pKeyType = kp.getKeyType();
            Object key = kp.getKey();
            if (pKeyType == Schema.Type.INT) {
                if (!(key instanceof Integer)) throw new DatabusException("Schema.Type does not match actual key type (INT) " + key.getClass().getName());
                compositeKey.append(kp.getKey().toString());
            } else if (pKeyType == Schema.Type.LONG) {
                if (!(key instanceof Long)) throw new DatabusException("Schema.Type does not match actual key type (LONG) " + key.getClass().getName());
                compositeKey.append(key.toString());
            } else {
                compositeKey.append(key);
            }
            if (!li.hasNext()) continue;
            compositeKey.append("\t");
        }
        return compositeKey.toString();
    }
}

