/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.netty;

import com.linkedin.databus.container.netty.HttpRelayPipelineFactory;
import com.linkedin.databus.container.request.BufferInfoRequestProcessor;
import com.linkedin.databus.container.request.GenerateDataEventsRequestProcessor;
import com.linkedin.databus.container.request.LoadDataEventsRequestProcessor;
import com.linkedin.databus.container.request.PhysicalBuffersRequestProcessor;
import com.linkedin.databus.container.request.PhysicalSourcesRequestProcessor;
import com.linkedin.databus.container.request.ReadEventsRequestProcessor;
import com.linkedin.databus.container.request.RegisterRequestProcessor;
import com.linkedin.databus.container.request.RelayCommandRequestProcessor;
import com.linkedin.databus.container.request.RelayContainerStatsRequestProcessor;
import com.linkedin.databus.container.request.RelayStatsRequestProcessor;
import com.linkedin.databus.container.request.SourcesRequestProcessor;
import com.linkedin.databus.core.DbusEventBuffer;
import com.linkedin.databus.core.DbusEventBufferMetaInfo;
import com.linkedin.databus.core.DbusEventBufferMult;
import com.linkedin.databus.core.DbusEventFactory;
import com.linkedin.databus.core.DbusEventV1Factory;
import com.linkedin.databus.core.EventLogReader;
import com.linkedin.databus.core.EventLogWriter;
import com.linkedin.databus.core.UnsupportedKeyException;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus.core.monitoring.mbean.DbusEventStatsCollectorsPartitioner;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectors;
import com.linkedin.databus.core.util.ConfigApplier;
import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.ConfigLoader;
import com.linkedin.databus.core.util.ConfigManager;
import com.linkedin.databus.core.util.DatabusEventProducer;
import com.linkedin.databus.core.util.DatabusEventRandomProducer;
import com.linkedin.databus.core.util.IdNamePair;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus.core.util.PhysicalSourceConfigBuilder;
import com.linkedin.databus2.core.BufferNotFoundException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.monitoring.mbean.DatabusComponentAdmin;
import com.linkedin.databus2.core.container.monitoring.mbean.HttpStatisticsCollector;
import com.linkedin.databus2.core.container.netty.ServerContainer;
import com.linkedin.databus2.core.container.request.ConfigRequestProcessor;
import com.linkedin.databus2.core.container.request.EchoRequestProcessor;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import com.linkedin.databus2.core.container.request.RequestProcessorRegistry;
import com.linkedin.databus2.core.container.request.SleepRequestProcessor;
import com.linkedin.databus2.producers.EventCreationException;
import com.linkedin.databus2.relay.AddRemovePartitionInterface;
import com.linkedin.databus2.relay.config.DataSourcesStaticConfig;
import com.linkedin.databus2.relay.config.DataSourcesStaticConfigBuilder;
import com.linkedin.databus2.relay.config.LogicalSourceConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import com.linkedin.databus2.schemas.FileSystemSchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryConfigBuilder;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.SchemaRegistryStaticConfig;
import com.linkedin.databus2.schemas.SourceIdNameRegistry;
import com.linkedin.databus2.schemas.StandardSchemaRegistryFactory;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.avro.Schema;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.netty.channel.Channel;
import org.jboss.netty.channel.ChannelPipelineFactory;
import org.jboss.netty.channel.ServerChannel;

public class HttpRelay
extends ServerContainer
implements AddRemovePartitionInterface {
    private static final String MODULE = HttpRelay.class.getName();
    private static final Logger LOG = Logger.getLogger((String)MODULE);
    private DbusEventBufferMult _eventBufferMult;
    private final DbusEventFactory _eventFactory;
    private final SchemaRegistryService _schemaRegistryService;
    protected final StaticConfig _relayStaticConfig;
    private final ConfigManager<RuntimeConfig> _relayConfigManager;
    private final HttpStatisticsCollector _httpStatisticsCollector;
    private final SourceIdNameRegistry _sourcesIdNameRegistry;
    protected List<PhysicalSourceStaticConfig> _pConfigs;
    final Map<String, Short> _sourceSchemaVersionMap = new ConcurrentHashMap<String, Short>();
    protected DbusEventStatsCollectorsPartitioner _dbInboundStatsCollectors;
    protected DbusEventStatsCollectorsPartitioner _dbOutboundStatsCollectors;

    public HttpRelay(Config config, PhysicalSourceStaticConfig[] pConfigs) throws IOException, InvalidConfigException, DatabusException {
        this(config.build(), pConfigs);
    }

    public HttpRelay(StaticConfig config, PhysicalSourceStaticConfig[] pConfigs) throws IOException, InvalidConfigException, DatabusException {
        this(config, pConfigs, SourceIdNameRegistry.createFromIdNamePairs(config.getSourceIds()), new StandardSchemaRegistryFactory(config.getSchemaRegistry()).createSchemaRegistry(), (DbusEventFactory)new DbusEventV1Factory());
    }

    public HttpRelay(StaticConfig config, PhysicalSourceStaticConfig[] pConfigs, SourceIdNameRegistry sourcesIdNameRegistry, SchemaRegistryService schemaRegistry) throws IOException, InvalidConfigException, DatabusException {
        this(config, pConfigs, sourcesIdNameRegistry, schemaRegistry, (DbusEventFactory)new DbusEventV1Factory());
    }

    public HttpRelay(StaticConfig config, PhysicalSourceStaticConfig[] pConfigs, SourceIdNameRegistry sourcesIdNameRegistry, SchemaRegistryService schemaRegistry, DbusEventFactory eventFactory) throws IOException, InvalidConfigException, DatabusException {
        super(config.getContainer(), eventFactory.getByteOrder());
        this._relayStaticConfig = config;
        this._sourcesIdNameRegistry = sourcesIdNameRegistry;
        this._eventFactory = eventFactory;
        if (pConfigs == null) {
            this.initPConfigs(config);
        } else if (pConfigs.length == 0) {
            this._pConfigs = new ArrayList<PhysicalSourceStaticConfig>();
        } else {
            this._pConfigs = new ArrayList<PhysicalSourceStaticConfig>();
            for (PhysicalSourceStaticConfig pC : pConfigs) {
                this._pConfigs.add(pC);
            }
        }
        if (this._eventBufferMult == null) {
            PhysicalSourceStaticConfig[] psscArr = new PhysicalSourceStaticConfig[this._pConfigs.size()];
            this._pConfigs.toArray(psscArr);
            this._eventBufferMult = new DbusEventBufferMult(psscArr, config.getEventBuffer(), this._eventFactory);
        }
        this._eventBufferMult.setDropOldEvents(true);
        this._dbInboundStatsCollectors = new DbusEventStatsCollectorsPartitioner(this.getContainerStaticConfig().getId(), ".inbound", this.getMbeanServer());
        this._dbOutboundStatsCollectors = new DbusEventStatsCollectorsPartitioner(this.getContainerStaticConfig().getId(), ".outbound", this.getMbeanServer());
        if (null != this._eventBufferMult.getAllPhysicalPartitionKeys()) {
            for (DbusEventBufferMult.PhysicalPartitionKey pkey : this._eventBufferMult.getAllPhysicalPartitionKeys()) {
                this.addPhysicalPartitionCollectors(pkey.getPhysicalPartition());
            }
        }
        this._sourcesIdNameRegistry.getAllSources();
        this._schemaRegistryService = schemaRegistry;
        if (null == this._schemaRegistryService) {
            throw new InvalidConfigException("Unable to initialize schema registry");
        }
        HttpStatisticsCollector httpStatsColl = this._relayStaticConfig.getHttpStatsCollector().getExistingStatsCollector();
        if (null == httpStatsColl) {
            httpStatsColl = new HttpStatisticsCollector(this.getContainerStaticConfig().getId(), "httpOutbound", this._relayStaticConfig.getRuntime().getHttpStatsCollector().isEnabled(), true, this.getMbeanServer());
        }
        this._httpStatisticsCollector = httpStatsColl;
        this._relayStaticConfig.getRuntime().setManagedInstance(this);
        this._relayConfigManager = new ConfigManager("databus.relay.runtime.", (ConfigBuilder)this._relayStaticConfig.getRuntime());
        this.initializeRelayNetworking();
        this.initializeRelayCommandProcessors();
    }

    protected DatabusComponentAdmin createComponentAdmin() {
        return new DatabusComponentAdmin((ServerContainer)this, this.getMbeanServer(), HttpRelay.class.getSimpleName());
    }

    public Map<String, Short> getSourceSchemaVersionMap() {
        return this._sourceSchemaVersionMap;
    }

    public StaticConfig getRelayStaticConfig() {
        return this._relayStaticConfig;
    }

    protected void initializeRelayNetworking() throws IOException, DatabusException {
        this._httpBootstrap.setPipelineFactory((ChannelPipelineFactory)new HttpRelayPipelineFactory(this, this._httpBootstrap.getPipelineFactory()));
    }

    protected void initializeRelayCommandProcessors() throws DatabusException {
        this._processorRegistry.reregister("containerStats", (RequestProcessor)new RelayContainerStatsRequestProcessor(null, this));
        this._processorRegistry.register("config", (RequestProcessor)new ConfigRequestProcessor(null, (ServerContainer)this));
        this._processorRegistry.register("relayStats", (RequestProcessor)new RelayStatsRequestProcessor(null, this));
        this._processorRegistry.register("sources", (RequestProcessor)new SourcesRequestProcessor(null, this));
        this._processorRegistry.register("register", (RequestProcessor)new RegisterRequestProcessor(null, this));
        this._processorRegistry.register("stream", (RequestProcessor)new ReadEventsRequestProcessor(null, this));
        this._processorRegistry.register("physicalSources", (RequestProcessor)new PhysicalSourcesRequestProcessor(null, this));
        this._processorRegistry.register("physicalBuffers", (RequestProcessor)new PhysicalBuffersRequestProcessor(null, this));
        this._processorRegistry.register("bufferInfo", (RequestProcessor)new BufferInfoRequestProcessor(null, this._eventBufferMult));
        this._processorRegistry.register("relayCommand", (RequestProcessor)new RelayCommandRequestProcessor(null, this));
    }

    protected void doStart() {
        super.doStart();
    }

    public void disconnectDBusClients() {
        this.disconnectDBusClients(null);
    }

    public synchronized void disconnectDBusClients(Channel exceptThis) {
        LOG.info((Object)"disconnectDBusClients");
        if (this._httpChannelGroup != null) {
            LOG.info((Object)("Total " + this._httpChannelGroup.size() + " channels"));
            for (Channel channel : this._httpChannelGroup) {
                if (channel instanceof ServerChannel || exceptThis != null && channel.getId().equals(exceptThis.getId())) {
                    LOG.info((Object)("Skipping closing channel" + channel.getId()));
                    continue;
                }
                LOG.info((Object)("closing channel" + channel.getId()));
                channel.close();
            }
        }
    }

    protected void doShutdown() {
        super.doShutdown();
        this.getHttpStatisticsCollector().unregisterMBeans();
        if (null != this._schemaRegistryService && this._schemaRegistryService instanceof FileSystemSchemaRegistryService) {
            LOG.info((Object)"stopping file-system schema registry refresh thread");
            ((FileSystemSchemaRegistryService)this._schemaRegistryService).stopSchemasRefreshThread();
            LOG.info((Object)"file-system schema registry refresh thread stopped.");
        }
        this._dbInboundStatsCollectors.removeAllStatsCollector();
        this._dbOutboundStatsCollectors.removeAllStatsCollector();
    }

    public DbusEventBuffer addNewBuffer(PhysicalSourceStaticConfig pConfig, StaticConfig config) throws DatabusException {
        DbusEventBufferMult eventMult = this.getEventBuffer();
        DbusEventBuffer buf = eventMult.addNewBuffer(pConfig, config.getEventBuffer());
        return buf;
    }

    public void addOneProducer(PhysicalSourceStaticConfig pConfig) throws DatabusException, EventCreationException, UnsupportedKeyException, SQLException, InvalidConfigException {
    }

    public void removeOneProducer(PhysicalSourceStaticConfig pConfig) {
    }

    public void removeBuffer(PhysicalSourceStaticConfig pConfig) {
        DbusEventBufferMult eventMult = this.getEventBuffer();
        eventMult.removeBuffer(pConfig);
    }

    public void dropDatabase(String dbName) throws DatabusException {
        this._schemaRegistryService.dropDatabase(dbName);
        DbusEventBufferMult eventMult = this.getEventBuffer();
        for (DbusEventBuffer dBuf : eventMult.bufIterable()) {
            PhysicalPartition pp = dBuf.getPhysicalPartition();
            if (!pp.getName().equals(dbName)) continue;
            dBuf.closeBuffer(false);
            dBuf.removeMMapFiles();
            DbusEventBufferMult.PhysicalPartitionKey pKey = new DbusEventBufferMult.PhysicalPartitionKey(pp);
            eventMult.removeBuffer(pKey, null);
        }
        eventMult.deallocateRemovedBuffers(true);
    }

    public void resetBuffer(PhysicalPartition p, long prevScn, long binlogOffset) throws BufferNotFoundException {
        DbusEventBufferMult eventMult = this.getEventBuffer();
        eventMult.resetBuffer(p, prevScn);
    }

    public int[] getBinlogOffset(int serverId) throws DatabusException {
        throw new DatabusException("Unimplemented method");
    }

    public Map<String, String> printInfo() throws DatabusException {
        throw new DatabusException("Unimplemented method");
    }

    public static void main(String[] args) throws Exception {
        Cli cli = new Cli();
        cli.processCommandLineArgs(args);
        cli.parseRelayConfig();
        StaticConfig staticConfig = cli.getRelayConfigBuilder().build();
        HttpRelay relay = new HttpRelay(staticConfig, cli.getPhysicalSourceStaticConfigs());
        RequestProcessorRegistry processorRegistry = relay.getProcessorRegistry();
        SchemaRegistryService sr = relay.getSchemaRegistryService();
        HashMap<Long, byte[]> schemaIds = new HashMap<Long, byte[]>(staticConfig.getSourceIds().size());
        for (IdNamePair pair : staticConfig.getSourceIds()) {
            LOG.info((Object)("Http Relay Schema Reg:" + pair.getName() + " id=" + pair.getId()));
            String schemaStr = sr.fetchLatestSchemaBySourceName(pair.getName());
            if (schemaStr != null) {
                Schema s = Schema.parse((String)schemaStr);
                byte[] sid = SchemaHelper.getSchemaId((String)s.toString());
                LOG.info((Object)("Found schema! Adding schemaId for sourceName=" + pair.getName() + " id=" + pair.getId() + " schemaId=" + sid));
                schemaIds.put(pair.getId(), sid);
                continue;
            }
            byte[] defaultSid = "abcde".getBytes(Charset.defaultCharset());
            LOG.info((Object)("Didn't find schema! Adding default schemaId for sourceName=" + pair.getName() + "id=" + pair.getId() + " schemaId=" + defaultSid));
            schemaIds.put(pair.getId(), defaultSid);
        }
        DatabusEventRandomProducer randomEventProducer = new DatabusEventRandomProducer(relay.getEventBuffer(), 10L, 100, 1000L, staticConfig.getSourceIds(), schemaIds);
        randomEventProducer.setStatsCollector(relay.getInboundEventStatisticsCollector());
        processorRegistry.register("echo", (RequestProcessor)new EchoRequestProcessor(null));
        processorRegistry.register("sleep", (RequestProcessor)new SleepRequestProcessor(null));
        processorRegistry.register("genDataEvents", (RequestProcessor)new GenerateDataEventsRequestProcessor(null, relay, (DatabusEventProducer)randomEventProducer));
        processorRegistry.register("loadDataEvents", (RequestProcessor)new LoadDataEventsRequestProcessor(relay.getDefaultExecutorService(), relay));
        LOG.info((Object)("source = " + relay.getSourcesIdNameRegistry().getAllSources()));
        try {
            relay.registerShutdownHook();
            relay.startAndBlock();
        }
        catch (Exception e) {
            LOG.error((Object)"Error starting the relay", (Throwable)e);
        }
        LOG.info((Object)"Exiting relay");
    }

    public DbusEventFactory getEventFactory() {
        return this._eventFactory;
    }

    public DbusEventBufferMult getEventBuffer() {
        return this._eventBufferMult;
    }

    public SchemaRegistryService getSchemaRegistryService() {
        return this._schemaRegistryService;
    }

    public ConfigManager<RuntimeConfig> getRelayConfigManager() {
        return this._relayConfigManager;
    }

    public HttpStatisticsCollector getHttpStatisticsCollector() {
        return this._httpStatisticsCollector;
    }

    public void pause() {
    }

    public void resume() {
    }

    public void suspendOnError(Throwable cause) {
    }

    private void initPConfigs(StaticConfig config) throws InvalidConfigException {
        if (this._pConfigs != null) {
            return;
        }
        StringBuilder logListIds = new StringBuilder("Creating default physical source config. Sources are: ");
        PhysicalSourceConfig pConfig = PhysicalSourceConfig.createFromLogicalSources((Collection)this._sourcesIdNameRegistry.getAllSources());
        for (LogicalSourceConfig ls : pConfig.getSources()) {
            logListIds.append(ls.getId() + ":" + ls.getName() + ",");
        }
        LOG.info((Object)logListIds);
        this._pConfigs = new ArrayList<PhysicalSourceStaticConfig>(1);
        this._pConfigs.add(pConfig.build());
    }

    public List<PhysicalSourceStaticConfig> getPhysicalSources() {
        return this._pConfigs;
    }

    public SourceIdNameRegistry getSourcesIdNameRegistry() {
        return this._sourcesIdNameRegistry;
    }

    public void addPartition(PhysicalSourceStaticConfig pConfig) throws DatabusException {
        this.addNewBuffer(pConfig, this._relayStaticConfig);
    }

    public void removePartition(PhysicalSourceStaticConfig pConfig) {
        this.removeBuffer(pConfig);
    }

    public void saveBufferMetaInfo(boolean infoOnly) throws IOException {
        this.getEventBuffer().saveBufferMetaInfo(infoOnly);
    }

    public void validateRelayBuffers() throws DbusEventBufferMetaInfo.DbusEventBufferMetaInfoException {
        this.getEventBuffer().validateRelayBuffers();
    }

    public void shutdown() {
        super.shutdown();
        this.getEventBuffer().rollbackAllBuffers();
        this.getEventBuffer().close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPhysicalPartitionCollectors(PhysicalPartition pPartition) {
        DbusEventsStatisticsCollector collector;
        StatsCollectors statsCollectors;
        String statsCollectorName = pPartition.toSimpleString();
        if (null != this._inBoundStatsCollectors) {
            statsCollectors = this._inBoundStatsCollectors;
            synchronized (statsCollectors) {
                if (null == this._inBoundStatsCollectors.getStatsCollector(statsCollectorName)) {
                    collector = new DbusEventsStatisticsCollector(this.getContainerStaticConfig().getId(), statsCollectorName + ".inbound", true, false, this.getMbeanServer());
                    this._inBoundStatsCollectors.addStatsCollector(statsCollectorName, (StatsCollectorMergeable)collector);
                    this._dbInboundStatsCollectors.addStatsCollector(pPartition, collector);
                }
            }
        }
        if (null != this._outBoundStatsCollectors) {
            statsCollectors = this._outBoundStatsCollectors;
            synchronized (statsCollectors) {
                if (null == this._outBoundStatsCollectors.getStatsCollector(statsCollectorName)) {
                    collector = new DbusEventsStatisticsCollector(this.getContainerStaticConfig().getId(), statsCollectorName + ".outbound", true, false, this.getMbeanServer());
                    this._outBoundStatsCollectors.addStatsCollector(statsCollectorName, (StatsCollectorMergeable)collector);
                    this._dbOutboundStatsCollectors.addStatsCollector(pPartition, collector);
                }
            }
        }
    }

    public DbusEventStatsCollectorsPartitioner getDbInboundStatsCollectors() {
        return this._dbInboundStatsCollectors;
    }

    public DbusEventStatsCollectorsPartitioner getDbOutboundStatsCollectors() {
        return this._dbOutboundStatsCollectors;
    }

    public static class Config
    extends StaticConfigBuilderBase
    implements ConfigBuilder<StaticConfig> {
        public StaticConfig build() throws InvalidConfigException {
            ArrayList<IdNamePair> sourceIds = new ArrayList<IdNamePair>(this._sourceName.size());
            for (String srcIdStr : this._sourceName.keySet()) {
                try {
                    long srcId = Long.parseLong(srcIdStr);
                    sourceIds.add(new IdNamePair(Long.valueOf(srcId), (String)this._sourceName.get(srcIdStr)));
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidConfigException("Invalid source id: " + srcIdStr);
                }
            }
            PhysicalSourceStaticConfig[] physConfigs = this.buildInitPhysicalSourcesConfigs();
            return new StaticConfig(this._eventBuffer.build(), this._container.build(), this._schemaRegistry.build(), sourceIds, this.getRuntime(), this._httpStatsCollector.build(), this._inboundEventsStatsCollector.build(), this._outboundEventsStatsCollector.build(), this._randomProducer.build(), this._eventLogWriter.build(), this._eventLogReader.build(), Boolean.parseBoolean(this._startDbPuller), this._dataSources.build(), physConfigs);
        }
    }

    public static class StaticConfigBuilderBase {
        protected DbusEventBuffer.Config _eventBuffer = new DbusEventBuffer.Config();
        protected ServerContainer.Config _container;
        protected SchemaRegistryConfigBuilder _schemaRegistry = new SchemaRegistryConfigBuilder();
        protected final HashMap<String, String> _sourceName;
        protected RuntimeConfigBuilder _runtime;
        protected HttpStatisticsCollector.Config _httpStatsCollector;
        protected DbusEventsStatisticsCollector.Config _outboundEventsStatsCollector;
        protected DbusEventsStatisticsCollector.Config _inboundEventsStatsCollector;
        protected DatabusEventRandomProducer.Config _randomProducer;
        protected EventLogWriter.Config _eventLogWriter;
        protected EventLogReader.Config _eventLogReader;
        protected String _startDbPuller;
        protected DataSourcesStaticConfigBuilder _dataSources;
        protected ArrayList<PhysicalSourceConfig> _physicalSourcesConfigs;
        protected String _physicalSourcesConfigsPattern;

        public StaticConfigBuilderBase() throws IOException {
            this.setContainer(new ServerContainer.Config());
            this._sourceName = new HashMap(100);
            this._runtime = new RuntimeConfigBuilder(this._container.getRuntime());
            this._httpStatsCollector = new HttpStatisticsCollector.Config();
            this._outboundEventsStatsCollector = new DbusEventsStatisticsCollector.Config();
            this._inboundEventsStatsCollector = new DbusEventsStatisticsCollector.Config();
            this._randomProducer = new DatabusEventRandomProducer.Config();
            this._eventLogWriter = new EventLogWriter.Config();
            this._eventLogReader = new EventLogReader.Config();
            this._dataSources = new DataSourcesStaticConfigBuilder();
            this._physicalSourcesConfigs = new ArrayList();
            this.setStartDbPuller("false");
        }

        public ServerContainer.Config getContainer() {
            return this._container;
        }

        public DbusEventBuffer.Config getEventBuffer() {
            return this._eventBuffer;
        }

        public void setEventBuffer(DbusEventBuffer.Config eventBufferConfig) {
            System.out.println("DEBUG: setEventBuffer Called");
            this._eventBuffer = eventBufferConfig;
        }

        public DatabusEventRandomProducer.Config getRandomProducer() {
            return this._randomProducer;
        }

        public void setRandomProducer(DatabusEventRandomProducer.Config randomProducer) {
            this._randomProducer = randomProducer;
        }

        public void setContainer(ServerContainer.Config container) {
            this._container = container;
            this._container.setRuntimeConfigPropertyPrefix("com.linkedin.databus.relay");
        }

        public SchemaRegistryConfigBuilder getSchemaRegistry() {
            return this._schemaRegistry;
        }

        public void setSourceName(String idStr, String name) {
            this._sourceName.put(idStr, name);
        }

        public String getSourceName(String idStr) {
            return this._sourceName.get(idStr);
        }

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public void setRuntime(RuntimeConfigBuilder runtime) {
            this._runtime = runtime;
        }

        public HttpStatisticsCollector.Config getHttpStatsCollector() {
            return this._httpStatsCollector;
        }

        public void setHttpStatsCollector(HttpStatisticsCollector.Config httpStatsCollector) {
            this._httpStatsCollector = httpStatsCollector;
        }

        public DbusEventsStatisticsCollector.Config getOutboundEventsStatsCollector() {
            return this._outboundEventsStatsCollector;
        }

        public void setOutboundEventsStatsCollector(DbusEventsStatisticsCollector.Config eventsStatsCollector) {
            this._outboundEventsStatsCollector = eventsStatsCollector;
        }

        public DbusEventsStatisticsCollector.Config getInboundEventsStatsCollector() {
            return this._inboundEventsStatsCollector;
        }

        public void setInboundEventsStatsCollector(DbusEventsStatisticsCollector.Config inboundEventsStatsCollector) {
            this._inboundEventsStatsCollector = inboundEventsStatsCollector;
        }

        public EventLogWriter.Config getEventLogWriter() {
            return this._eventLogWriter;
        }

        public void setEventLogWriter(EventLogWriter.Config eventLogWriterConfig) {
            this._eventLogWriter = eventLogWriterConfig;
        }

        public EventLogReader.Config getEventLogReader() {
            return this._eventLogReader;
        }

        public void setEventLogReader(EventLogReader.Config eventLogReader) {
            this._eventLogReader = eventLogReader;
        }

        public void setStartDbPuller(String startDbPuller) {
            this._startDbPuller = startDbPuller;
        }

        public String getStartDbPuller() {
            return this._startDbPuller;
        }

        public DataSourcesStaticConfigBuilder getDataSources() {
            return this._dataSources;
        }

        public PhysicalSourceConfig getPhysicalSourcesConfigs(int index) {
            while (this._physicalSourcesConfigs.size() <= index) {
                this._physicalSourcesConfigs.add(new PhysicalSourceConfig());
            }
            return this._physicalSourcesConfigs.get(index);
        }

        public void setPhysicalSourcesConfigs(int index, PhysicalSourceConfig conf) {
            while (this._physicalSourcesConfigs.size() <= index) {
                this._physicalSourcesConfigs.add(new PhysicalSourceConfig());
            }
            this._physicalSourcesConfigs.set(index, conf);
        }

        public String getPhysicalSourcesConfigsPattern() {
            return this._physicalSourcesConfigsPattern;
        }

        public void setPhysicalSourcesConfigsPattern(String physicalSourcesConfigsPattern) {
            this._physicalSourcesConfigsPattern = physicalSourcesConfigsPattern;
        }

        protected PhysicalSourceStaticConfig[] buildInitPhysicalSourcesConfigs() throws InvalidConfigException {
            Object[] sourcesConfigFiles = null;
            String physConfDirName = null;
            if (null != this._physicalSourcesConfigsPattern && this._physicalSourcesConfigsPattern.trim().length() > 0) {
                File patternFile = new File(this._physicalSourcesConfigsPattern);
                physConfDirName = patternFile.getParent();
                final String globPattern = patternFile.getName().replace(".", "\\.").replace("*", ".*").replace("?", ".");
                sourcesConfigFiles = patternFile.getParentFile().list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.matches(globPattern);
                    }
                });
                LOG.info((Object)("loading physical sources configs from: " + Arrays.toString(sourcesConfigFiles)));
            }
            int physConfigsSize = this._physicalSourcesConfigs.size();
            if (null != sourcesConfigFiles) {
                physConfigsSize += sourcesConfigFiles.length;
            }
            PhysicalSourceStaticConfig[] physConfigs = new PhysicalSourceStaticConfig[physConfigsSize];
            int physConfIdx = 0;
            for (PhysicalSourceConfig confBuilder : this._physicalSourcesConfigs) {
                physConfigs[physConfIdx++] = confBuilder.build();
            }
            if (null != sourcesConfigFiles) {
                PhysicalSourceConfigBuilder fileConfBuilder = new PhysicalSourceConfigBuilder(physConfDirName, (String[])sourcesConfigFiles);
                PhysicalSourceStaticConfig[] confsFromFiles = fileConfBuilder.build();
                System.arraycopy(confsFromFiles, 0, physConfigs, physConfIdx, confsFromFiles.length);
            }
            return physConfigs;
        }
    }

    public static class StaticConfig {
        private final ServerContainer.StaticConfig _containerConfig;
        private final DbusEventBuffer.StaticConfig _eventBufferConfig;
        private final SchemaRegistryStaticConfig _schemaRegistryConfig;
        private final List<IdNamePair> _sourceIds;
        private final RuntimeConfigBuilder _runtime;
        private final HttpStatisticsCollector.StaticConfig _httpStatsCollector;
        private final DatabusEventRandomProducer.StaticConfig _randomProducer;
        private final EventLogWriter.StaticConfig _eventLogWriterConfig;
        private final EventLogReader.StaticConfig _eventLogReaderConfig;
        private final boolean _startDbPuller;
        private final DataSourcesStaticConfig _dataSources;
        private final PhysicalSourceStaticConfig[] _physicalSourcesConfigs;

        public StaticConfig(DbusEventBuffer.StaticConfig eventBufferConfig, ServerContainer.StaticConfig containerConfig, SchemaRegistryStaticConfig schemaRegistryConfig, List<IdNamePair> sourceIds, RuntimeConfigBuilder runtime, HttpStatisticsCollector.StaticConfig httpStatsCollector, DbusEventsStatisticsCollector.StaticConfig inboundEventsStatsCollector, DbusEventsStatisticsCollector.StaticConfig outboundEventsStatsCollector, DatabusEventRandomProducer.StaticConfig randomProducer, EventLogWriter.StaticConfig eventLogWriterConfig, EventLogReader.StaticConfig eventLogReaderConfig, boolean startDbPuller, DataSourcesStaticConfig dataSources, PhysicalSourceStaticConfig[] physicalSourcesConfigs) {
            this._eventBufferConfig = eventBufferConfig;
            this._containerConfig = containerConfig;
            this._schemaRegistryConfig = schemaRegistryConfig;
            this._sourceIds = sourceIds;
            this._runtime = runtime;
            this._httpStatsCollector = httpStatsCollector;
            this._randomProducer = randomProducer;
            this._eventLogWriterConfig = eventLogWriterConfig;
            this._eventLogReaderConfig = eventLogReaderConfig;
            this._startDbPuller = startDbPuller;
            this._dataSources = dataSources;
            this._physicalSourcesConfigs = (PhysicalSourceStaticConfig[])physicalSourcesConfigs.clone();
        }

        public DbusEventBuffer.StaticConfig getEventBuffer() {
            return this._eventBufferConfig;
        }

        public DatabusEventRandomProducer.StaticConfig getRandomProducer() {
            return this._randomProducer;
        }

        public ServerContainer.StaticConfig getContainer() {
            return this._containerConfig;
        }

        public SchemaRegistryStaticConfig getSchemaRegistry() {
            return this._schemaRegistryConfig;
        }

        public List<IdNamePair> getSourceIds() {
            return this._sourceIds;
        }

        public RuntimeConfigBuilder getRuntime() {
            return this._runtime;
        }

        public HttpStatisticsCollector.StaticConfig getHttpStatsCollector() {
            return this._httpStatsCollector;
        }

        public EventLogWriter.StaticConfig getEventLogWriterConfig() {
            return this._eventLogWriterConfig;
        }

        public EventLogReader.StaticConfig getEventLogReaderConfig() {
            return this._eventLogReaderConfig;
        }

        public boolean getStartDbPuller() {
            return this._startDbPuller;
        }

        public DataSourcesStaticConfig getDataSources() {
            return this._dataSources;
        }

        public PhysicalSourceStaticConfig[] getPhysicalSourcesConfigs() {
            if (null == this._physicalSourcesConfigs) {
                return null;
            }
            return Arrays.copyOf(this._physicalSourcesConfigs, this._physicalSourcesConfigs.length);
        }
    }

    public static class RuntimeConfigBuilder
    implements ConfigBuilder<RuntimeConfig> {
        private final ServerContainer.RuntimeConfigBuilder _container;
        private HttpRelay _managedInstance = null;
        private HttpStatisticsCollector.RuntimeConfigBuilder _httpStatsCollector;

        public RuntimeConfigBuilder(ServerContainer.RuntimeConfigBuilder container) {
            this._container = container;
            this._httpStatsCollector = new HttpStatisticsCollector.RuntimeConfigBuilder();
        }

        public HttpRelay getManagedInstance() {
            return this._managedInstance;
        }

        public void setManagedInstance(HttpRelay managedInstance) {
            this._managedInstance = managedInstance;
            this._container.setManagedInstance((ServerContainer)managedInstance);
            this._httpStatsCollector.setManagedInstance(this._managedInstance.getHttpStatisticsCollector());
        }

        public ServerContainer.RuntimeConfigBuilder getContainer() {
            return this._container;
        }

        public RuntimeConfig build() throws InvalidConfigException {
            if (null == this._managedInstance) {
                throw new InvalidConfigException("Missing relay");
            }
            HttpRelay httpRelay = this._managedInstance;
            ((Object)((Object)httpRelay)).getClass();
            return httpRelay.new RuntimeConfig(this._container.build(), this._httpStatsCollector.build());
        }

        public HttpStatisticsCollector.RuntimeConfigBuilder getHttpStatsCollector() {
            return this._httpStatsCollector;
        }

        public void setHttpStatsCollector(HttpStatisticsCollector.RuntimeConfigBuilder httpStatsCollector) {
            this._httpStatsCollector = httpStatsCollector;
        }
    }

    public class RuntimeConfig
    implements ConfigApplier<RuntimeConfig> {
        private final ServerContainer.RuntimeConfig _container;
        private final HttpStatisticsCollector.RuntimeConfig _httpStatsCollector;

        public RuntimeConfig(ServerContainer.RuntimeConfig container, HttpStatisticsCollector.RuntimeConfig httpStatsCollector) {
            this._container = container;
            this._httpStatsCollector = httpStatsCollector;
        }

        public void applyNewConfig(RuntimeConfig oldConfig) {
            LOG.debug((Object)"Applying new relay config");
            if (null == oldConfig || !this.getContainer().equals((Object)oldConfig.getContainer())) {
                this._container.applyNewConfig(null != oldConfig ? oldConfig.getContainer() : null);
            }
            if (null == oldConfig || !this.getHttpStatsCollector().equals((Object)oldConfig.getHttpStatsCollector())) {
                this.getHttpStatsCollector().applyNewConfig(null != oldConfig ? oldConfig.getHttpStatsCollector() : null);
            }
        }

        public boolean equals(Object other) {
            if (null == other || !(other instanceof RuntimeConfig)) {
                return false;
            }
            if (this == other) {
                return true;
            }
            return this.equalsConfig((RuntimeConfig)other);
        }

        public boolean equalsConfig(RuntimeConfig otherConfig) {
            if (null == otherConfig) {
                return false;
            }
            return this.getContainer().equals((Object)otherConfig.getContainer()) && this.getHttpStatsCollector().equals((Object)otherConfig.getHttpStatsCollector());
        }

        public int hashCode() {
            return this._container.hashCode() ^ HttpRelay.this._httpStatisticsCollector.hashCode();
        }

        public ServerContainer.RuntimeConfig getContainer() {
            return this._container;
        }

        public HttpStatisticsCollector.RuntimeConfig getHttpStatsCollector() {
            return this._httpStatsCollector;
        }
    }

    public static class Cli
    extends ServerContainer.Cli {
        public static final char DB_RELAY_CONFIG_FILE_OPT_CHAR = 'Y';
        public static final String DB_RELAY_CONFIG_FILE_OPT_NAME = "db_relay_config";
        protected String[] _physicalSrcConfigFiles;
        protected PhysicalSourceStaticConfig[] _pStaticConfigs;
        protected Config _relayConfigBuilder;

        public Cli() {
            this("java " + HttpRelay.class.getName() + " [options]");
        }

        public Cli(String usage) {
            super(usage);
        }

        public String[] getPhysicalSrcConfigFiles() {
            if (null == this._physicalSrcConfigFiles) {
                return null;
            }
            return Arrays.copyOf(this._physicalSrcConfigFiles, this._physicalSrcConfigFiles.length);
        }

        public void processCommandLineArgs(String[] cliArgs) throws IOException, DatabusException {
            super.processCommandLineArgs(cliArgs);
            if (this._cmd.hasOption(DB_RELAY_CONFIG_FILE_OPT_NAME)) {
                String opt = this._cmd.getOptionValue(DB_RELAY_CONFIG_FILE_OPT_NAME);
                this._physicalSrcConfigFiles = opt.split(",");
                for (int i = 0; i < this._physicalSrcConfigFiles.length; ++i) {
                    this._physicalSrcConfigFiles[i] = this._physicalSrcConfigFiles[i].trim();
                }
                LOG.info((Object)("Physical Sources Config files = " + Arrays.toString(this._physicalSrcConfigFiles)));
            }
        }

        public void parseRelayConfig() throws IOException, InvalidConfigException {
            this._relayConfigBuilder = new Config();
            ConfigLoader staticConfigLoader = new ConfigLoader("databus.relay.", (ConfigBuilder)this._relayConfigBuilder);
            staticConfigLoader.loadConfig((Map)this.getConfigProps());
            if (null != this._physicalSrcConfigFiles && 0 < this._physicalSrcConfigFiles.length) {
                this.parsePhysicalSourceConfigs();
            }
        }

        private void parsePhysicalSourceConfigs() throws JsonParseException, JsonMappingException, IOException, InvalidConfigException {
            this._pStaticConfigs = new PhysicalSourceStaticConfig[this._physicalSrcConfigFiles.length];
            ObjectMapper mapper = new ObjectMapper();
            int i = 0;
            for (String file : this._physicalSrcConfigFiles) {
                LOG.info((Object)("processing file: " + file));
                File sourcesJson = new File(file);
                PhysicalSourceConfig pConfig = (PhysicalSourceConfig)mapper.readValue(sourcesJson, PhysicalSourceConfig.class);
                pConfig.checkForNulls();
                this._pStaticConfigs[i] = pConfig.build();
                for (LogicalSourceConfig lsc : pConfig.getSources()) {
                    this._relayConfigBuilder.setSourceName(Short.toString(lsc.getId()), lsc.getName());
                }
                ++i;
            }
        }

        protected void constructCommandLineOptions() {
            super.constructCommandLineOptions();
            OptionBuilder.withLongOpt((String)DB_RELAY_CONFIG_FILE_OPT_NAME);
            OptionBuilder.hasArg();
            OptionBuilder.hasArg();
            OptionBuilder.withArgName((String)"physical sources config File");
            Option physConfigOption = OptionBuilder.create((char)'Y');
            this._cliOptions.addOption(physConfigOption);
        }

        public PhysicalSourceStaticConfig[] getPhysicalSourceStaticConfigs() {
            return null == this._pStaticConfigs ? null : (PhysicalSourceStaticConfig[])this._pStaticConfigs.clone();
        }

        public Config getRelayConfigBuilder() {
            return this._relayConfigBuilder;
        }

        public void setDefaultPhysicalSrcConfigFiles(String ... physicalSrcConfigFiles) {
            this._physicalSrcConfigFiles = null == physicalSrcConfigFiles ? null : (String[])physicalSrcConfigFiles.clone();
        }
    }
}

