/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.ChannelFuture;

public class ChannelCloseFaultInjectionRequestProcessor
implements RequestProcessor {
    public static final String MODULE = ChannelCloseFaultInjectionRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final ExecutorService _executorService;
    private final HttpRelay _relay;

    public ChannelCloseFaultInjectionRequestProcessor(ExecutorService executorService, HttpRelay relay) {
        this._relay = relay;
        this._executorService = executorService;
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        LOG.debug((Object)"Waiting for raw channel to close");
        ChannelFuture future = request.getResponseContent().getRawChannel().close().awaitUninterruptibly();
        try {
            future.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        LOG.debug((Object)"Done waiting for raw channel to close");
        return request;
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }
}

