/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class FaultInjectionRequestProcessor
implements RequestProcessor {
    public static final String MODULE = FaultInjectionRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private final ExecutorService _executorService;
    private final HttpRelay _relay;
    private Map<String, RequestProcessor> _realProcessors;
    private Map<String, RequestProcessor> _fakeProcessors;
    private Set<String> _commandsToFake;
    public static final String USE_FAKE_COMMAND = "useFake";
    public static final String USE_REAL_COMMAND = "useReal";
    public static final String COMMAND_KEY_NAME = "cmd";

    public FaultInjectionRequestProcessor(ExecutorService executorService, HttpRelay relay) {
        this._relay = relay;
        this._executorService = executorService;
        this._realProcessors = new HashMap<String, RequestProcessor>();
        this._fakeProcessors = new HashMap<String, RequestProcessor>();
        this._commandsToFake = new HashSet<String>();
    }

    public void register(String command, RequestProcessor realProcessor, RequestProcessor fakeProcessor, boolean startFaking) {
        this._realProcessors.put(command, realProcessor);
        this._fakeProcessors.put(command, fakeProcessor);
        if (startFaking) {
            this.addCommandsToFake(command);
        }
    }

    public void addCommandsToFake(String command) {
        if (!this._fakeProcessors.containsKey(command)) {
            throw new RuntimeException("Command (" + command + ") cannot be faked as there is no fake processor set !!");
        }
        LOG.info((Object)("Command (" + command + ") to be faked !!"));
        this._commandsToFake.add(command);
    }

    public void removeFakeCommand(String command) {
        LOG.info((Object)("Command (" + command + ") will not be faked anymore !!"));
        this._commandsToFake.remove(USE_FAKE_COMMAND);
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException, DatabusException {
        String command = request.getName();
        if (command.equalsIgnoreCase(USE_FAKE_COMMAND)) {
            String cmd = request.getRequiredStringParam(COMMAND_KEY_NAME);
            this.addCommandsToFake(cmd);
            String result = "{ \"fake\": \"true\", \"command\" : \"" + cmd + "\", \"result\" : \"true\" }";
            request.getResponseContent().write(ByteBuffer.wrap(result.getBytes(Charset.defaultCharset())));
        } else if (command.equalsIgnoreCase(USE_REAL_COMMAND)) {
            String cmd = request.getRequiredStringParam(COMMAND_KEY_NAME);
            this.removeFakeCommand(cmd);
            String result = "{ \"fake\": \"false\", \"command\" : \"" + cmd + "\", \"result\" : \"true\" }";
            request.getResponseContent().write(ByteBuffer.wrap(result.getBytes(Charset.defaultCharset())));
        } else if (this._commandsToFake.contains(command)) {
            LOG.debug((Object)("Executing fake processor for command :(" + command + ")"));
            this._fakeProcessors.get(command).process(request);
        } else {
            LOG.debug((Object)("Executing real processor for command :(" + command + ")"));
            this._realProcessors.get(command).process(request);
        }
        return request;
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }
}

