/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.data_model.LogicalSource;
import com.linkedin.databus.core.monitoring.mbean.DbusEventsStatisticsCollector;
import com.linkedin.databus.core.monitoring.mbean.StatsCollectorMergeable;
import com.linkedin.databus.core.util.DatabusEventProducer;
import com.linkedin.databus.core.util.IdNamePair;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class GenerateDataEventsRequestProcessor
implements RequestProcessor {
    public static final String MODULE = GenerateDataEventsRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "genDataEvents";
    public static final String SOURCES_NAME_PARAM = "src_ids";
    public static final String SCN_PARAM = "fromScn";
    public static final String EVENTS_PER_SEC_PARAM = "eventsPerSec";
    public static final String DURATION_MS = "duration";
    public static final String NUM_EVENTS_TO_GENERATE = "eventsToGenerate";
    public static final String PERCENT_BUFFER_TO_GENERATE = "percentBuffer";
    public static final String KEY_MIN_PARAM = "keyMin";
    public static final String KEY_MAX_PARAM = "keyMax";
    private final ExecutorService _executorService;
    private final HttpRelay _relay;
    private final DbusEventsStatisticsCollector _relayStatsCollector;
    private final DatabusEventProducer _producer;

    public GenerateDataEventsRequestProcessor(ExecutorService executorService, HttpRelay relay, DatabusEventProducer eventProducer) {
        this._executorService = executorService;
        this._relay = relay;
        this._producer = eventProducer;
        this._relayStatsCollector = new DbusEventsStatisticsCollector(this._relay.getContainerStaticConfig().getId(), this._producer.toString(), true, false, this._relay.getMbeanServer());
        this._relay.getInBoundStatsCollectors().addStatsCollector("GenerateDataEventsRequestProcessor", (StatsCollectorMergeable)this._relayStatsCollector);
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        String action = request.getParams().getProperty("reqpath", "");
        if (action.equals("check")) {
            boolean genRunning = this._producer.checkRunning();
            StringBuilder resBuilder = new StringBuilder(1024);
            Formatter fmt = new Formatter(resBuilder);
            fmt.format("{\"genDataEventsRunning\":\"%b\"}", genRunning);
            request.getResponseContent().write(ByteBuffer.wrap(resBuilder.toString().getBytes(Charset.defaultCharset())));
        } else if (action.equals("stop")) {
            this._producer.stopGeneration();
            request.getResponseContent().write(ByteBuffer.wrap("{\"genDataEventsRunning\":\"send-stop\"}".getBytes(Charset.defaultCharset())));
        } else if (action.equals("suspend")) {
            this._producer.suspendGeneration();
            request.getResponseContent().write(ByteBuffer.wrap("{\"genDataEventsRunning\":\"send-suspend\"}".getBytes(Charset.defaultCharset())));
        } else if (action.equals("resume")) {
            long numEventToGenerate = request.getOptionalLongParam(NUM_EVENTS_TO_GENERATE, Long.MAX_VALUE);
            long keyMin = request.getOptionalLongParam(KEY_MIN_PARAM, 0L);
            long keyMax = request.getOptionalLongParam(KEY_MAX_PARAM, Long.MAX_VALUE);
            int percentOfBufferToGenerate = request.getOptionalIntParam(PERCENT_BUFFER_TO_GENERATE, Integer.MAX_VALUE);
            this._producer.resumeGeneration(numEventToGenerate, percentOfBufferToGenerate, keyMin, keyMax);
            request.getResponseContent().write(ByteBuffer.wrap("{\"genDataEventsRunning\":\"send-resume\"}".getBytes(Charset.defaultCharset())));
        } else if (action.equals("start")) {
            long fromScn = request.getRequiredLongParam(SCN_PARAM);
            long durationMs = request.getRequiredLongParam(DURATION_MS);
            int eventsPerSec = request.getRequiredIntParam(EVENTS_PER_SEC_PARAM);
            long numEventToGenerate = request.getOptionalLongParam(NUM_EVENTS_TO_GENERATE, Long.MAX_VALUE);
            int percentOfBufferToGenerate = request.getOptionalIntParam(PERCENT_BUFFER_TO_GENERATE, Integer.MAX_VALUE);
            long keyMin = request.getOptionalLongParam(KEY_MIN_PARAM, 0L);
            long keyMax = request.getOptionalLongParam(KEY_MAX_PARAM, Long.MAX_VALUE);
            String sourcesListStr = request.getRequiredStringParam(SOURCES_NAME_PARAM);
            String[] sourcesStrArray = sourcesListStr.split(",");
            ArrayList<IdNamePair> sourcesIdList = new ArrayList<IdNamePair>(sourcesStrArray.length);
            for (String sourceIdStr : sourcesStrArray) {
                try {
                    Integer id = Integer.valueOf(sourceIdStr);
                    LogicalSource source = this._relay.getSourcesIdNameRegistry().getSource(id);
                    if (null != source) {
                        sourcesIdList.add(source.asIdNamePair());
                        continue;
                    }
                    LOG.error((Object)("unable to find source id: " + id));
                }
                catch (NumberFormatException nfe) {
                    throw new InvalidRequestParamValueException(COMMAND_NAME, SOURCES_NAME_PARAM, sourceIdStr);
                }
            }
            boolean tryStart = this._producer.startGeneration(fromScn, eventsPerSec, durationMs, numEventToGenerate, percentOfBufferToGenerate, keyMin, keyMax, sourcesIdList, this._relayStatsCollector);
            StringBuilder resBuilder = new StringBuilder(1024);
            Formatter fmt = new Formatter(resBuilder);
            fmt.format("{\"genDataEventsStarted\":\"%b\"}", tryStart);
            request.getResponseContent().write(ByteBuffer.wrap(resBuilder.toString().getBytes(Charset.defaultCharset())));
        } else {
            throw new InvalidRequestParamValueException(COMMAND_NAME, "request path", action);
        }
        return request;
    }
}

