/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import com.linkedin.databus2.producers.db.OracleTxlogEventReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;

public class OracleProducerTestRequestProcessor
implements RequestProcessor {
    public static final String MODULE = OracleProducerTestRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private OracleTxlogEventReader _producer = null;
    private ExecutorService _service = null;
    public static final String RESET_CATCHUPSCN_COMMAND = "resetCatchupScn";
    public static final String COMMAND_NAME = "testOracleProducer";

    public OracleProducerTestRequestProcessor(OracleTxlogEventReader producer, ExecutorService service) {
        this._producer = producer;
        this._service = service;
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException, DatabusException {
        String command = request.getParams().getProperty("reqpath", "");
        if (!command.equalsIgnoreCase(RESET_CATCHUPSCN_COMMAND)) {
            throw new DatabusException("Unknown command :" + command);
        }
        LOG.info((Object)"Resetting Catchup Target Max Scn !!");
        this._producer.setCatchupTargetMaxScn(-1L);
        String result = "{ \"command\" : \"" + command + "\", \"result\" : \"true\" }";
        request.getResponseContent().write(ByteBuffer.wrap(result.getBytes(Charset.defaultCharset())));
        return request;
    }

    public ExecutorService getExecutorService() {
        return this._service;
    }
}

