/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.container.request.SourcesRequestProcessor;
import com.linkedin.databus.core.DbusEventBufferMult;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.NavigableSet;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.ObjectWriter;

public class PhysicalBuffersRequestProcessor
implements RequestProcessor {
    public static final String MODULE = SourcesRequestProcessor.class.getName();
    public static Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "physicalBuffers";
    private final ExecutorService _executorService;
    private final HttpRelay _relay;

    public PhysicalBuffersRequestProcessor(ExecutorService executorService, HttpRelay relay) {
        this._executorService = executorService;
        this._relay = relay;
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        boolean pretty = request.getParams().getProperty("pretty") != null;
        ObjectWriter writer = pretty ? mapper.defaultPrettyPrintingWriter() : mapper.writer();
        StringWriter out = new StringWriter(10240);
        DbusEventBufferMult multBuf = this._relay.getEventBuffer();
        NavigableSet keys = multBuf.getAllPhysicalPartitionKeys();
        HashMap<PhysicalPartition, Set> map = new HashMap<PhysicalPartition, Set>(keys.size());
        for (DbusEventBufferMult.PhysicalPartitionKey key : keys) {
            Set set = multBuf.getPhysicalSourcesForPartition(key.getPhysicalPartition());
            map.put(key.getPhysicalPartition(), set);
        }
        if (keys.isEmpty()) {
            writer.writeValue((Writer)out, new HashSet());
        } else {
            writer.writeValue((Writer)out, map);
        }
        byte[] resultBytes = out.toString().getBytes(Charset.defaultCharset());
        request.getResponseContent().write(ByteBuffer.wrap(resultBytes));
        return request;
    }
}

