/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.container.request.SourcesRequestProcessor;
import com.linkedin.databus2.core.container.monitoring.mbean.HttpStatisticsCollector;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.core.container.request.RequestProcessor;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.codehaus.jackson.map.ObjectMapper;

public class PhysicalSourcesRequestProcessor
implements RequestProcessor {
    public static final String MODULE = SourcesRequestProcessor.class.getName();
    public static Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "physicalSources";
    private final ExecutorService _executorService;
    private final HttpRelay _relay;

    public PhysicalSourcesRequestProcessor(ExecutorService executorService, HttpRelay relay) {
        this._executorService = executorService;
        this._relay = relay;
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        StringWriter out = new StringWriter(10240);
        List<PhysicalSourceStaticConfig> sources = this._relay.getPhysicalSources();
        if (sources.isEmpty()) {
            mapper.writeValue((Writer)out, new ArrayList());
        } else {
            mapper.writeValue((Writer)out, sources);
        }
        byte[] resultBytes = out.toString().getBytes(Charset.defaultCharset());
        request.getResponseContent().write(ByteBuffer.wrap(resultBytes));
        HttpStatisticsCollector relayStatsCollector = this._relay.getHttpStatisticsCollector();
        if (null != relayStatsCollector) {
            HttpStatisticsCollector connStatsCollector = (HttpStatisticsCollector)request.getParams().get(relayStatsCollector.getName());
            if (null != connStatsCollector) {
                connStatsCollector.registerSourcesCall();
            } else {
                relayStatsCollector.registerSourcesCall();
            }
        }
        return request;
    }
}

