/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.data_model.PhysicalPartition;
import com.linkedin.databus2.core.BufferNotFoundException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.core.container.request.AbstractRequestProcesser;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.jboss.netty.channel.Channel;

public class RelayCommandRequestProcessor
extends AbstractRequestProcesser {
    public static final Logger LOG = Logger.getLogger(RelayCommandRequestProcessor.class);
    public static final String COMMAND_NAME = "relayCommand";
    public static final String SAVE_META_STATE_PARAM = "saveMetaInfo";
    public static final String SHUTDOWN_RELAY_PARAM = "shutdownRelay";
    public static final String VALIDATE_RELAY_BUFFER_PARAM = "validateRelayBuffer";
    public static final String RUN_GC_PARAM = "runGC";
    public static final String RESET_RELAY_BUFFER_PARAM = "resetRelayBuffer";
    public static final String PREV_SCN_PARAM = "prevScn";
    public static final String BINLOG_OFFSET_PARAM = "binlogOffset";
    public static final String GET_BINLOG_OFFSET_PARAM = "getLastEventBinlogOffset";
    public static final String PRINT_RELAY_INFO_PARAM = "printRelayInfo";
    public static final String DISCONNECT_CLIENTS = "disconnectClients";
    private final HttpRelay _relay;
    private final ExecutorService _executorService;

    public RelayCommandRequestProcessor(ExecutorService executorService, HttpRelay relay) {
        this._executorService = executorService;
        this._relay = relay;
    }

    public ExecutorService getExecutorService() {
        return this._executorService;
    }

    public DatabusRequest process(DatabusRequest request) throws IOException, RequestProcessingException {
        String command = request.getParams().getProperty("reqpath");
        if (null == command) {
            throw new InvalidRequestParamValueException(COMMAND_NAME, "command", "null");
        }
        String reply = "Command " + command + " completed ";
        LOG.info((Object)("got relayCommand = " + command));
        if (command.equals(SAVE_META_STATE_PARAM)) {
            this._relay.saveBufferMetaInfo(true);
        } else if (command.equals(SHUTDOWN_RELAY_PARAM)) {
            String msg = "received shutdown curl request from: " + request.getRemoteAddress() + ". Shutting down\n";
            LOG.warn((Object)msg);
            request.getResponseContent().write(ByteBuffer.wrap(msg.getBytes("UTF-8")));
            request.getResponseContent().close();
            this._relay.shutdown();
        } else if (command.equals(VALIDATE_RELAY_BUFFER_PARAM)) {
            this._relay.validateRelayBuffers();
        } else if (command.equals(DISCONNECT_CLIENTS)) {
            Channel rspChannel = request.getResponseContent().getRawChannel();
            this._relay.disconnectDBusClients(rspChannel);
        } else if (command.equals(RUN_GC_PARAM)) {
            Runtime rt = Runtime.getRuntime();
            long mem = rt.freeMemory();
            LOG.info((Object)("mem before gc = " + rt.freeMemory() + " out of " + rt.totalMemory()));
            long time = System.currentTimeMillis();
            System.gc();
            time = System.currentTimeMillis() - time;
            mem = rt.freeMemory() - mem;
            reply = new String("GC run. Took " + time + " millsecs. Freed " + mem + " bytes out of " + rt.totalMemory());
        } else if (command.startsWith(RESET_RELAY_BUFFER_PARAM)) {
            String[] resetCommands = command.split("/");
            if (resetCommands.length != 3) {
                throw new InvalidRequestParamValueException(COMMAND_NAME, "command", command);
            }
            String dbName = resetCommands[1];
            String dbPart = resetCommands[2];
            long prevScn = request.getRequiredLongParam(PREV_SCN_PARAM);
            long binlogOffset = request.getOptionalLongParam(BINLOG_OFFSET_PARAM, 0L);
            LOG.info((Object)("reset command = " + dbName + " part =" + dbPart));
            try {
                this._relay.resetBuffer(new PhysicalPartition(Integer.valueOf(Integer.parseInt(dbPart)), dbName), prevScn, binlogOffset);
            }
            catch (BufferNotFoundException e) {
                reply = new String("command " + command + ":" + e.getMessage());
            }
        } else if (command.startsWith(GET_BINLOG_OFFSET_PARAM)) {
            String[] getOfsArgs = command.split("/");
            if (getOfsArgs.length != 2) {
                throw new InvalidRequestParamValueException(GET_BINLOG_OFFSET_PARAM, "Server ID", "");
            }
            try {
                int serverId = Integer.parseInt(getOfsArgs[1]);
                int[] offset = this._relay.getBinlogOffset(serverId);
                if (offset.length != 2) {
                    reply = "Error getting binlog offset";
                }
                reply = new String("RelayLastEvent(" + offset[0] + "," + offset[1] + ")");
            }
            catch (NumberFormatException e) {
                throw new InvalidRequestParamValueException(GET_BINLOG_OFFSET_PARAM, "Server ID", getOfsArgs[1]);
            }
            catch (DatabusException e) {
                reply = new String("command " + command + "failed with:" + e.getMessage());
            }
        } else if (command.startsWith(PRINT_RELAY_INFO_PARAM)) {
            try {
                Map<String, String> infoMap = this._relay.printInfo();
                reply = this.makeJsonResponse(infoMap, request);
            }
            catch (Exception e) {
                reply = new String("command " + command + " failed with:" + e.getMessage());
            }
        } else {
            reply = new String("command " + command + " is invalid. Valid commands are: " + SAVE_META_STATE_PARAM + "|" + SHUTDOWN_RELAY_PARAM + "|" + VALIDATE_RELAY_BUFFER_PARAM + "|" + RUN_GC_PARAM + "|" + RESET_RELAY_BUFFER_PARAM + "|" + GET_BINLOG_OFFSET_PARAM + "|" + PRINT_RELAY_INFO_PARAM + "|" + DISCONNECT_CLIENTS);
        }
        byte[] responseBytes = new byte[reply.length() + 2];
        System.arraycopy(reply.getBytes("UTF-8"), 0, responseBytes, 0, reply.length());
        int idx = reply.length();
        responseBytes[idx] = 13;
        responseBytes[idx + 1] = 10;
        request.getResponseContent().write(ByteBuffer.wrap(responseBytes));
        return request;
    }
}

