/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.container.request;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.monitoring.mbean.DatabusMonitoringMBean;
import com.linkedin.databus.monitoring.mbean.GGParserStatistics;
import com.linkedin.databus2.core.container.monitoring.mbean.DbusHttpTotalStats;
import com.linkedin.databus2.core.container.request.AbstractStatsRequestProcessor;
import com.linkedin.databus2.core.container.request.DatabusRequest;
import com.linkedin.databus2.core.container.request.InvalidRequestParamValueException;
import com.linkedin.databus2.core.container.request.RequestProcessingException;
import com.linkedin.databus2.producers.EventProducer;
import com.linkedin.databus2.relay.DatabusRelayMain;
import com.linkedin.databus2.relay.GoldenGateEventProducer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.log4j.Logger;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class RelayStatsRequestProcessor
extends AbstractStatsRequestProcessor {
    public static final String MODULE = RelayStatsRequestProcessor.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String COMMAND_NAME = "relayStats";
    private static final String OUTBOUND_HTTP_TOTAL_KEY = "outbound/http/total";
    private static final String OUTBOUND_HTTP_SOURCES_KEY = "outbound/http/sources";
    private static final String OUTBOUND_HTTP_SOURCE_PREFIX = "outbound/http/source/";
    private static final String OUTBOUND_HTTP_CLIENTS_KEY = "outbound/http/clients";
    private static final String OUTBOUND_HTTP_CLIENT_PREFIX = "outbound/http/client/";
    private static final String INBOUND_GG_PSOURCES_PREFIX = "inbound/gg/psources/";
    private static final String INBOUND_GG_PSOURCE_PREFIX = "inbound/gg/psource/";
    private final HttpRelay _relay;

    public RelayStatsRequestProcessor(ExecutorService executorService, HttpRelay relay) {
        super(COMMAND_NAME, executorService);
        this._relay = relay;
    }

    public boolean doProcess(String category, DatabusRequest request) throws IOException, RequestProcessingException {
        boolean success = true;
        if (category.equals(OUTBOUND_HTTP_TOTAL_KEY)) {
            this.processOutboundHttpTotalStats(request);
        } else if (category.equals(OUTBOUND_HTTP_SOURCES_KEY)) {
            this.processOutboundHttpSourcesList(request);
        } else if (category.startsWith(OUTBOUND_HTTP_SOURCE_PREFIX)) {
            this.processOutboundHttpSourceStats(request);
        } else if (category.equals(OUTBOUND_HTTP_CLIENTS_KEY)) {
            this.processOutboundHttpClientsList(request);
        } else if (category.startsWith(OUTBOUND_HTTP_CLIENT_PREFIX)) {
            this.processOutboundHttpClientStats(request);
        } else if (category.startsWith(INBOUND_GG_PSOURCES_PREFIX)) {
            this.processInboundGGStats(request, category);
        } else if (category.startsWith(INBOUND_GG_PSOURCE_PREFIX)) {
            this.processInboundGGStats(request, category);
        } else {
            success = false;
        }
        return success;
    }

    private void processInboundGGStats(DatabusRequest request, String category) throws IOException, RequestProcessingException {
        if (!(this._relay instanceof DatabusRelayMain)) {
            throw new IllegalArgumentException(category + " for relay which is not DatabusRelayMain");
        }
        String psourceName = null;
        if (category.startsWith(INBOUND_GG_PSOURCE_PREFIX)) {
            psourceName = category.substring(INBOUND_GG_PSOURCE_PREFIX.length());
            if (psourceName == null || psourceName.length() <= 0) {
                throw new InvalidRequestParamValueException(request.getName(), INBOUND_GG_PSOURCE_PREFIX, null);
            }
            LOG.info((Object)("get parser stats for source " + psourceName));
        }
        ArrayList<String> phSourceNames = new ArrayList<String>();
        EventProducer[] prods = ((DatabusRelayMain)this._relay).getProducers();
        GGParserStatistics stat = null;
        for (EventProducer prod : prods) {
            if (prod == null || !(prod instanceof GoldenGateEventProducer)) continue;
            GoldenGateEventProducer ggProducer = (GoldenGateEventProducer)prod;
            String pSrcName = ggProducer.getParserStats().getPhysicalSourceName();
            phSourceNames.add(pSrcName);
            if (psourceName == null || !psourceName.equals(pSrcName)) continue;
            stat = ggProducer.getParserStats();
        }
        if (psourceName != null) {
            if (stat == null) {
                throw new InvalidRequestParamValueException(request.getName(), INBOUND_GG_PSOURCE_PREFIX, psourceName);
            }
            this.writeJsonObjectToResponse(stat, request);
        } else {
            this.writeJsonObjectToResponse(phSourceNames, request);
        }
    }

    private void processOutboundHttpTotalStats(DatabusRequest request) throws IOException {
        DbusHttpTotalStats totalStats = this._relay.getHttpStatisticsCollector().getTotalStats();
        if (null == totalStats) {
            return;
        }
        this.writeJsonObjectToResponse(totalStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)totalStats, request);
        }
    }

    private void processOutboundHttpSourcesList(DatabusRequest request) throws IOException {
        List sourcesList = this._relay.getHttpStatisticsCollector().getSources();
        this.writeJsonObjectToResponse(sourcesList, request);
    }

    private void processOutboundHttpClientsList(DatabusRequest request) throws IOException {
        List clientsList = this._relay.getHttpStatisticsCollector().getPeers();
        this.writeJsonObjectToResponse(clientsList, request);
    }

    private void processOutboundHttpSourceStats(DatabusRequest request) throws IOException, RequestProcessingException {
        String category = request.getParams().getProperty("reqpath");
        String sourceIdStr = category.substring(OUTBOUND_HTTP_SOURCE_PREFIX.length());
        int sourceId = -1;
        try {
            sourceId = Integer.valueOf(sourceIdStr);
        }
        catch (NumberFormatException nfe) {
            throw new InvalidRequestParamValueException(request.getName(), OUTBOUND_HTTP_SOURCE_PREFIX, sourceIdStr);
        }
        DbusHttpTotalStats sourceStats = this._relay.getHttpStatisticsCollector().getSourceStats(sourceId);
        if (null == sourceStats) {
            throw new InvalidRequestParamValueException(request.getName(), OUTBOUND_HTTP_SOURCE_PREFIX, sourceIdStr);
        }
        this.writeJsonObjectToResponse(sourceStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)sourceStats, request);
        }
    }

    private void processOutboundHttpClientStats(DatabusRequest request) throws IOException, RequestProcessingException {
        String category = request.getParams().getProperty("reqpath");
        String client = category.substring(OUTBOUND_HTTP_CLIENT_PREFIX.length());
        DbusHttpTotalStats clientStats = this._relay.getHttpStatisticsCollector().getPeerStats(client);
        if (null == clientStats) {
            throw new InvalidRequestParamValueException(request.getName(), OUTBOUND_HTTP_CLIENT_PREFIX, client);
        }
        this.writeJsonObjectToResponse(clientStats, request);
        if (request.getRequestType() == HttpMethod.PUT || request.getRequestType() == HttpMethod.POST) {
            this.enableOrResetStatsMBean((DatabusMonitoringMBean)clientStats, request);
        }
    }
}

