/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.core.util;

import com.linkedin.databus.core.util.ConfigBuilder;
import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.relay.config.PhysicalSourceConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import java.io.File;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.codehaus.jackson.JsonParseException;
import org.codehaus.jackson.map.JsonMappingException;
import org.codehaus.jackson.map.ObjectMapper;

public class PhysicalSourceConfigBuilder
implements ConfigBuilder<PhysicalSourceStaticConfig[]> {
    private static final Logger LOG = Logger.getLogger((String)PhysicalSourceConfigBuilder.class.getName());
    File[] _fileNames = null;

    public PhysicalSourceConfigBuilder(String[] fileNames) {
        this._fileNames = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            this._fileNames[i] = new File(fileNames[i]);
        }
    }

    public PhysicalSourceConfigBuilder(String baseDir, String[] fileNames) {
        this._fileNames = new File[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            this._fileNames[i] = new File(baseDir, fileNames[i]);
        }
    }

    public PhysicalSourceStaticConfig[] build() throws InvalidConfigException {
        ObjectMapper mapper = new ObjectMapper();
        PhysicalSourceStaticConfig[] list = new PhysicalSourceStaticConfig[null == this._fileNames ? 0 : this._fileNames.length];
        if (this._fileNames == null) {
            return list;
        }
        for (int i = 0; i < this._fileNames.length; ++i) {
            File sourceJson = this._fileNames[i];
            PhysicalSourceConfig pConfig = null;
            Throwable e = null;
            try {
                pConfig = (PhysicalSourceConfig)mapper.readValue(sourceJson, PhysicalSourceConfig.class);
            }
            catch (JsonParseException jpe) {
                e = jpe;
            }
            catch (JsonMappingException jme) {
                e = jme;
            }
            catch (IOException ioe) {
                e = ioe;
            }
            if (e != null || pConfig == null) {
                throw new InvalidConfigException(e);
            }
            pConfig.checkForNulls();
            LOG.info((Object)("Generated Physical source config: name= " + pConfig.getId()));
            list[i] = pConfig.build();
        }
        return list;
    }
}

