/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.monitoring.mbean;

import com.linkedin.databus.monitoring.mbean.DBStatisticsMBean;
import com.linkedin.databus.monitoring.mbean.SourceDBStatistics;
import com.linkedin.databus.monitoring.mbean.SourceDBStatisticsMBean;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class DBStatistics
implements DBStatisticsMBean {
    private final String _name;
    private long _scn;
    private long _lastUpdateTimestamp;
    private final HashMap<String, SourceDBStatistics> _perSourceStats;
    private final Logger _log = Logger.getLogger(this.getClass());

    public DBStatistics(String name) {
        this._name = name;
        this._perSourceStats = new HashMap(100);
        this._lastUpdateTimestamp = 0L;
        this.reset();
    }

    @Override
    public String getDBSourceName() {
        return this._name;
    }

    public synchronized void setMaxDBScn(long s) {
        this._scn = s;
        this._lastUpdateTimestamp = System.currentTimeMillis();
    }

    @Override
    public synchronized long getMaxDBScn() {
        return this._scn;
    }

    public synchronized void addSrcStats(SourceDBStatistics srcStats) {
        this._perSourceStats.put(srcStats.getSourceName(), srcStats);
    }

    public synchronized void setSrcMaxScn(String srcName, long maxScn) {
        SourceDBStatistics stats;
        if (this._perSourceStats.containsKey(srcName) && null != (stats = this._perSourceStats.get(srcName))) {
            stats.setMaxScn(maxScn);
        }
    }

    public synchronized boolean registerAsMbean(MBeanServer mbeanServer, boolean register) {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("type", "DBStatistics");
            props.put("name", this.getDBSourceName());
            ObjectName objectName = new ObjectName("com.linkedin.databus2", props);
            if (mbeanServer.isRegistered(objectName)) {
                this._log.warn((Object)("Unregistering old DB Statistics  mbean: " + objectName));
                mbeanServer.unregisterMBean(objectName);
            }
            if (register) {
                mbeanServer.registerMBean(this, objectName);
                this._log.info((Object)("Registered DB statistics statistics mbean: " + objectName));
            }
            for (Map.Entry<String, SourceDBStatistics> pairs : this._perSourceStats.entrySet()) {
                SourceDBStatistics stats = pairs.getValue();
                if (null == stats) continue;
                if (register) {
                    stats.registerAsMbean(mbeanServer);
                    continue;
                }
                stats.unregisterAsMbean(mbeanServer);
            }
        }
        catch (Exception ex) {
            if (register) {
                this._log.error((Object)("Failed to register Mbean:" + this.getDBSourceName()), (Throwable)ex);
            } else {
                this._log.error((Object)("Failed to unregister Mbean:" + this.getDBSourceName()), (Throwable)ex);
            }
            return false;
        }
        return true;
    }

    public synchronized boolean registerAsMbean(MBeanServer mbeanServer) {
        return this.registerAsMbean(mbeanServer, true);
    }

    public synchronized boolean unregisterAsMbean(MBeanServer mbeanServer) {
        return this.registerAsMbean(mbeanServer, false);
    }

    @Override
    public synchronized SourceDBStatisticsMBean getPerSourceStatistics(String name) {
        return this._perSourceStats.get(name);
    }

    @Override
    public synchronized void reset() {
        this._scn = -1L;
        this._lastUpdateTimestamp = 0L;
        for (Map.Entry<String, SourceDBStatistics> pairs : this._perSourceStats.entrySet()) {
            SourceDBStatisticsMBean stats = pairs.getValue();
            if (null == stats) continue;
            stats.reset();
        }
    }

    @Override
    public synchronized long getTimeSinceLastUpdate() {
        return System.currentTimeMillis() - this._lastUpdateTimestamp;
    }
}

