/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.monitoring.mbean;

import com.linkedin.databus.core.monitoring.mbean.AbstractMonitoringMBean;
import com.linkedin.databus.monitoring.events.DbusDbSourceConnectionStatsEvent;
import com.linkedin.databus.monitoring.mbean.DbusDbSourceConnectionStatsMBean;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.concurrent.locks.Lock;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.log4j.Logger;

public class DbusDbSourceConnectionStats
extends AbstractMonitoringMBean<DbusDbSourceConnectionStatsEvent>
implements DbusDbSourceConnectionStatsMBean {
    public static final String MODULE = DbusDbSourceConnectionStats.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public DbusDbSourceConnectionStats(int relayId, boolean enabled, boolean threadSafe, DbusDbSourceConnectionStatsEvent initData) {
        super(enabled, threadSafe, (Object)initData);
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).relayId = relayId;
        this.reset();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumClosedDbConns() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numClosedDbConns;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumOpenDbConns() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numOpenDbConns;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getNumRowsUpdated() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numRowsUpdated;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeClosedDbConnLifeMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeClosedDbConnLifeMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimeOpenDbConnLifeMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeOpenDbConnLifeMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimestampLastDbConnCloseMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnCloseMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getTimestampLastDbConnOpenMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnOpenMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimeSinceLastResetMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeSinceLastResetMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTimestampLastResetMs() {
        Lock readLock = this.acquireReadLock();
        try {
            long l = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastResetMs;
            return l;
        }
        finally {
            this.releaseLock(readLock);
        }
    }

    public JsonEncoder createJsonEncoder(OutputStream out) throws IOException {
        return new JsonEncoder(((DbusDbSourceConnectionStatsEvent)((Object)this._event)).getSchema(), out);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDbConnClose(long timestamp, long lifespan) {
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numClosedDbConns;
            --((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numOpenDbConns;
            ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeClosedDbConnLifeMs += lifespan;
            ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnCloseMs = Math.max(((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnCloseMs, timestamp);
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDbConnOpen(long timestamp) {
        Lock writeLock = this.acquireWriteLock();
        try {
            ++((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numOpenDbConns;
            ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnOpenMs = Math.max(((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnOpenMs, timestamp);
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerDbRowsRead(int num) {
        Lock writeLock = this.acquireWriteLock();
        try {
            ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numRowsUpdated += (long)num;
        }
        finally {
            this.releaseLock(writeLock);
        }
    }

    protected void cloneData(DbusDbSourceConnectionStatsEvent event) {
        event.relayId = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).relayId;
        event.timestampLastResetMs = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastResetMs;
        event.timeSinceLastResetMs = System.currentTimeMillis() - ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastResetMs;
        event.numClosedDbConns = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numClosedDbConns;
        event.numOpenDbConns = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numOpenDbConns;
        event.numRowsUpdated = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numRowsUpdated;
        event.timeClosedDbConnLifeMs = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeClosedDbConnLifeMs;
        event.timeOpenDbConnLifeMs = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeOpenDbConnLifeMs;
        event.timestampLastDbConnCloseMs = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnCloseMs;
        event.timestampLastDbConnOpenMs = ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnOpenMs;
    }

    protected void doMergeStats(Object eventData) {
        if (!(eventData instanceof DbusDbSourceConnectionStatsEvent)) {
            LOG.warn((Object)("Attempt to merge unknown event class" + eventData.getClass().getName()));
            return;
        }
        DbusDbSourceConnectionStatsEvent e = (DbusDbSourceConnectionStatsEvent)((Object)eventData);
        if (((DbusDbSourceConnectionStatsEvent)((Object)this._event)).relayId > 0 && e.relayId != ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).relayId) {
            LOG.warn((Object)("Attempt to data for a different relay " + e.relayId));
            return;
        }
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numClosedDbConns += e.numClosedDbConns;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numOpenDbConns += e.numOpenDbConns;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numRowsUpdated += e.numRowsUpdated;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeClosedDbConnLifeMs += e.timeClosedDbConnLifeMs;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeOpenDbConnLifeMs += e.timeOpenDbConnLifeMs;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnCloseMs = Math.max(((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnCloseMs, e.timestampLastDbConnCloseMs);
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnOpenMs = Math.max(((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnOpenMs, e.timestampLastDbConnOpenMs);
    }

    protected SpecificDatumWriter<DbusDbSourceConnectionStatsEvent> getAvroWriter() {
        return new SpecificDatumWriter(DbusDbSourceConnectionStatsEvent.class);
    }

    protected DbusDbSourceConnectionStatsEvent newDataEvent() {
        return new DbusDbSourceConnectionStatsEvent();
    }

    protected void resetData() {
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastResetMs = System.currentTimeMillis();
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeSinceLastResetMs = 0L;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numClosedDbConns = 0L;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numOpenDbConns = 0L;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).numRowsUpdated = 0L;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeClosedDbConnLifeMs = 0L;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timeOpenDbConnLifeMs = 0L;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnCloseMs = 0L;
        ((DbusDbSourceConnectionStatsEvent)((Object)this._event)).timestampLastDbConnOpenMs = 0L;
    }

    public ObjectName generateObjectName() throws MalformedObjectNameException {
        Hashtable mbeanProps = this.generateBaseMBeanProps();
        mbeanProps.put("relayId", Integer.toString(((DbusDbSourceConnectionStatsEvent)((Object)this._event)).relayId));
        return new ObjectName("com.linkedin.databus2", mbeanProps);
    }
}

