/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus.monitoring.mbean;

import com.linkedin.databus.monitoring.mbean.SourceDBStatisticsMBean;
import java.util.Hashtable;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.apache.log4j.Logger;

public class SourceDBStatistics
implements SourceDBStatisticsMBean {
    private final String _name;
    private long _scn;
    private long _lastUpdateTimestamp;
    private final Logger _log = Logger.getLogger(this.getClass());

    public SourceDBStatistics(String name) {
        this._name = name;
        this._lastUpdateTimestamp = 0L;
        this.reset();
    }

    @Override
    public String getSourceName() {
        return this._name;
    }

    public synchronized void setMaxScn(long s) {
        this._scn = s;
        this._lastUpdateTimestamp = System.currentTimeMillis();
    }

    @Override
    public synchronized long getMaxScn() {
        return this._scn;
    }

    @Override
    public synchronized void reset() {
        this._scn = -1L;
        this._lastUpdateTimestamp = 0L;
    }

    protected synchronized boolean registerAsMbean(MBeanServer mbeanServer, boolean register) {
        try {
            Hashtable<String, String> props = new Hashtable<String, String>();
            props.put("type", "SourceDBStatistics");
            props.put("name", this.getSourceName());
            ObjectName objectName = new ObjectName("com.linkedin.databus2", props);
            if (mbeanServer.isRegistered(objectName)) {
                this._log.warn((Object)("Unregistering old DB Statistics  mbean: " + objectName));
                mbeanServer.unregisterMBean(objectName);
            }
            if (register) {
                mbeanServer.registerMBean(this, objectName);
                this._log.info((Object)("Registered DB source statistics statistics mbean: " + objectName));
            }
        }
        catch (Exception ex) {
            if (register) {
                this._log.error((Object)("Failed to register Mbean:" + this.getSourceName()), (Throwable)ex);
            } else {
                this._log.error((Object)("Failed to unregister Mbean:" + this.getSourceName()), (Throwable)ex);
            }
            return false;
        }
        return true;
    }

    public synchronized boolean registerAsMbean(MBeanServer mbeanServer) {
        return this.registerAsMbean(mbeanServer, true);
    }

    public synchronized boolean unregisterAsMbean(MBeanServer mbeanServer) {
        return this.registerAsMbean(mbeanServer, false);
    }

    @Override
    public synchronized long getTimeSinceLastUpdate() {
        return System.currentTimeMillis() - this._lastUpdateTimestamp;
    }
}

