/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachine;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateProcessor;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public abstract class AbstractStateTransitionProcessor
implements StateProcessor {
    private static Map<TransitionElement, HashSet<TransitionElement>> _transitionMapping = new HashMap<TransitionElement, HashSet<TransitionElement>>();
    protected StateProcessor.STATETYPE _currentStateType;
    protected String _currentState;
    public static final String COLUMNSTATE = "column";
    public static final String DBUPDATE = "dbupdate";
    public static final String TRANSACTION = "transaction";
    public static final String COLUMNSSTATE = "columns";
    public static final String TOKENS = "tokens";
    public static final String ROOT = "root";
    public static final String TOKENSTATE = "token";
    public static final String TOKENSSTATE = "tokens";

    private static void addToTransitionMap(TransitionElement key, TransitionElement ... values) {
        HashSet<TransitionElement> possibleStates = new HashSet<TransitionElement>();
        for (int i = 0; i < values.length; ++i) {
            possibleStates.add(values[i]);
        }
        _transitionMapping.put(key, possibleStates);
    }

    public AbstractStateTransitionProcessor(StateProcessor.STATETYPE currentStateType, String currentState) {
        this._currentState = currentState;
        this._currentStateType = currentStateType;
    }

    @Override
    public void processElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws Exception {
        if (!xmlStreamReader.getLocalName().equals(this._currentState)) {
            throw new DatabusException("Unexpected state, expected " + this._currentState + ", found: " + xmlStreamReader.getLocalName());
        }
        if (xmlStreamReader.isEndElement()) {
            this.onEndElement(stateMachine, xmlStreamReader);
        } else {
            this.onStartElement(stateMachine, xmlStreamReader);
        }
    }

    @Override
    public void setNextStateProcessor(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        String nextState = xmlStreamReader.getLocalName();
        StateProcessor.STATETYPE nextStateType = null;
        if (xmlStreamReader.isEndElement()) {
            nextStateType = StateProcessor.STATETYPE.ENDELEMENT;
        } else if (xmlStreamReader.isStartElement()) {
            nextStateType = StateProcessor.STATETYPE.STARTELEMENT;
        } else {
            throw new DatabusException("Neither Start element or End element! cannot transition states");
        }
        this.validateAndSetStateProcessor(stateMachine, this._currentState, this._currentStateType, nextState, nextStateType);
    }

    private void validateAndSetStateProcessor(StateMachine stateMachine, String currentState, StateProcessor.STATETYPE currentStateType, String nextState, StateProcessor.STATETYPE nextStateType) throws DatabusException {
        this.validateNextTransition(stateMachine, currentState, currentStateType, nextState, nextStateType);
        StateProcessor stateProcessor = this.fetchNextState(stateMachine, nextState);
        stateMachine.setProcessState(stateProcessor);
    }

    private StateProcessor fetchNextState(StateMachine stateMachine, String nextState) throws DatabusException {
        if (nextState.equals(TRANSACTION)) {
            return stateMachine.transactionState;
        }
        if (nextState.equals(DBUPDATE)) {
            return stateMachine.dbUpdateState;
        }
        if (nextState.equals(COLUMNSSTATE)) {
            return stateMachine.columnsState;
        }
        if (nextState.equals(COLUMNSTATE)) {
            return stateMachine.columnState;
        }
        if (nextState.equals("tokens")) {
            return stateMachine.tokensState;
        }
        if (nextState.equals(TOKENSTATE)) {
            return stateMachine.tokenState;
        }
        if (nextState.equals(ROOT)) {
            return stateMachine.rootState;
        }
        throw new DatabusException("Unknown state (" + nextState + ")! unable to find a corresponding state processor");
    }

    private void validateNextTransition(StateMachine stateMachine, String currentState, StateProcessor.STATETYPE currentStateType, String nextState, StateProcessor.STATETYPE nextStateType) throws DatabusException {
        TransitionElement startTransition = new TransitionElement(currentStateType, currentState);
        TransitionElement endTransition = new TransitionElement(nextStateType, nextState);
        HashSet<TransitionElement> expectedTranstitions = _transitionMapping.get(startTransition);
        if (expectedTranstitions == null) {
            throw new DatabusException("No mapping found for this particular state " + startTransition + ". The state machine does not know the expected transitions");
        }
        if (!expectedTranstitions.contains(endTransition)) {
            throw new DatabusException("The current state is : " + startTransition + " the expected state was: " + expectedTranstitions + ". The next state found was: " + endTransition);
        }
    }

    static {
        TransitionElement startState = null;
        TransitionElement nextState1 = null;
        TransitionElement nextState2 = null;
        TransitionElement nextState3 = null;
        startState = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, TRANSACTION);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, DBUPDATE);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1);
        startState = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, TRANSACTION);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, TRANSACTION);
        nextState2 = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, ROOT);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1, nextState2);
        startState = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, DBUPDATE);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, COLUMNSSTATE);
        nextState2 = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, DBUPDATE);
        nextState3 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, "tokens");
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1, nextState2, nextState3);
        startState = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, DBUPDATE);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, DBUPDATE);
        nextState2 = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, TRANSACTION);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1, nextState2);
        startState = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, COLUMNSSTATE);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, COLUMNSTATE);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1);
        startState = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, COLUMNSSTATE);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, "tokens");
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1);
        startState = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, "tokens");
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, TOKENSTATE);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1);
        startState = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, "tokens");
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, DBUPDATE);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1);
        startState = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, TOKENSTATE);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, TOKENSTATE);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1);
        startState = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, TOKENSTATE);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, "tokens");
        nextState2 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, TOKENSTATE);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1, nextState2);
        startState = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, COLUMNSTATE);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, COLUMNSTATE);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1);
        startState = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, COLUMNSTATE);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.ENDELEMENT, COLUMNSSTATE);
        nextState2 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, COLUMNSTATE);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1, nextState2);
        startState = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, ROOT);
        nextState1 = new TransitionElement(StateProcessor.STATETYPE.STARTELEMENT, TRANSACTION);
        AbstractStateTransitionProcessor.addToTransitionMap(startState, nextState1);
        _transitionMapping = Collections.unmodifiableMap(_transitionMapping);
    }

    private static class TransitionElement {
        StateProcessor.STATETYPE _statetype;
        String _currentTransitionState;

        TransitionElement(StateProcessor.STATETYPE stateType, String currentTransitionState) {
            this._statetype = stateType;
            this._currentTransitionState = currentTransitionState;
        }

        public String toString() {
            return this._currentTransitionState + "(" + (Object)((Object)this._statetype) + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransitionElement that = (TransitionElement)o;
            if (this._currentTransitionState != null ? !this._currentTransitionState.equals(that._currentTransitionState) : that._currentTransitionState != null) {
                return false;
            }
            return this._statetype == that._statetype;
        }

        public int hashCode() {
            int result = this._statetype != null ? this._statetype.hashCode() : 0;
            result = 31 * result + (this._currentTransitionState != null ? this._currentTransitionState.hashCode() : 0);
            return result;
        }
    }
}

