/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.ggParser.XmlStateMachine.AbstractStateTransitionProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.ColumnState;
import com.linkedin.databus2.ggParser.XmlStateMachine.PrimaryKey;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachine;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachineHelper;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateProcessor;
import com.linkedin.databus2.producers.gg.GGEventGenerationFactory;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;

public class ColumnsState
extends AbstractStateTransitionProcessor {
    public static final String MODULE = ColumnsState.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private Schema _currentSchema;
    private GenericRecord _genericRecord;
    private ArrayList<KeyPair> _keyPairs;
    private final boolean _errorOnMissingFields;
    private boolean _isReplicated;
    public boolean _seenMissingFields = false;
    private String _currentTable;

    public ColumnsState(boolean errorOnMissingFields) {
        super(StateProcessor.STATETYPE.STARTELEMENT, "columns");
        this._errorOnMissingFields = errorOnMissingFields;
    }

    public boolean isSeenMissingFields() {
        return this._seenMissingFields;
    }

    public void setSeenMissingFields(boolean seenMissingFields) {
        this._seenMissingFields = seenMissingFields;
    }

    public GenericRecord getGenericRecord() {
        return this._genericRecord;
    }

    public void setGenericRecord(GenericRecord genericRecord) {
        this._genericRecord = genericRecord;
    }

    public Schema getCurrentSchema() {
        return this._currentSchema;
    }

    public void setCurrentSchema(Schema currentSchema) {
        this._currentSchema = currentSchema;
    }

    public ArrayList<KeyPair> getKeyPairs() {
        return this._keyPairs;
    }

    public void setKeyPairs(ArrayList<KeyPair> keyPairs) {
        this._keyPairs = keyPairs;
    }

    @Override
    public void cleanUpState(StateMachine stateMachine, XMLStreamReader xmlStreamReader) {
        this.setKeyPairs(null);
        this.setCurrentSchema(null);
        this.setGenericRecord(null);
        this.setReplicated(false);
        this.setSeenMissingFields(false);
    }

    @Override
    public void onEndElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws Exception {
        this._currentStateType = StateProcessor.STATETYPE.ENDELEMENT;
        this._genericRecord = this.generateAvroRecord(stateMachine.columnState.getEventFields(), stateMachine.getReplicationBitConfig(), stateMachine.getReplicationValuePattern());
        stateMachine.columnState.cleanUpState(stateMachine, xmlStreamReader);
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    @Override
    public void onStartElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        this._currentStateType = StateProcessor.STATETYPE.STARTELEMENT;
        this._currentTable = stateMachine.dbUpdateState.getCurrentTable();
        stateMachine.columnState.setEventFields(new HashMap<String, ColumnState.EventField>());
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    private GenericRecord generateAvroRecord(HashMap<String, ColumnState.EventField> eventFields, ReplicationBitSetterStaticConfig replicationBitConfig, Pattern replicationValuePattern) throws Exception {
        GenericData.Record record = new GenericData.Record(this.getCurrentSchema());
        List fields = this.getCurrentSchema().getFields();
        String pkFieldName = SchemaHelper.getMetaField((Schema)this.getCurrentSchema(), (String)"pk");
        if (pkFieldName == null) {
            throw new DatabusException("No primary key specified in the schema");
        }
        PrimaryKey pk = new PrimaryKey(pkFieldName);
        for (Schema.Field field : fields) {
            if (field.schema().getType() == Schema.Type.ARRAY) {
                throw new DatabusException("The gg parser cannot handle ARRAY datatypes. Found in field: " + field);
            }
            String databaseFieldName = SchemaHelper.getMetaField((Schema.Field)field, (String)"dbFieldName");
            this.checkNullSafety(eventFields, pk, field, databaseFieldName, replicationBitConfig);
            String fieldValue = this.insertFieldIntoRecord(eventFields, (GenericRecord)record, pkFieldName, pk, field, databaseFieldName);
            if (replicationBitConfig.getSourceType() != ReplicationBitSetterStaticConfig.SourceType.COLUMN || !this.isReplicationField(databaseFieldName, replicationBitConfig)) continue;
            this.setReplicated(StateMachineHelper.verifyReplicationStatus(replicationValuePattern, fieldValue, replicationBitConfig.getMissingValueBehavior()));
        }
        return record;
    }

    private String insertFieldIntoRecord(HashMap<String, ColumnState.EventField> eventFields, GenericRecord record, String pkFieldName, PrimaryKey pk, Schema.Field field, String databaseFieldName) throws DatabusException {
        String fieldValue = eventFields.get(databaseFieldName).getVal();
        boolean isFieldNull = eventFields.get(databaseFieldName).isNull();
        Object fieldValueObj = null;
        try {
            fieldValueObj = !isFieldNull ? GGEventGenerationFactory.stringToAvroType(fieldValue, field) : null;
            record.put(field.name(), fieldValueObj);
        }
        catch (DatabusException e) {
            LOG.error((Object)("Unable to process field: " + field.name()));
            throw e;
        }
        this.constructPkeys(eventFields, pkFieldName, pk, field, databaseFieldName, fieldValueObj);
        return fieldValue;
    }

    private void constructPkeys(HashMap<String, ColumnState.EventField> eventFields, String pkFieldName, PrimaryKey pk, Schema.Field field, String databaseFieldName, Object fieldValueObj) throws DatabusException {
        if (eventFields.get(databaseFieldName).isKey()) {
            if (!pk.isPartOfPrimaryKey(field)) {
                throw new DatabusException("The primary key is not as expected. Expected: " + pkFieldName + " found from xml: " + field.name());
            }
            if (fieldValueObj == null) {
                throw new DatabusException("Unable to find the value of the object");
            }
            Schema.Type pkFieldType = SchemaHelper.unwindUnionSchema((Schema.Field)field).getType();
            KeyPair pair = new KeyPair(fieldValueObj, pkFieldType);
            this._keyPairs.add(pair);
        }
    }

    private void checkNullSafety(HashMap<String, ColumnState.EventField> eventFields, PrimaryKey pk, Schema.Field field, String databaseFieldName, ReplicationBitSetterStaticConfig replicationBitConfig) throws DatabusException {
        if (eventFields.get(databaseFieldName) == null) {
            LOG.error((Object)("Missing field " + databaseFieldName + " in event from the xml trail for table " + this._currentTable));
            if (!this._errorOnMissingFields) {
                if (pk.isPartOfPrimaryKey(field)) {
                    throw new DatabusException("Skip errors on missing DB Fields is true, but cannot proceed because primary key not found: " + field.name());
                }
                if (replicationBitConfig.getSourceType() == ReplicationBitSetterStaticConfig.SourceType.COLUMN && this.isReplicationField(databaseFieldName, replicationBitConfig) && replicationBitConfig.getMissingValueBehavior() == ReplicationBitSetterStaticConfig.MissingValueBehavior.STOP_WITH_ERROR) {
                    throw new DatabusException("Skip errors on missing DB Fields is true, but the replication field is missing, this is mandatory, cannot proceed with  " + field.name() + " field missing");
                }
                this.setSeenMissingFields(true);
                ColumnState.EventField emptyEventField = new ColumnState.EventField(false, null, true);
                eventFields.put(databaseFieldName, emptyEventField);
            } else {
                throw new DatabusException("Unable to find a required field " + databaseFieldName + " in the xml trail file");
            }
        }
    }

    private boolean isReplicationField(String databaseFieldName, ReplicationBitSetterStaticConfig replicationBitConfig) {
        return databaseFieldName.equalsIgnoreCase(replicationBitConfig.getFieldName());
    }

    public boolean isReplicated() {
        return this._isReplicated;
    }

    public void setReplicated(boolean replicated) {
        this._isReplicated = replicated;
    }

    private void prettyPrint(GenericRecord record) {
        try {
            LOG.info((Object)new JSONObject(record.toString()).toString(2));
        }
        catch (JSONException e) {
            LOG.error((Object)"Unable to parser json: The Json created by the generator is not valid!", (Throwable)e);
        }
    }

    public static class KeyPair {
        private final Object _key;
        private final Schema.Type _keyType;

        public Schema.Type getKeyType() {
            return this._keyType;
        }

        public Object getKey() {
            return this._key;
        }

        public KeyPair(Object key, Schema.Type keyType) {
            this._key = key;
            this._keyType = keyType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            KeyPair keyPair = (KeyPair)o;
            if (!this._key.equals(keyPair._key)) {
                return false;
            }
            return this._keyType == keyPair._keyType;
        }

        public int hashCode() {
            int result = this._key.hashCode();
            result = 31 * result + this._keyType.hashCode();
            return result;
        }

        public String toString() {
            return "KeyPair [key=" + this._key + ", keyType=" + this._keyType + "]";
        }
    }
}

