/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.ggParser.XmlStateMachine.AbstractStateTransitionProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.ColumnsState;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachine;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachineHelper;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.XmlStreamReaderHelper;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.log4j.Logger;

public class DbUpdateState
extends AbstractStateTransitionProcessor {
    public static final String TABLEATTR = "table";
    public static final String UPDATEATTRNAME = "type";
    public static final String UPDATEVAL = "update";
    public static final String DELETEATTRNAME = "type";
    public static final String DELETEVAL = "delete";
    public static final String INSERTATTRNAME = "type";
    public static final String INSERTVAL = "insert";
    public static final String PREIMAGEATTRNAME = "image";
    public static final String PREIMAGEVAL = "before";
    public static final String MODULE = DbUpdateState.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    private HashMap<Integer, HashSet<DBUpdateImage>> sourceDbUpdatesMap;
    private String _currentTable;
    private long _scn = -1L;
    private DBUpdateImage.OpType _opType = DBUpdateImage.OpType.UNKNOWN;

    public DbUpdateState() {
        super(StateProcessor.STATETYPE.STARTELEMENT, "dbupdate");
    }

    public HashMap<Integer, HashSet<DBUpdateImage>> getSourceDbUpdatesMap() {
        if (this.sourceDbUpdatesMap == null) {
            this.sourceDbUpdatesMap = new HashMap();
        }
        return this.sourceDbUpdatesMap;
    }

    public void setSourceDbUpdatesMap(HashMap<Integer, HashSet<DBUpdateImage>> sourceDbUpdatesMap) {
        this.sourceDbUpdatesMap = sourceDbUpdatesMap;
    }

    public long getScn() {
        return this._scn;
    }

    public void setScn(long scn) {
        this._scn = scn;
    }

    private HashSet<DBUpdateImage> getHashSet(int sourceId) {
        if (this.sourceDbUpdatesMap == null) {
            this.sourceDbUpdatesMap = new HashMap();
        }
        if (this.sourceDbUpdatesMap.get(sourceId) == null) {
            this.sourceDbUpdatesMap.put(sourceId, new HashSet());
        }
        return this.sourceDbUpdatesMap.get(sourceId);
    }

    @Override
    public void onEndElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        this._currentStateType = StateProcessor.STATETYPE.ENDELEMENT;
        GenericRecord record = stateMachine.columnsState.getGenericRecord();
        long scn = stateMachine.tokensState.getScn();
        if (this._scn < scn) {
            this._scn = scn;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Setting current DbUpdates scn to " + this._scn));
            }
        }
        if (record == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Unable to process the current dbUpdate (record was found to be empty), skipping the dbUpdate");
            }
            this.onError(stateMachine, xmlStreamReader);
            return;
        }
        if (scn == -1L) {
            LOG.error((Object)"Unable to find scn for the given dbUpdate");
            throw new DatabusException("Unable to find scn for the given dbUpdate, terminating the parser");
        }
        if (stateMachine.columnsState.isSeenMissingFields()) {
            LOG.error((Object)("There were missing fields seen in Columns section and the corresponding scn is : " + stateMachine.tokensState.getScn()));
        }
        Boolean isReplicated = false;
        if (stateMachine.getReplicationBitConfig().getSourceType() == ReplicationBitSetterStaticConfig.SourceType.COLUMN) {
            isReplicated = stateMachine.columnsState.isReplicated();
        } else if (stateMachine.getReplicationBitConfig().getSourceType() == ReplicationBitSetterStaticConfig.SourceType.TOKEN) {
            isReplicated = stateMachine.tokensState.isReplicated();
        } else if (stateMachine.getReplicationBitConfig().getSourceType() == ReplicationBitSetterStaticConfig.SourceType.NONE) {
            isReplicated = false;
        } else {
            throw new DatabusException("Unknown source type specified in replicationBitConfig, expected COLUMN or TOKEN or NONE");
        }
        DBUpdateImage eventImage = new DBUpdateImage(stateMachine.columnsState.getKeyPairs(), stateMachine.tokensState.getScn(), stateMachine.columnsState.getGenericRecord(), stateMachine.columnsState.getCurrentSchema(), this._opType, isReplicated);
        Integer sourceId = stateMachine.getTableToSourceId().get(this._currentTable);
        if (sourceId == null) {
            LOG.error((Object)("The table " + this._currentTable + " does not have a sourceId, the current dbUpdate cannot be processed."));
            this.onError(stateMachine, xmlStreamReader);
            return;
        }
        if (this.getHashSet(sourceId) == null) {
            LOG.error((Object)"The hashset is empty, cannot proceed without a valid hashset");
            throw new DatabusException("Error while creating hashset for storing dbUpdates");
        }
        if (this.getHashSet(sourceId) != null && this.getHashSet(sourceId).contains(eventImage)) {
            this.getHashSet(sourceId).remove(eventImage);
        }
        this.getHashSet(sourceId).add(eventImage);
        stateMachine.columnsState.cleanUpState(stateMachine, xmlStreamReader);
        stateMachine.tokensState.cleanUpState(stateMachine, xmlStreamReader);
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    @Override
    public void onStartElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        this._currentStateType = StateProcessor.STATETYPE.STARTELEMENT;
        this._opType = DBUpdateImage.OpType.UNKNOWN;
        boolean isUpdate = false;
        boolean isDelete = false;
        boolean isPreImage = false;
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            if (xmlStreamReader.getAttributeName(i).getLocalPart().equals(TABLEATTR)) {
                this._currentTable = xmlStreamReader.getAttributeValue(i);
                continue;
            }
            if (xmlStreamReader.getAttributeName(i).getLocalPart().equalsIgnoreCase("type") && xmlStreamReader.getAttributeValue(i).equalsIgnoreCase(UPDATEVAL)) {
                this._opType = DBUpdateImage.OpType.UPDATE;
                continue;
            }
            if (xmlStreamReader.getAttributeName(i).getLocalPart().equalsIgnoreCase("type") && xmlStreamReader.getAttributeValue(i).equalsIgnoreCase(DELETEVAL)) {
                this._opType = DBUpdateImage.OpType.DELETE;
                continue;
            }
            if (xmlStreamReader.getAttributeName(i).getLocalPart().equalsIgnoreCase("type") && xmlStreamReader.getAttributeValue(i).equalsIgnoreCase(INSERTVAL)) {
                this._opType = DBUpdateImage.OpType.INSERT;
                continue;
            }
            if (!xmlStreamReader.getAttributeName(i).getLocalPart().equalsIgnoreCase(PREIMAGEATTRNAME) || !xmlStreamReader.getAttributeValue(i).equalsIgnoreCase(PREIMAGEVAL)) continue;
            isPreImage = true;
        }
        if (isPreImage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Skipping current dbUpdate because it's a preimage");
            }
            this.skipCurrentDBupdate(stateMachine, xmlStreamReader);
            return;
        }
        if (this._currentTable == null || this._currentTable.length() == 0) {
            LOG.fatal((Object)"PROBLEM WITH XML: Dbupdate does not have any table name associated with it, stopping ");
            throw new DatabusException("Dbupdate does not have any table name associated with it, stopping");
        }
        Schema schema = StateMachineHelper.tableToSchema(this._currentTable, stateMachine.getTableToSourceNameMap(), stateMachine.getSchemaRegistryService());
        if (schema == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"This source is not configured (couldn't find namespace). Skipping to tokens, to capture scn for empty DBUpdate");
            }
            this.skipToTokens(stateMachine, xmlStreamReader);
            this.setNextStateProcessor(stateMachine, xmlStreamReader);
            return;
        }
        stateMachine.columnsState.setCurrentSchema(schema);
        stateMachine.columnsState.setKeyPairs(new ArrayList<ColumnsState.KeyPair>());
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    public void onError(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        stateMachine.columnsState.cleanUpState(stateMachine, xmlStreamReader);
        stateMachine.tokensState.cleanUpState(stateMachine, xmlStreamReader);
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    @Override
    public void cleanUpState(StateMachine stateMachine, XMLStreamReader xmlStreamReader) {
        this._scn = -1L;
        this.setSourceDbUpdatesMap(null);
        this._currentTable = null;
    }

    public String getCurrentTable() {
        return this._currentTable;
    }

    private void skipCurrentDBupdate(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws XMLStreamException, DatabusException {
        while (xmlStreamReader.hasNext()) {
            XmlStreamReaderHelper.checkAndMoveToNextTagSet(xmlStreamReader);
            if (xmlStreamReader.isEndElement() && xmlStreamReader.getLocalName().equals("dbupdate")) {
                return;
            }
            if (!xmlStreamReader.isEndElement() || !xmlStreamReader.getLocalName().equals("transaction")) continue;
            this.setNextStateProcessor(stateMachine, xmlStreamReader);
            return;
        }
    }

    private void skipToTokens(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws XMLStreamException, DatabusException {
        while (xmlStreamReader.hasNext()) {
            XmlStreamReaderHelper.checkAndMoveToNextTagSet(xmlStreamReader);
            if (!xmlStreamReader.isStartElement() || !xmlStreamReader.getLocalName().equals("tokens")) continue;
            this.setNextStateProcessor(stateMachine, xmlStreamReader);
            return;
        }
    }

    public static class DBUpdateImage {
        private final ArrayList<ColumnsState.KeyPair> _keyPairs;
        private final long _scn;
        private final GenericRecord _genericRecord;
        private final Schema _schema;
        private final OpType _opType;
        private boolean _isReplicated;

        public boolean isReplicated() {
            return this._isReplicated;
        }

        public ArrayList<ColumnsState.KeyPair> getKeyPairs() {
            return this._keyPairs;
        }

        public long getScn() {
            return this._scn;
        }

        public GenericRecord getGenericRecord() {
            return this._genericRecord;
        }

        public Schema getSchema() {
            return this._schema;
        }

        public OpType getOpType() {
            return this._opType;
        }

        public DBUpdateImage(ArrayList<ColumnsState.KeyPair> keyPairs, long scn, GenericRecord genericRecord, Schema schema, OpType opType, boolean isReplicatedFlag) throws DatabusException {
            if (keyPairs.size() == 0) {
                throw new DatabusException("Unable to construct DBUpdateImage because no keys were found");
            }
            if (opType == OpType.UNKNOWN) {
                throw new DatabusException("Unknown operation type, INSERT/UPDATE/DELETE not set?");
            }
            this._keyPairs = keyPairs;
            this._scn = scn;
            this._genericRecord = genericRecord;
            this._schema = schema;
            this._opType = opType;
            this._isReplicated = isReplicatedFlag;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DBUpdateImage that = (DBUpdateImage)o;
            if (this._scn != that._scn) {
                return false;
            }
            return this._keyPairs.equals(that._keyPairs);
        }

        public int hashCode() {
            int result = this._keyPairs.hashCode();
            result = 31 * result + (int)(this._scn ^ this._scn >>> 32);
            return result;
        }

        public static enum OpType {
            UPDATE,
            INSERT,
            DELETE,
            UNKNOWN;

        }
    }
}

