/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus.monitoring.mbean.GGParserStatistics;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.ggParser.XmlStateMachine.AbstractStateTransitionProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.DbUpdateState;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachine;
import com.linkedin.databus2.ggParser.XmlStateMachine.StateProcessor;
import com.linkedin.databus2.ggParser.XmlStateMachine.TransactionSuccessCallBack;
import com.linkedin.databus2.producers.gg.GGEventGenerationFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class TransactionState
extends AbstractStateTransitionProcessor {
    public static final String MODULE = TransactionState.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String TRANSACTIONTIMESTAMPATTR = "timestamp";
    public static final int TRANSACTION_ELEMENT_SIZE = "<transaction timestamp=\"2013-07-29:13:26:15.000000\">".length();
    public TransactionSuccessCallBack _transactionSuccessCallBack;
    private final long UNINITIALIZEDTS = -1L;
    private long _currentTimeStamp = -1L;
    private String _lastSeenTimestampStr = null;
    private long _startTransProcessingTimeNs = 0L;
    private long _startTransLocation = 0L;
    private long _transactionSize = 0L;

    public TransactionState(TransactionSuccessCallBack transactionSuccessCallBack) {
        super(StateProcessor.STATETYPE.STARTELEMENT, "transaction");
        this._transactionSuccessCallBack = transactionSuccessCallBack;
    }

    public long getCurrentTimeStamp() {
        return this._currentTimeStamp;
    }

    public String getLastSeenTxnTimestampStr() {
        return this._lastSeenTimestampStr;
    }

    @Override
    public void cleanUpState(StateMachine stateMachine, XMLStreamReader xmlStreamReader) {
        this._currentTimeStamp = -1L;
        this._startTransProcessingTimeNs = 0L;
        this._transactionSize = 0L;
        this._startTransLocation = 0L;
    }

    @Override
    public void onEndElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws Exception {
        this._currentStateType = StateProcessor.STATETYPE.ENDELEMENT;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("The current transaction has " + stateMachine.dbUpdateState.getSourceDbUpdatesMap().size() + " DbUpdates"));
        }
        if (this._transactionSuccessCallBack == null) {
            throw new DatabusException("No callback specified for the transaction state! Cannot proceed without a callback");
        }
        long endTransactionLocation = xmlStreamReader.getLocation().getCharacterOffset();
        this._transactionSize = endTransactionLocation - this._startTransLocation;
        long trTime = System.nanoTime() - this._startTransProcessingTimeNs;
        long scn = stateMachine.dbUpdateState.getScn();
        GGParserStatistics.TransactionInfo trInfo = new GGParserStatistics.TransactionInfo(this._transactionSize, trTime, this._currentTimeStamp, scn);
        if (stateMachine.dbUpdateState.getSourceDbUpdatesMap().size() == 0) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"The current transaction contains no dbUpdates, giving empty callback");
            }
            this._transactionSuccessCallBack.onTransactionEnd(null, trInfo);
        } else {
            List<PerSourceTransactionalUpdate> dbUpdates = this.sortDbUpdates(stateMachine.dbUpdateState.getSourceDbUpdatesMap());
            this._transactionSuccessCallBack.onTransactionEnd(dbUpdates, trInfo);
        }
        stateMachine.dbUpdateState.cleanUpState(stateMachine, xmlStreamReader);
        this.cleanUpState(stateMachine, xmlStreamReader);
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    @Override
    public void onStartElement(StateMachine stateMachine, XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        this._currentStateType = StateProcessor.STATETYPE.STARTELEMENT;
        for (int i = 0; i < xmlStreamReader.getAttributeCount(); ++i) {
            if (!xmlStreamReader.getAttributeName(i).getLocalPart().equals(TRANSACTIONTIMESTAMPATTR)) continue;
            StringBuilder timeStamp = new StringBuilder(xmlStreamReader.getAttributeValue(i));
            this._lastSeenTimestampStr = timeStamp.toString();
            String correctedTimestamp = timeStamp.append("000").toString();
            this._currentTimeStamp = GGEventGenerationFactory.ggTimeStampStringToNanoSeconds(correctedTimestamp);
        }
        if (this._currentTimeStamp == -1L) {
            throw new DatabusException("Unable to locate timestamp in the transaction tag in the xml");
        }
        if (this._startTransProcessingTimeNs == 0L) {
            this._startTransProcessingTimeNs = System.nanoTime();
            this._startTransLocation = xmlStreamReader.getLocation().getCharacterOffset();
            this._startTransLocation -= (long)TRANSACTION_ELEMENT_SIZE;
        }
        stateMachine.dbUpdateState.setSourceDbUpdatesMap(new HashMap<Integer, HashSet<DbUpdateState.DBUpdateImage>>());
        xmlStreamReader.nextTag();
        this.setNextStateProcessor(stateMachine, xmlStreamReader);
    }

    public void setCallBack(TransactionSuccessCallBack transactionSuccessCallBack) {
        this._transactionSuccessCallBack = transactionSuccessCallBack;
    }

    private List<PerSourceTransactionalUpdate> sortDbUpdates(HashMap<Integer, HashSet<DbUpdateState.DBUpdateImage>> dbUpdates) {
        ArrayList<PerSourceTransactionalUpdate> sourceTransactionalUpdates = new ArrayList<PerSourceTransactionalUpdate>(dbUpdates.size());
        for (Map.Entry<Integer, HashSet<DbUpdateState.DBUpdateImage>> _entry : dbUpdates.entrySet()) {
            sourceTransactionalUpdates.add(new PerSourceTransactionalUpdate(_entry.getKey(), (Set<DbUpdateState.DBUpdateImage>)_entry.getValue()));
        }
        Collections.sort(sourceTransactionalUpdates);
        return sourceTransactionalUpdates;
    }

    public static class PerSourceTransactionalUpdate
    implements Comparable<PerSourceTransactionalUpdate> {
        private int _sourceId;
        private Set<DbUpdateState.DBUpdateImage> _dbUpdate;

        public int getSourceId() {
            return this._sourceId;
        }

        public Set<DbUpdateState.DBUpdateImage> getDbUpdatesSet() {
            return this._dbUpdate;
        }

        public int getNumDbUpdates() {
            if (null == this._dbUpdate) {
                return 0;
            }
            return this._dbUpdate.size();
        }

        public PerSourceTransactionalUpdate(int sourceId, Set<DbUpdateState.DBUpdateImage> dbUpdate) {
            this._sourceId = sourceId;
            this._dbUpdate = dbUpdate;
        }

        @Override
        public int compareTo(PerSourceTransactionalUpdate perSourceTransactionalUpdate) {
            if (this.getSourceId() == perSourceTransactionalUpdate.getSourceId()) {
                LOG.error((Object)"The transactional update list cannot contain duplicate source IDs");
                return 0;
            }
            if (this.getSourceId() < perSourceTransactionalUpdate.getSourceId()) {
                return -1;
            }
            return 1;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PerSourceTransactionalUpdate that = (PerSourceTransactionalUpdate)o;
            if (this._sourceId != that._sourceId) {
                return false;
            }
            return !(this._dbUpdate != null ? !((Object)this._dbUpdate).equals(that._dbUpdate) : that._dbUpdate != null);
        }

        public int hashCode() {
            int result = this._sourceId;
            result = 31 * result + (this._dbUpdate != null ? ((Object)this._dbUpdate).hashCode() : 0);
            return result;
        }
    }
}

