/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.XmlStateMachine;

import com.linkedin.databus2.core.DatabusException;
import java.util.HashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class XmlStreamReaderHelper {
    public static final String MODULE = XmlStreamReaderHelper.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);

    public static String getTextChunkedReader(XMLStreamReader xmlStreamReader) throws XMLStreamException, DatabusException {
        if (xmlStreamReader.getEventType() != 1) {
            throw new DatabusException("The XmlStreamReader is not pointing to a start element");
        }
        StringBuffer sb = new StringBuffer();
        while (xmlStreamReader.hasNext()) {
            int eventType = xmlStreamReader.next();
            if (eventType == 4 || eventType == 12 || eventType == 6 || eventType == 9) {
                sb.append(xmlStreamReader.getText());
                continue;
            }
            if (eventType == 3 || eventType == 5) {
                LOG.error((Object)"Unknown state while processing characters (in method getText())");
                continue;
            }
            if (eventType == 8) {
                throw new DatabusException("Unexpected end of document when reading element text content");
            }
            if (eventType == 1) {
                throw new DatabusException("Element text content may not contain START_ELEMENT");
            }
            throw new DatabusException("Unexpected event type " + eventType);
        }
        return sb.toString();
    }

    public static void skipNewLines(XMLStreamReader xmlStreamReader) throws XMLStreamException {
        if (xmlStreamReader.isCharacters()) {
            while (xmlStreamReader.isCharacters() && xmlStreamReader.hasNext()) {
                xmlStreamReader.next();
            }
        }
    }

    public static void checkAndMoveNext(XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        if (!xmlStreamReader.hasNext()) {
            throw new DatabusException("XmlStream does not have any more data");
        }
        xmlStreamReader.next();
    }

    public static void checkAndMoveToNextTag(XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        if (!xmlStreamReader.hasNext()) {
            throw new DatabusException("XmlStream does not have any more data");
        }
        xmlStreamReader.nextTag();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Deprecated
    public static void checkAndMoveToNextTagSet(XMLStreamReader xmlStreamReader) throws DatabusException, XMLStreamException {
        if (xmlStreamReader.isEndElement()) {
            if (!xmlStreamReader.hasNext()) throw new DatabusException("XmlStream does not have any more data");
            xmlStreamReader.nextTag();
            return;
        } else {
            if (!xmlStreamReader.isStartElement()) throw new DatabusException("Unable to move to nextTag, expected START_ELEMENT or END_ELEMENT");
            XmlStreamReaderHelper.checkAndMoveNext(xmlStreamReader);
            if (xmlStreamReader.isCharacters()) {
                XmlStreamReaderHelper.checkAndMoveToNextTag(xmlStreamReader);
            }
            if (xmlStreamReader.isEndElement()) {
                XmlStreamReaderHelper.checkAndMoveToNextTag(xmlStreamReader);
            }
            if (xmlStreamReader.isStartElement() || xmlStreamReader.isEndElement()) return;
            throw new DatabusException("Inconsistent state, expected cursor state START_ELEMENT or END_ELEMENT");
        }
    }

    public static HashMap<String, String> getAttributeMap(XMLStreamReader xmlStreamReader) {
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        int attributeCount = xmlStreamReader.getAttributeCount();
        for (int i = 0; i < attributeCount; ++i) {
            String attributeName = xmlStreamReader.getAttributeName(i).getLocalPart();
            String attributeValue = xmlStreamReader.getAttributeValue(i);
            attributeMap.put(attributeName, attributeValue);
        }
        return attributeMap;
    }
}

