/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.staxparser;

import java.util.HashMap;
import org.apache.avro.Schema;

public class AvroSchemaHandler {
    HashMap<String, String> dbusToDBFieldNameMap = new HashMap();
    HashMap<String, String> dbusToDBFieldTypeMap = new HashMap();

    public AvroSchemaHandler(Schema schema) throws Exception {
        for (Schema.Field field : schema.getFields()) {
            String dbusFieldName = field.name();
            this.dbusToDBFieldNameMap.put(AvroSchemaHandler.getMetaField(field, "dbFieldName"), dbusFieldName);
            this.dbusToDBFieldTypeMap.put(AvroSchemaHandler.getMetaField(field, "dbFieldType"), dbusFieldName);
        }
    }

    public static String getMetaField(Schema.Field field, String metaFieldName) {
        String[] metaSplit;
        if (field == null) {
            return null;
        }
        String metaValue = field.getProp(metaFieldName);
        if (null != metaValue) {
            return metaValue;
        }
        String meta = field.getProp("meta");
        if (meta == null) {
            return null;
        }
        for (String s : metaSplit = meta.split(";")) {
            int eqIdx = s.indexOf(61);
            if (eqIdx <= 0) continue;
            String itemKey = s.substring(0, eqIdx).trim();
            String itemValue = s.substring(eqIdx + 1).trim();
            field.addProp(itemKey, itemValue);
            if (null != metaValue || !metaFieldName.equals(itemKey)) continue;
            metaValue = itemValue;
        }
        return metaValue;
    }

    public String getDbusFieldName(String dbFieldName) {
        return this.dbusToDBFieldNameMap.get(dbFieldName);
    }
}

