/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.staxparser;

import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.ggParser.XmlStateMachine.TransactionSuccessCallBack;
import com.linkedin.databus2.ggParser.staxparser.XmlParser;
import com.linkedin.databus2.relay.config.LogicalSourceStaticConfig;
import com.linkedin.databus2.relay.config.PhysicalSourceStaticConfig;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import java.io.InputStream;
import java.util.HashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class StaxBuilder {
    private Logger _log;
    private InputStream _inputStream;
    private SchemaRegistryService _schemaRegistry;
    private HashMap<String, String> _tableToNamespace;
    private HashMap<String, Integer> _tableToSourceId;
    private final boolean _errorOnMissingFields;
    TransactionSuccessCallBack _transactionSuccessCallBack;
    XmlParser _parser;
    ReplicationBitSetterStaticConfig _replicationBitConfig;

    public StaxBuilder(SchemaRegistryService schemaRegistry, InputStream inputStream, PhysicalSourceStaticConfig pConfig, TransactionSuccessCallBack transactionSuccessCallBack) throws DatabusException, XMLStreamException {
        String lname = pConfig != null ? pConfig.getName() : "";
        String moduleName = StaxBuilder.class.getName() + ":" + lname;
        this._log = Logger.getLogger((String)moduleName);
        this._transactionSuccessCallBack = transactionSuccessCallBack;
        this._inputStream = inputStream;
        this._schemaRegistry = schemaRegistry;
        this._errorOnMissingFields = pConfig.getErrorOnMissingFields();
        this._replicationBitConfig = pConfig.getReplBitSetter();
        ReplicationBitSetterStaticConfig.MissingValueBehavior mvb = this._replicationBitConfig.getMissingValueBehavior();
        if (mvb != ReplicationBitSetterStaticConfig.MissingValueBehavior.STOP_WITH_ERROR) {
            this._log.warn((Object)("ReplicationBit Setter Config is set to continue parsing and mark events as (" + (mvb == ReplicationBitSetterStaticConfig.MissingValueBehavior.TREAT_EVENT_LOCAL ? "local" : "replicated") + ") when replication-identifier is missing !!"));
        }
        LogicalSourceStaticConfig[] sources = pConfig.getSources();
        this._tableToNamespace = new HashMap();
        this._tableToSourceId = new HashMap();
        if (sources.length == 0) {
            throw new DatabusException("No logical sources found! Nothing to capture here.");
        }
        for (int i = 0; i < sources.length; ++i) {
            String tableName = sources[i].getUri();
            short sourceId = sources[i].getId();
            String name = sources[i].getName();
            this._log.info((Object)("Configuring to capture changes from table: " + tableName + " which has source id: " + sourceId + " and name : " + name));
            this._tableToNamespace.put(tableName, name);
            this._tableToSourceId.put(tableName, Integer.valueOf(sourceId));
        }
        XMLInputFactory factory = XMLInputFactory.newInstance();
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        XMLStreamReader xmlStreamReader = factory.createXMLStreamReader(this._inputStream);
        this._parser = new XmlParser(xmlStreamReader, this._schemaRegistry, this._tableToNamespace, this._tableToSourceId, this._transactionSuccessCallBack, this._errorOnMissingFields, this._replicationBitConfig, inputStream);
    }

    public void processXml() throws Exception {
        try {
            this._parser.start();
        }
        catch (XMLStreamException e) {
            this._log.info((Object)"Unable to parse the given xml stream because of: ", (Throwable)e);
            throw e;
        }
    }

    public XmlParser getParser() {
        return this._parser;
    }
}

