/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.staxparser;

import com.linkedin.databus2.ggParser.XmlStateMachine.StateMachine;
import com.linkedin.databus2.ggParser.XmlStateMachine.TransactionSuccessCallBack;
import com.linkedin.databus2.ggParser.XmlStateMachine.XmlStreamReaderHelper;
import com.linkedin.databus2.relay.config.ReplicationBitSetterStaticConfig;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class XmlParser {
    XMLStreamReader _xmlStreamReader;
    SchemaRegistryService _schemaRegistryService;
    StateMachine _stateMachine;
    AtomicBoolean _shutdownRequested = new AtomicBoolean(false);
    InputStream _inputStream;
    public static final Logger LOG = Logger.getLogger((String)XmlParser.class.getName());

    public XmlParser(XMLStreamReader xmlStreamReader, SchemaRegistryService schemaRegistry, HashMap<String, String> tableMap, HashMap<String, Integer> tableToSourceId, TransactionSuccessCallBack _transactionSuccessCallBack, boolean errorOnMissingFields, ReplicationBitSetterStaticConfig replicationBitConfig, InputStream inputStream) {
        this._xmlStreamReader = xmlStreamReader;
        this._schemaRegistryService = schemaRegistry;
        this._stateMachine = new StateMachine(schemaRegistry, tableMap, tableToSourceId, _transactionSuccessCallBack, errorOnMissingFields, replicationBitConfig);
        this._shutdownRequested.set(false);
        this._inputStream = inputStream;
    }

    public void start() throws Exception {
        block5: {
            XmlStreamReaderHelper.checkAndMoveNext(this._xmlStreamReader);
            try {
                while (!this._shutdownRequested.get() && this._xmlStreamReader.hasNext()) {
                    this._stateMachine.processElement(this._xmlStreamReader);
                }
            }
            catch (NoSuchElementException e) {
                if (!this._shutdownRequested.get()) {
                    throw e;
                }
            }
            catch (XMLStreamException e) {
                if (this._shutdownRequested.get()) break block5;
                throw e;
            }
        }
    }

    public void setShutDownRequested(boolean shutDownRequested) {
        this._shutdownRequested.set(shutDownRequested);
        try {
            this._xmlStreamReader.close();
        }
        catch (XMLStreamException e) {
            LOG.error((Object)"Error while attempting to close the parser: ");
        }
        catch (NoSuchElementException e) {
            LOG.info((Object)"Concurrent stream access while shutdown, it's safe to ignore this.");
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Runtime exception while attempting shutdown, ignoring the exception", (Throwable)e);
        }
        try {
            this._inputStream.close();
        }
        catch (IOException e) {
            LOG.error((Object)"Error while attempting to close the input stream:", (Throwable)e);
        }
        catch (NoSuchElementException e) {
            LOG.info((Object)"Concurrent stream access while shutdown, it's safe to ignore this.");
        }
        catch (RuntimeException e) {
            LOG.error((Object)"Runtime exception while attempting shutdown, ignoring the exception", (Throwable)e);
        }
    }
}

