/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.ggParser.staxparser.validator;

import com.linkedin.databus.core.ConcurrentAppendableCompositeFileInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.io.RandomAccessFile;
import java.io.SequenceInputStream;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.log4j.Logger;

public class XmlFormatTrailParser
implements Runnable {
    private static final long POSITION_REPORT_GAP = 0xA00000L;
    private static final long POSITION_REPORT_TIME_MS = 30000L;
    private static final int ERROR_CONTEXT_LEN = 100;
    private static final String TOKEN_XID = "TK-XID";
    public static final String DTD = "<!DOCTYPE root [ \n<!ELEMENT root (transaction)*> \n<!ELEMENT transaction (dbupdate)*> \n<!ATTLIST transaction \n    timestamp CDATA #REQUIRED \n>\n<!ELEMENT dbupdate (columns, tokens)> \n<!ATTLIST dbupdate \n    table CDATA #REQUIRED \n    type  (insert|delete|update) #REQUIRED \n>\n<!ELEMENT columns (column)+>\n<!ELEMENT column (#PCDATA)>\n<!ATTLIST column \n    name   CDATA #REQUIRED \n    key    (true) #IMPLIED \n    status CDATA #IMPLIED \n>\n<!ELEMENT tokens (token)+>\n<!ELEMENT token (#PCDATA)>\n<!ATTLIST token \n    name CDATA #REQUIRED \n>\n]>\n";
    private final Logger _log;
    private final XMLInputFactory _xmlInputFactory;
    private final XMLStreamReader _xmlStreamReader;
    private final ConcurrentAppendableCompositeFileInputStream _inputStream;
    private final InputStream _realInputStream;
    private final AtomicBoolean _shutdownRequested = new AtomicBoolean(false);
    private Throwable _lastError = null;
    private String _lastFileName = null;
    private long _lastPosition = 0L;
    private String _currentTableName;
    private Map<String, Set<String>> _tableColumns = new HashMap<String, Set<String>>();
    private Set<String> _curTableColumns = new HashSet<String>();
    private Set<String> _curTableTokens = new HashSet<String>();
    private DbupdateType _dbupdateType;
    private final boolean _continueOnError;
    private final PrintStream _errOut;
    private long _errorCount = 0L;

    public XmlFormatTrailParser(ConcurrentAppendableCompositeFileInputStream inputStream, boolean validating, Logger log, String errorLogFile) throws XMLStreamException, IOException {
        this._log = null == log ? Logger.getLogger(XmlFormatTrailParser.class) : log;
        this._inputStream = inputStream;
        this._realInputStream = this.wrapStreamWithXmlTags(this._inputStream);
        this._xmlInputFactory = this.createXmlInputFactory(validating);
        this._xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        this._xmlInputFactory.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
        this._xmlStreamReader = this._xmlInputFactory.createXMLStreamReader(this._realInputStream);
        this._continueOnError = null != errorLogFile;
        this._errOut = this._continueOnError ? new PrintStream(errorLogFile) : null;
    }

    private XMLInputFactory createXmlInputFactory(boolean validating) throws FactoryConfigurationError {
        XMLInputFactory result = null;
        Exception createError = null;
        try {
            Class<?> woodstoxFactory = Class.forName("com.ctc.wstx.stax.WstxInputFactory");
            result = (XMLInputFactory)woodstoxFactory.newInstance();
            if (validating) {
                this._log.info((Object)"found woodstox library: DTD validation will be enabled");
                result.setProperty("javax.xml.stream.isValidating", validating);
            }
        }
        catch (ClassNotFoundException e) {
            createError = e;
        }
        catch (InstantiationException e) {
            createError = e;
        }
        catch (IllegalAccessException e) {
            createError = e;
        }
        catch (RuntimeException e) {
            createError = e;
        }
        if (null != createError) {
            this._log.info((Object)("unable to find woodstox library, defaulting to Java: " + createError));
            if (validating) {
                this._log.warn((Object)"default implementation does not support DTD validation");
            }
            result = XMLInputFactory.newInstance();
        }
        return result;
    }

    private InputStream wrapStreamWithXmlTags(InputStream compositeInputStream) {
        String xmlStart = "<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>\n<!DOCTYPE root [ \n<!ELEMENT root (transaction)*> \n<!ELEMENT transaction (dbupdate)*> \n<!ATTLIST transaction \n    timestamp CDATA #REQUIRED \n>\n<!ELEMENT dbupdate (columns, tokens)> \n<!ATTLIST dbupdate \n    table CDATA #REQUIRED \n    type  (insert|delete|update) #REQUIRED \n>\n<!ELEMENT columns (column)+>\n<!ELEMENT column (#PCDATA)>\n<!ATTLIST column \n    name   CDATA #REQUIRED \n    key    (true) #IMPLIED \n    status CDATA #IMPLIED \n>\n<!ELEMENT tokens (token)+>\n<!ELEMENT token (#PCDATA)>\n<!ATTLIST token \n    name CDATA #REQUIRED \n>\n]>\n\n<root>";
        String xmlEnd = "</root>";
        this._log.info((Object)("The xml start tag used is:" + xmlStart));
        List<InputStream> xmlTagsList = Arrays.asList(new ByteArrayInputStream(xmlStart.getBytes(Charset.forName("ISO-8859-1"))), compositeInputStream, new ByteArrayInputStream(xmlEnd.getBytes(Charset.forName("ISO-8859-1"))));
        Enumeration<InputStream> streams = Collections.enumeration(xmlTagsList);
        SequenceInputStream seqStream = new SequenceInputStream(streams);
        return seqStream;
    }

    public void shutdownAsyncronously() {
        this._shutdownRequested.set(true);
    }

    @Override
    public void run() {
        long lastReportTs = 0L;
        long lastReportedPosition = this._lastPosition;
        long savePos = this._lastPosition;
        try {
            while (!this._shutdownRequested.get() && this._xmlStreamReader.hasNext()) {
                File curFile;
                int eventType = this._xmlStreamReader.next();
                switch (eventType) {
                    case 1: {
                        this.processStartElement();
                        break;
                    }
                    case 2: {
                        this.processEndElement();
                        break;
                    }
                }
                if (null == (curFile = this._inputStream.getCurrentFile()) || this._inputStream.isClosed()) continue;
                String curFileName = curFile.getName();
                long currentTs = System.currentTimeMillis();
                long curPos = this._inputStream.getCurrentPosition();
                if (curPos != savePos) {
                    this._lastPosition = savePos;
                    savePos = curPos;
                }
                if (!curFileName.equals(this._lastFileName) || curPos - lastReportedPosition >= 0xA00000L || currentTs - lastReportTs >= 30000L) {
                    lastReportedPosition = curPos;
                    lastReportTs = currentTs;
                    this._log.info((Object)("file: " + curFileName + "; pos: " + curPos));
                    this.logTablesSeen();
                }
                this._lastFileName = curFileName;
            }
        }
        catch (XMLStreamException e) {
            this._log.error((Object)("xml stream error: " + e), (Throwable)e);
            this._lastError = e;
        }
        catch (RuntimeException e) {
            this._log.error((Object)("runtime error: " + e), (Throwable)e);
            this._lastError = e;
        }
    }

    private void processError(String msg, Throwable e) {
        ++this._errorCount;
        if (this._continueOnError) {
            this._log.error((Object)("PARSE ERROR: " + msg));
            this._errOut.println("=========================================");
            this._errOut.println(String.format("PARSE ERROR %s", msg));
            try {
                this.printErrorContext(this._errOut);
            }
            catch (IOException e1) {
                this._errOut.println("I/O error: " + e1);
            }
        } else {
            if (null != e) {
                throw new RuntimeException(msg);
            }
            throw new RuntimeException(msg, e);
        }
        this._errOut.println("=========================================");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void printErrorContext(PrintStream errOut) throws IOException {
        File file = this._inputStream.getCurrentFile();
        long position = this._inputStream.getCurrentPosition();
        File lastFile = new File(file.getParentFile(), this.getLastFileName());
        errOut.println("error between " + lastFile + " @ " + this.getLastPosition() + " and " + this._inputStream.getCurrentFile() + " @ " + this._inputStream.getCurrentPosition());
        RandomAccessFile f = new RandomAccessFile(file, "r");
        try {
            long startPos = lastFile.equals(file) ? this.getLastPosition() : 0L;
            long endPos = position + 100L;
            int contextSize = (int)(endPos - startPos);
            byte[] context = new byte[contextSize];
            f.seek(startPos);
            if (f.read(context, 0, contextSize) > 0) {
                errOut.println("context: " + new String(context, "ISO-8859-1"));
            } else {
                errOut.println("unable to read XML error context");
            }
        }
        finally {
            f.close();
        }
    }

    private void logTablesSeen() {
        if (this._log.isInfoEnabled()) {
            this._log.info((Object)("Discovered tables:" + this._tableColumns));
        }
    }

    private void processToken(String tokenName) {
        this._curTableTokens.add(tokenName);
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("added token " + tokenName + " for table " + this._currentTableName));
        }
    }

    private void processColumn(String columnName, boolean isKey) {
        if (isKey) {
            this._curTableColumns.add("*" + columnName + "*");
        } else {
            this._curTableColumns.add(columnName);
        }
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("added column " + columnName + " for table " + this._currentTableName));
        }
    }

    private void processEndElement() {
        String elemName = this._xmlStreamReader.getLocalName();
        if ("column".equals(elemName)) {
            this.endColumnElement();
        } else if ("token".equals(elemName)) {
            this.endTokenElement();
        } else if ("dbupdate".equals(elemName)) {
            this.endDbupdateElement();
        }
    }

    private void endDbupdateElement() {
        this.validateTokens();
        this.validateColumns();
        this._dbupdateType = null;
    }

    private void validateColumns() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("validating columns " + this._curTableColumns + " for table " + this._currentTableName));
        }
        if (DbupdateType.DELETE != this._dbupdateType) {
            if (!this._curTableColumns.contains("GG_STATUS")) {
                this.processError("missing GG_STATUS column for table " + this._currentTableName + " update type:" + (Object)((Object)this._dbupdateType), null);
            }
            if (!this._curTableColumns.contains("GG_MODI_TS")) {
                this.processError("missing column GG_MODI_TS for table " + this._currentTableName + " update type:" + (Object)((Object)this._dbupdateType), null);
            }
        }
        if (this._tableColumns.containsKey(this._currentTableName)) {
            Set<String> cols = this._tableColumns.get(this._currentTableName);
            cols.addAll(this._curTableColumns);
        } else {
            this._tableColumns.put(this._currentTableName, new HashSet<String>(this._curTableColumns));
        }
    }

    private void validateTokens() {
        if (this._log.isDebugEnabled()) {
            this._log.debug((Object)("validating tokens " + this._curTableTokens + " for table " + this._currentTableName));
        }
        if (!this._curTableTokens.contains(TOKEN_XID)) {
            this.processError("missing transaction id TK-XID for table " + this._currentTableName, null);
        }
        if (!this._curTableTokens.contains("TK-CSN")) {
            this.processError("missing SCN TK-CSN for table " + this._currentTableName, null);
        }
    }

    private void endTokenElement() {
    }

    private void endColumnElement() {
    }

    private void processStartElement() {
        String elemName = this._xmlStreamReader.getLocalName();
        if ("column".equals(elemName)) {
            this.startColumnElement();
        } else if ("token".equals(elemName)) {
            this.startTokenElement();
        } else if ("dbupdate".equals(elemName)) {
            this.startDbupdateElement();
        }
    }

    private void startDbupdateElement() {
        this._curTableColumns.clear();
        this._curTableTokens.clear();
        this._currentTableName = this._xmlStreamReader.getAttributeValue(null, "table");
        String dbupdateTypeStr = this._xmlStreamReader.getAttributeValue(null, "type");
        if (null == dbupdateTypeStr) {
            this.processError("missing type for <dbupdate> element for table " + this._currentTableName, null);
        }
        try {
            this._dbupdateType = DbupdateType.valueOf(dbupdateTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.processError("unknown <dbupdate> type:" + dbupdateTypeStr, null);
        }
    }

    private void startTokenElement() {
        this.processToken(this._xmlStreamReader.getAttributeValue(null, "name"));
    }

    private void startColumnElement() {
        this.processColumn(this._xmlStreamReader.getAttributeValue(null, "name"), null != this._xmlStreamReader.getAttributeValue(null, "key"));
    }

    public Logger getLog() {
        return this._log;
    }

    public Throwable getLastError() {
        return this._lastError;
    }

    public long getLastPosition() {
        return this._lastPosition;
    }

    public String getLastFileName() {
        return this._lastFileName;
    }

    public long getErrorCount() {
        return this._errorCount;
    }

    private static enum DbupdateType {
        INSERT,
        DELETE,
        UPDATE;

    }
}

