/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers.db;

import com.linkedin.databus.core.ScnTxnPos;
import com.linkedin.databus.core.TrailFilePositionSetter;
import com.linkedin.databus.core.util.RateMonitor;
import com.linkedin.databus2.core.DatabusException;
import java.io.StringReader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class GGXMLTrailTransactionFinder
implements TrailFilePositionSetter.TransactionSCNFinderCallback {
    public static final String MODULE = GGXMLTrailTransactionFinder.class.getName();
    public static final Logger LOG = Logger.getLogger((String)MODULE);
    public static final String TRANSACTION_BEGIN_PREFIX = "<transaction";
    public static final String TRANSACTION_END_PREFIX = "</transaction";
    public static final String TRANSACTION_END_STR = "</transaction>";
    public static final String SCN_XPATH_STR = "//transaction/dbupdate/tokens/token[@name=\"TK-CSN\"]/text()";
    public static final String SCN_REGEX_STR = "(<token\\s+name=\"TK-CSN\"\\s*>([0-9]+)\\s*</token>)";
    public boolean _enableRegex = true;
    private ScnTxnPos _txnPos;
    private ScnTxnPos _prevTxnPos;
    private String _currFile;
    private long _currFileByteOffset;
    private long _currLineNumber;
    private StringBuilder _currTxnStr = new StringBuilder();
    private long _targetScn = -1L;
    private boolean _txnEndSeen = false;
    private long _numTxnsSeen = 0L;
    private long _numInvalidTxnsSeen = 0L;
    private boolean _firstTxnSeen = false;
    private final XPathExpression _expr;
    private final Pattern _rexpr;
    private long _minScn;
    private long _maxScn;
    private RateMonitor _queryRateMonitor = new RateMonitor("Query_GGTransactionFinder");
    private RateMonitor _rateMonitor = new RateMonitor("GGTransactionFinder");
    private boolean _beginTxnSeen = false;

    public GGXMLTrailTransactionFinder(boolean enableRegex) throws Exception {
        this.reset();
        XPathFactory xpathFactory = XPathFactory.newInstance();
        XPath xpath = xpathFactory.newXPath();
        this._expr = xpath.compile(SCN_XPATH_STR);
        this._rexpr = Pattern.compile(SCN_REGEX_STR);
        this._enableRegex = enableRegex;
        this._minScn = Long.MAX_VALUE;
        this._maxScn = Long.MIN_VALUE;
    }

    public GGXMLTrailTransactionFinder() throws Exception {
        this(true);
    }

    @Override
    public void beginFileProcessing(String file) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Switching to file :" + file));
        }
        this._currFile = file;
        this._currLineNumber = 0L;
        this._currFileByteOffset = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processLine(String line, int newLineCharLen) throws DatabusException {
        try {
            boolean ret;
            block12: {
                this._rateMonitor.resume();
                this._rateMonitor.ticks((long)line.length());
                String l = line;
                int totalOffset = 0;
                ret = false;
                int beginOffset = l.indexOf(TRANSACTION_BEGIN_PREFIX);
                int endOffset = l.indexOf(TRANSACTION_END_PREFIX);
                if (beginOffset >= 0 || endOffset >= 0) {
                    do {
                        this._txnEndSeen = false;
                        beginOffset = l.indexOf(TRANSACTION_BEGIN_PREFIX);
                        endOffset = l.indexOf(TRANSACTION_END_PREFIX);
                        if (beginOffset >= 0) {
                            totalOffset += beginOffset;
                        }
                        if (endOffset == -1 && beginOffset == -1) break block12;
                        if (endOffset == -1 || beginOffset >= 0 && beginOffset < endOffset) {
                            this._currTxnStr.setLength(0);
                            this.processBegin(totalOffset);
                            if (endOffset == -1) {
                                this._currTxnStr.append(l);
                                break block12;
                            }
                            this._currTxnStr.append(l.subSequence(beginOffset, endOffset));
                            this._currTxnStr.append(TRANSACTION_END_STR);
                            this.processEnd();
                            totalOffset += endOffset + TRANSACTION_END_STR.length();
                            l = l.substring(endOffset + TRANSACTION_END_STR.length());
                            continue;
                        }
                        if (beginOffset != -1 && beginOffset <= endOffset) continue;
                        if (beginOffset == -1) {
                            this._currTxnStr.append(l);
                            this.processEnd();
                            if (this.isDone()) {
                                ret = true;
                            }
                            break block12;
                        }
                        this._currTxnStr.append(l.subSequence(0, beginOffset));
                        l = l.substring(beginOffset);
                        this.processEnd();
                    } while (!this.isDone());
                    ret = true;
                } else {
                    this._currTxnStr.append(l);
                }
            }
            this._currFileByteOffset += (long)line.length();
            if (newLineCharLen > 0) {
                this._currFileByteOffset += (long)newLineCharLen;
            }
            ++this._currLineNumber;
            boolean bl = ret;
            return bl;
        }
        finally {
            this._rateMonitor.suspend();
        }
    }

    private boolean isDone() {
        return this._txnEndSeen && (this._targetScn == -2L || this._targetScn != -1L && this._txnPos.getMaxScn() >= this._targetScn);
    }

    private void processBegin(int byteLineOffset) {
        this._prevTxnPos.copyFrom(this._txnPos);
        this._txnPos.setFile(this._currFile);
        this._txnPos.setFileOffset(this._currFileByteOffset + (long)byteLineOffset);
        this._txnPos.setLineNumber(this._currLineNumber + 1L);
        this._txnPos.setLineOffset(byteLineOffset);
        this._txnPos.setMinScn(-1L);
        this._txnPos.setMaxScn(-1L);
        this._txnPos.setTxnRank(this._numTxnsSeen);
        this._beginTxnSeen = true;
    }

    private void xpathQuery() throws DatabusTrailFileParseException {
        try {
            InputSource source = new InputSource(new StringReader(this._currTxnStr.toString()));
            this._queryRateMonitor.resume();
            Object result = this._expr.evaluate(source, XPathConstants.NODESET);
            this._queryRateMonitor.ticks((long)this._currTxnStr.length());
            this._queryRateMonitor.suspend();
            NodeList nodes = (NodeList)result;
            for (int i = 0; i < nodes.getLength(); ++i) {
                long newScn = Long.parseLong(nodes.item(i).getNodeValue().trim());
                this._minScn = Math.min(this._minScn, newScn);
                this._maxScn = Math.max(this._maxScn, newScn);
            }
        }
        catch (XPathExpressionException xpxe) {
            throw new DatabusTrailFileParseException("Got XPath exception for trail-file entry: " + this._currTxnStr, xpxe);
        }
        catch (NumberFormatException nfe) {
            throw new DatabusTrailFileParseException("Got parseLong() exception for trail-file entry: " + this._currTxnStr, nfe);
        }
    }

    private void regexQuery() throws DatabusTrailFileParseException {
        String source = this._currTxnStr.toString();
        this._queryRateMonitor.resume();
        Matcher result = this._rexpr.matcher(source);
        boolean foundScn = result.find();
        this._queryRateMonitor.ticks((long)source.length());
        this._queryRateMonitor.suspend();
        if (!foundScn) {
            throw new DatabusTrailFileParseException("Could not find TK-SCN with regex; likely error in trail-file entry: " + this._currTxnStr);
        }
        while (foundScn) {
            String m = result.group(2);
            long newScn = Long.parseLong(m);
            this._minScn = Math.min(this._minScn, newScn);
            this._maxScn = Math.max(this._maxScn, newScn);
            this._queryRateMonitor.resume();
            foundScn = result.find();
            this._queryRateMonitor.suspend();
        }
    }

    private void processEnd() throws DatabusException {
        if (!this._beginTxnSeen) {
            this._currTxnStr.setLength(0);
            return;
        }
        this._maxScn = -1L;
        this._minScn = Long.MAX_VALUE;
        try {
            if (!this._enableRegex) {
                this.xpathQuery();
            } else {
                this.regexQuery();
            }
        }
        catch (DatabusTrailFileParseException ex) {
            LOG.warn((Object)("empty/corrupted txn (" + ex.getMessage() + "); resetting invalid _txnPos (" + this._txnPos + ") to _prevTxnPos (" + this._prevTxnPos + ")"));
            this._txnPos.copyFrom(this._prevTxnPos);
            ++this._numInvalidTxnsSeen;
            return;
        }
        this._txnPos.setMaxScn(this._maxScn);
        this._txnPos.setMinScn(this._minScn);
        this._txnEndSeen = true;
        ++this._numTxnsSeen;
        if (!this._firstTxnSeen && this._targetScn >= 0L && this._targetScn < this._minScn) {
            throw new DatabusException("SinceSCN is less than MinScn available in trail file. Requested SinceSCN is :" + this._targetScn + " but found only : " + this._minScn + " in Location " + this._txnPos);
        }
        this._firstTxnSeen = true;
        this._beginTxnSeen = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Seen Txn : " + this._txnPos));
        }
    }

    @Override
    public void endFileProcessing(String file) {
    }

    @Override
    public ScnTxnPos getTxnPos() {
        if (this._txnPos.isEmpty() && this._prevTxnPos.isEmpty()) {
            return null;
        }
        if (this._txnPos.isEmpty()) {
            return this._prevTxnPos;
        }
        return this._txnPos;
    }

    @Override
    public void reset() {
        this._txnPos = new ScnTxnPos();
        this._prevTxnPos = new ScnTxnPos();
        this._currFile = null;
        this._currFileByteOffset = 0L;
        this._currLineNumber = 0L;
        this._numTxnsSeen = 0L;
        this._numInvalidTxnsSeen = 0L;
        this._txnEndSeen = false;
        this._beginTxnSeen = false;
        this._firstTxnSeen = false;
        this._currTxnStr.setLength(0);
        this._queryRateMonitor = new RateMonitor("XPath_GGTransactionFinder");
        this._queryRateMonitor.start();
        this._queryRateMonitor.suspend();
        this._rateMonitor = new RateMonitor("GGTransactionFinder");
        this._rateMonitor.start();
        this._rateMonitor.suspend();
    }

    @Override
    public void begin(long targetScn) {
        this._targetScn = targetScn;
    }

    @Override
    public long getNumTxnsSeen() {
        return this._numTxnsSeen;
    }

    @Override
    public long getCurrentFileOffset() {
        return this._currFileByteOffset;
    }

    public RateMonitor getQueryRateMonitor() {
        return this._queryRateMonitor;
    }

    public RateMonitor getRateMonitor() {
        return this._queryRateMonitor;
    }

    @Override
    public String getPerfStats() {
        String overallRateMonitor = this._rateMonitor.toString();
        String queryRateMonitor = this._queryRateMonitor.toString();
        return "queryRM : " + queryRateMonitor + ", OverallRM : " + overallRateMonitor;
    }

    private class DatabusTrailFileParseException
    extends Exception {
        public DatabusTrailFileParseException() {
        }

        public DatabusTrailFileParseException(String message, Throwable cause) {
            super(message, cause);
        }

        public DatabusTrailFileParseException(String message) {
            super(message);
        }

        public DatabusTrailFileParseException(Throwable cause) {
            super(cause);
        }
    }
}

