/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers.db;

import com.linkedin.databus.container.netty.HttpRelay;
import com.linkedin.databus.core.util.PhysicalSourceConfigBuilder;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.relay.AbstractRelayFactory;
import com.linkedin.databus2.relay.RelayFactory;
import com.linkedin.databus2.schemas.SchemaRegistryService;
import com.linkedin.databus2.schemas.StandardSchemaRegistryFactory;
import java.io.IOException;

public class OracleRelayFactory
extends AbstractRelayFactory
implements RelayFactory {
    private final HttpRelay.Config _relayConfigBuilder;
    private final String[] _physicalSourcesConfigFiles;
    private final StandardSchemaRegistryFactory _schemaRegistryFactory;

    public OracleRelayFactory(HttpRelay.Config relayConfigBuilder, String[] physicalSourcesConfigFiles) {
        this._relayConfigBuilder = relayConfigBuilder;
        this._physicalSourcesConfigFiles = physicalSourcesConfigFiles;
        this._schemaRegistryFactory = new StandardSchemaRegistryFactory(relayConfigBuilder.getSchemaRegistry());
    }

    public HttpRelay.Config getRelayConfigBuilder() {
        return this._relayConfigBuilder;
    }

    @Override
    public HttpRelay createRelay() throws DatabusException {
        try {
            SchemaRegistryService schemaRegistry = this._schemaRegistryFactory.createSchemaRegistry();
            HttpRelay.StaticConfig relayStaticConfig = this._relayConfigBuilder.build();
            this.getSourcesIdNameRegistry().updateFromIdNamePairs(relayStaticConfig.getSourceIds());
            PhysicalSourceConfigBuilder psourceConfBuilder = new PhysicalSourceConfigBuilder(this._physicalSourcesConfigFiles);
            return new HttpRelay(relayStaticConfig, psourceConfBuilder.build(), this.getSourcesIdNameRegistry(), schemaRegistry);
        }
        catch (IOException ioe) {
            throw new DatabusException("OracleRelay instantiation error: " + ioe.getMessage(), (Throwable)ioe);
        }
    }
}

