/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.databus2.producers.gg;

import com.linkedin.databus.core.util.InvalidConfigException;
import com.linkedin.databus2.core.DatabusException;
import com.linkedin.databus2.producers.ConstantPartitionFunction;
import com.linkedin.databus2.producers.PartitionFunction;
import com.linkedin.databus2.relay.config.LogicalSourceStaticConfig;
import com.linkedin.databus2.schemas.utils.SchemaHelper;
import java.nio.charset.Charset;
import java.sql.Date;
import java.util.Calendar;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.avro.Schema;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.log4j.Logger;

public class GGEventGenerationFactory {
    private final Logger log = Logger.getLogger(this.getClass());

    public static PartitionFunction buildPartitionFunction(LogicalSourceStaticConfig sourceConfig) throws InvalidConfigException {
        String partitionFunction = sourceConfig.getPartitionFunction();
        if (partitionFunction.startsWith("constant:")) {
            try {
                String numberPart = partitionFunction.substring("constant:".length()).trim();
                short constantPartitionNumber = Short.valueOf(numberPart);
                return new ConstantPartitionFunction(constantPartitionNumber);
            }
            catch (Exception ex) {
                throw new InvalidConfigException("Invalid partition configuration (" + partitionFunction + "). " + "Could not parse the constant partition number.");
            }
        }
        throw new InvalidConfigException("Invalid partition configuration (" + partitionFunction + ").");
    }

    public static String uriToGGDir(String uri) throws DatabusException {
        if (uri == null) {
            throw new DatabusException("uri passed is null and not valid");
        }
        Pattern pattern = Pattern.compile("gg://(.*):(.*)");
        Matcher matcher = pattern.matcher(uri);
        if (!matcher.matches() || matcher.groupCount() != 2) {
            throw new DatabusException("Expected uri format for gg path not found");
        }
        return matcher.group(1);
    }

    public static String uriToXmlPrefix(String uri) throws DatabusException {
        if (uri == null) {
            throw new DatabusException("uri passed is null and not valid");
        }
        Pattern pattern = Pattern.compile("gg://(.*):(.*)");
        Matcher matcher = pattern.matcher(uri);
        if (!matcher.matches() || matcher.groupCount() != 2) {
            throw new DatabusException("Expected uri format for gg path not found");
        }
        return matcher.group(2);
    }

    public static Object stringToAvroType(String fieldValue, Schema.Field avroField) throws DatabusException {
        Schema.Type fieldType = SchemaHelper.getAnyType((Schema.Field)avroField);
        String recordFieldName = avroField.name();
        switch (fieldType) {
            case BOOLEAN: 
            case BYTES: 
            case DOUBLE: 
            case FLOAT: 
            case INT: 
            case LONG: 
            case STRING: 
            case NULL: {
                return GGEventGenerationFactory.convertToSimpleType(fieldValue, avroField);
            }
            case RECORD: 
            case ARRAY: {
                throw new DatabusException("Handling of Avro '" + fieldType + "' field type not yet implemented!");
            }
        }
        throw new DatabusException("unknown field type: " + recordFieldName + ":" + fieldType);
    }

    public static Object convertToSimpleType(String fieldValue, Schema.Field avroField) throws DatabusException {
        String databaseFieldType = SchemaHelper.getMetaField((Schema.Field)avroField, (String)"dbFieldType");
        String recordFieldName = avroField.name();
        if (databaseFieldType.equalsIgnoreCase("INTEGER")) {
            return new Integer(fieldValue);
        }
        if (databaseFieldType.equalsIgnoreCase("LONG")) {
            return new Long(fieldValue);
        }
        if (databaseFieldType.equalsIgnoreCase("DATE")) {
            return GGEventGenerationFactory.ggDateStringToLong(fieldValue);
        }
        if (databaseFieldType.equalsIgnoreCase("TIMESTAMP")) {
            return GGEventGenerationFactory.ggTimeStampStringToMilliSeconds(fieldValue);
        }
        if (databaseFieldType.equalsIgnoreCase("FLOAT")) {
            return new Float(fieldValue);
        }
        if (databaseFieldType.equalsIgnoreCase("DOUBLE")) {
            return new Double(fieldValue);
        }
        if (databaseFieldType.equalsIgnoreCase("CLOB")) {
            return fieldValue;
        }
        if (databaseFieldType.equalsIgnoreCase("VARCHAR")) {
            return fieldValue;
        }
        if (databaseFieldType.equalsIgnoreCase("VARCHAR2")) {
            return fieldValue;
        }
        if (databaseFieldType.equalsIgnoreCase("NVARCHAR")) {
            return fieldValue;
        }
        if (databaseFieldType.equalsIgnoreCase("NVARCHAR2")) {
            return fieldValue;
        }
        if (databaseFieldType.equalsIgnoreCase("XMLTYPE")) {
            return fieldValue;
        }
        if (databaseFieldType.equalsIgnoreCase("CHAR")) {
            return fieldValue;
        }
        if (databaseFieldType.equalsIgnoreCase("BLOB") || databaseFieldType.equalsIgnoreCase("RAW")) {
            if (fieldValue.length() == 0) {
                return fieldValue.getBytes(Charset.defaultCharset());
            }
            if (fieldValue.length() <= 2) {
                throw new DatabusException("Unable to decode the string because length is less than 2");
            }
            if (!GGEventGenerationFactory.isStringHex(fieldValue)) {
                throw new DatabusException("Unable to decode the string because it is not hex-encoded");
            }
            try {
                return GGEventGenerationFactory.stringToHex(fieldValue.substring(2, fieldValue.length() - 1));
            }
            catch (DecoderException e) {
                throw new DatabusException("Unable to decode a " + databaseFieldType + " field: " + recordFieldName);
            }
        }
        if (databaseFieldType.equalsIgnoreCase("ARRAY")) {
            throw new DatabusException("ARRAY type still not implemented!");
        }
        if (databaseFieldType.equalsIgnoreCase("TABLE")) {
            throw new DatabusException("TABLE type still not implemented!");
        }
        throw new DatabusException("unknown field type: " + recordFieldName + ":" + databaseFieldType);
    }

    public static boolean isStringHex(String fieldValue) {
        if (fieldValue == null || fieldValue.length() <= 2) {
            return false;
        }
        return fieldValue.substring(0, 2).equals("0x");
    }

    public static byte[] stringToHex(String hexString) throws DecoderException {
        return Hex.decodeHex((char[])hexString.toCharArray());
    }

    public static long ggTimeStampStringToNanoSeconds(String value) throws DatabusException {
        return GGEventGenerationFactory.ggTimeStampStringToMilliSeconds(value) * 1000000L;
    }

    public static long ggTimeStampStringToMilliSeconds(String value) throws DatabusException {
        Pattern _pattern = Pattern.compile("(\\d{4})-(\\d{2})-(\\d{2}):(\\d{2}):(\\d{2}):(\\d{2})\\.(\\d{0,9})");
        Matcher matcher = _pattern.matcher(value);
        if (!matcher.matches() || matcher.groupCount() != 7) {
            throw new DatabusException("The timestamp format is not as expected, cannot proceed!");
        }
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.set(14, 0);
        calendar.set(Integer.valueOf(matcher.group(1)), Integer.valueOf(matcher.group(2)) - 1, Integer.valueOf(matcher.group(3)), Integer.valueOf(matcher.group(4)), Integer.valueOf(matcher.group(5)), Integer.valueOf(matcher.group(6)));
        String milliSecondsString = matcher.group(7);
        int maxSecondsLength = milliSecondsString.length() > 3 ? 3 : milliSecondsString.length();
        String prunedMilliSeconds = milliSecondsString.substring(0, maxSecondsLength);
        calendar.add(14, Integer.valueOf(prunedMilliSeconds));
        return calendar.getTimeInMillis();
    }

    public static long ggDateStringToLong(String value) throws DatabusException {
        Pattern _pattern = Pattern.compile("(\\d{4}-\\d{2}-\\d{2}).*");
        Matcher matcher = _pattern.matcher(value);
        if (!matcher.matches() || matcher.groupCount() != 1) {
            throw new DatabusException("The date format is not as expected, cannot proceed!");
        }
        String dateFormatString = matcher.group(1);
        long dateLong = Date.valueOf(dateFormatString).getTime();
        return dateLong;
    }
}

